/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.container;

import java.io.Serializable;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.jbi.framework.ComponentNameSpace;
import org.apache.servicemix.jbi.framework.Registry;
import org.apache.servicemix.jbi.messaging.ExchangePacket;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;
import org.apache.servicemix.jbi.resolver.SubscriptionFilter;
import org.apache.servicemix.jbi.servicedesc.InternalEndpoint;

public class SubscriptionSpec
implements Serializable {
    private static final long serialVersionUID = 8458586342841647313L;
    private QName service;
    private QName interfaceName;
    private QName operation;
    private String endpoint;
    private transient SubscriptionFilter filter;
    private ComponentNameSpace name;

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public SubscriptionFilter getFilter() {
        return this.filter;
    }

    public void setFilter(SubscriptionFilter filter) {
        this.filter = filter;
    }

    public QName getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(QName interfaceName) {
        this.interfaceName = interfaceName;
    }

    public QName getOperation() {
        return this.operation;
    }

    public void setOperation(QName operation) {
        this.operation = operation;
    }

    public QName getService() {
        return this.service;
    }

    public void setService(QName service) {
        this.service = service;
    }

    public ComponentNameSpace getName() {
        return this.name;
    }

    public void setName(ComponentNameSpace name) {
        this.name = name;
    }

    public boolean matches(Registry registry, MessageExchangeImpl exchange) {
        boolean result = false;
        ExchangePacket packet = exchange.getPacket();
        ComponentNameSpace sourceId = packet.getSourceId();
        if (sourceId != null) {
            InternalEndpoint se;
            int i;
            ServiceEndpoint[] ses;
            if (this.service != null && (ses = registry.getEndpointsForService(this.service)) != null) {
                for (i = 0; i < ses.length; ++i) {
                    se = (InternalEndpoint)ses[i];
                    if (se.getComponentNameSpace() == null || !se.getComponentNameSpace().equals(sourceId)) continue;
                    result = true;
                    break;
                }
            }
            if (result && this.interfaceName != null && (ses = registry.getEndpointsForInterface(this.interfaceName)) != null) {
                result = false;
                for (i = 0; i < ses.length; ++i) {
                    se = (InternalEndpoint)ses[i];
                    if (se.getComponentNameSpace() == null || !se.getComponentNameSpace().equals(sourceId)) continue;
                    result = true;
                    break;
                }
            }
        }
        if (this.service == null && this.interfaceName == null) {
            result = true;
        }
        if (result && this.filter != null) {
            result = this.filter.matches(exchange);
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof SubscriptionSpec) {
            SubscriptionSpec other = (SubscriptionSpec)obj;
            result = (this.name == null && other.name == null || this.name.equals(other.name)) && this.service == null && other.service == null || this.service != null && other.service != null && this.service.equals(other.service) && this.interfaceName == null && other.interfaceName == null || this.interfaceName != null && other.interfaceName != null && this.interfaceName.equals(other.interfaceName) && this.endpoint == null && other.endpoint == null || this.endpoint != null && other.endpoint != null && this.endpoint.equals(other.endpoint);
        }
        return result;
    }

    public int hashCode() {
        return (this.name != null ? this.name.hashCode() : 0) ^ (this.service != null ? this.service.hashCode() : (this.interfaceName != null ? this.interfaceName.hashCode() : super.hashCode()));
    }
}

