/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import java.beans.PropertyChangeListener;
import java.net.URI;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.client.ServiceMixClient;
import org.apache.servicemix.jbi.FaultException;
import org.apache.servicemix.jbi.framework.EndpointMBean;
import org.apache.servicemix.jbi.framework.Registry;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.jbi.management.AttributeInfoHelper;
import org.apache.servicemix.jbi.management.MBeanInfoProvider;
import org.apache.servicemix.jbi.management.OperationInfoHelper;
import org.apache.servicemix.jbi.servicedesc.AbstractServiceEndpoint;
import org.apache.servicemix.jbi.servicedesc.ExternalEndpoint;
import org.apache.servicemix.jbi.servicedesc.InternalEndpoint;
import org.apache.servicemix.jbi.servicedesc.LinkedEndpoint;
import org.apache.servicemix.jbi.util.DOMUtil;
import org.apache.servicemix.jbi.util.QNameUtil;

public class Endpoint
implements EndpointMBean,
MBeanInfoProvider {
    private static final Log LOG = LogFactory.getLog(Endpoint.class);
    private AbstractServiceEndpoint endpoint;
    private Registry registry;

    public Endpoint(AbstractServiceEndpoint endpoint, Registry registry) {
        this.endpoint = endpoint;
        this.registry = registry;
    }

    public String getEndpointName() {
        return this.endpoint.getEndpointName();
    }

    public QName[] getInterfaces() {
        return this.endpoint.getInterfaces();
    }

    public QName getServiceName() {
        return this.endpoint.getServiceName();
    }

    public String loadReference() {
        try {
            return DOMUtil.asIndentedXML(this.endpoint.getAsReference(null));
        }
        catch (TransformerException e) {
            return null;
        }
    }

    public String loadWSDL() {
        try {
            return DOMUtil.asXML(this.registry.getEndpointDescriptor(this.endpoint));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getComponentName() {
        if (this.endpoint.getComponentNameSpace() != null) {
            return this.endpoint.getComponentNameSpace().getName();
        }
        return null;
    }

    public MBeanAttributeInfo[] getAttributeInfos() throws JMException {
        AttributeInfoHelper helper = new AttributeInfoHelper();
        helper.addAttribute(this.getObjectToManage(), "endpointName", "name of the endpoint");
        helper.addAttribute(this.getObjectToManage(), "serviceName", "name of the service");
        helper.addAttribute(this.getObjectToManage(), "componentName", "component name of the service unit");
        helper.addAttribute(this.getObjectToManage(), "interfaces", "interfaces implemented by this endpoint");
        return helper.getAttributeInfos();
    }

    public MBeanOperationInfo[] getOperationInfos() throws JMException {
        OperationInfoHelper helper = new OperationInfoHelper();
        helper.addOperation(this.getObjectToManage(), "loadReference", "retrieve the endpoint reference");
        helper.addOperation(this.getObjectToManage(), "loadWSDL", "retrieve the wsdl description of this endpoint");
        helper.addOperation(this.getObjectToManage(), "send", "send a simple message exchange to test this endpoint");
        return helper.getOperationInfos();
    }

    public Object getObjectToManage() {
        return this;
    }

    public String getName() {
        return this.endpoint.getServiceName() + this.endpoint.getEndpointName();
    }

    public String getType() {
        return "Endpoint";
    }

    public String getSubType() {
        if (this.endpoint instanceof InternalEndpoint) {
            return "Internal";
        }
        if (this.endpoint instanceof LinkedEndpoint) {
            return "Linked";
        }
        if (this.endpoint instanceof ExternalEndpoint) {
            return "External";
        }
        return null;
    }

    public String getDescription() {
        return null;
    }

    public void setPropertyChangeListener(PropertyChangeListener l) {
    }

    protected AbstractServiceEndpoint getEndpoint() {
        return this.endpoint;
    }

    public String send(String content, String operation, String mep) {
        ServiceMixClient client = null;
        try {
            client = this.registry.getContainer().getClientFactory().createClient();
            MessageExchange me = client.getExchangeFactory().createExchange(URI.create(mep));
            NormalizedMessage nm = me.createMessage();
            me.setMessage(nm, "in");
            nm.setContent((Source)new StringSource(content));
            me.setEndpoint((ServiceEndpoint)this.endpoint);
            if (operation != null) {
                me.setOperation(QNameUtil.parse(operation));
            }
            client.sendSync(me);
            if (me.getError() != null) {
                throw me.getError();
            }
            if (me.getFault() != null) {
                throw FaultException.newInstance(me);
            }
            if (me.getMessage("out") != null) {
                String string = new SourceTransformer().contentToString(me.getMessage("out"));
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            LOG.debug((Object)"Error proces test exchange", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

