/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.jbi.JBIException;
import javax.jbi.component.Bootstrap;
import javax.jbi.component.InstallationContext;
import javax.jbi.management.DeploymentException;
import javax.jbi.management.InstallerMBean;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.deployment.Component;
import org.apache.servicemix.jbi.framework.ComponentContextImpl;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.framework.InstallationContextImpl;
import org.apache.servicemix.jbi.framework.SharedLibrary;
import org.apache.xbean.classloader.DestroyableClassLoader;
import org.apache.xbean.classloader.JarFileClassLoader;

public class InstallerMBeanImpl
implements InstallerMBean {
    private static final Log LOG = LogFactory.getLog(InstallerMBeanImpl.class);
    private InstallationContextImpl context;
    private JBIContainer container;
    private ObjectName objectName;
    private ObjectName extensionMBeanName;
    private Bootstrap bootstrap;
    private boolean initialized;

    public InstallerMBeanImpl(JBIContainer container, InstallationContextImpl ic) throws DeploymentException {
        this.container = container;
        this.context = ic;
        this.bootstrap = this.createBootstrap();
        this.initBootstrap();
    }

    private void initBootstrap() throws DeploymentException {
        block6: {
            try {
                if (this.initialized) break block6;
                try {
                    if (this.extensionMBeanName != null && this.container.getMBeanServer() != null && this.container.getMBeanServer().isRegistered(this.extensionMBeanName)) {
                        this.container.getMBeanServer().unregisterMBean(this.extensionMBeanName);
                    }
                }
                catch (InstanceNotFoundException e) {
                }
                catch (MBeanRegistrationException e) {
                    // empty catch block
                }
                this.bootstrap.init((InstallationContext)this.context);
                this.extensionMBeanName = this.bootstrap.getExtensionMBeanName();
                this.initialized = true;
            }
            catch (JBIException e) {
                LOG.error((Object)"Could not initialize bootstrap", (Throwable)e);
                throw new DeploymentException((Throwable)e);
            }
        }
    }

    protected void cleanUpBootstrap() throws DeploymentException {
        try {
            this.bootstrap.cleanUp();
        }
        catch (JBIException e) {
            LOG.error((Object)"Could not initialize bootstrap", (Throwable)e);
            throw new DeploymentException((Throwable)e);
        }
        finally {
            this.initialized = false;
        }
    }

    private Bootstrap createBootstrap() throws DeploymentException {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Component descriptor = this.context.getDescriptor();
        try {
            ClassLoader cl = this.buildClassLoader(this.context.getInstallRootAsDir(), descriptor.getBootstrapClassPath().getPathElements(), descriptor.isBootstrapClassLoaderDelegationParentFirst(), null);
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> bootstrapClass = cl.loadClass(descriptor.getBootstrapClassName());
            Bootstrap bootstrap = (Bootstrap)bootstrapClass.newInstance();
            return bootstrap;
        }
        catch (MalformedURLException e) {
            LOG.error((Object)"Could not create class loader", (Throwable)e);
            throw new DeploymentException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Class not found: " + descriptor.getBootstrapClassName()), (Throwable)e);
            throw new DeploymentException((Throwable)e);
        }
        catch (InstantiationException e) {
            LOG.error((Object)("Could not instantiate : " + descriptor.getBootstrapClassName()), (Throwable)e);
            throw new DeploymentException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)("Illegal access on: " + descriptor.getBootstrapClassName()), (Throwable)e);
            throw new DeploymentException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public String getInstallRoot() {
        return this.context.getInstallRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName install() throws JBIException {
        if (this.isInstalled()) {
            throw new DeploymentException("Component is already installed");
        }
        this.initBootstrap();
        this.bootstrap.onInstall();
        ObjectName result = null;
        try {
            result = this.activateComponent();
            ComponentMBeanImpl lcc = this.container.getComponent(this.context.getComponentName());
            lcc.persistRunningState();
        }
        finally {
            this.cleanUpBootstrap();
            this.context.setInstall(false);
        }
        return result;
    }

    public ObjectName activateComponent() throws JBIException {
        ObjectName result = null;
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Component descriptor = this.context.getDescriptor();
        try {
            ClassLoader cl = this.buildClassLoader(this.context.getInstallRootAsDir(), this.context.getClassPathElements().toArray(new String[0]), descriptor.isComponentClassLoaderDelegationParentFirst(), this.context.getSharedLibraries());
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> componentClass = cl.loadClass(descriptor.getComponentClassName());
            javax.jbi.component.Component component = (javax.jbi.component.Component)componentClass.newInstance();
            result = this.container.activateComponent(this.context.getInstallRootAsDir(), component, this.context.getComponentDescription(), (ComponentContextImpl)this.context.getContext(), this.context.isBinding(), this.context.isEngine(), this.context.getSharedLibraries());
        }
        catch (MalformedURLException e) {
            LOG.error((Object)"Could not create class loader", (Throwable)e);
            throw new DeploymentException((Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            LOG.error((Object)("Class not found: " + descriptor.getBootstrapClassName()), (Throwable)e);
            throw new DeploymentException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Class not found: " + descriptor.getBootstrapClassName()), (Throwable)e);
            throw new DeploymentException((Throwable)e);
        }
        catch (InstantiationException e) {
            LOG.error((Object)("Could not instantiate : " + descriptor.getBootstrapClassName()), (Throwable)e);
            throw new DeploymentException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)("Illegal access on: " + descriptor.getBootstrapClassName()), (Throwable)e);
            throw new DeploymentException((Throwable)e);
        }
        catch (JBIException e) {
            LOG.error((Object)("Could not initialize : " + descriptor.getBootstrapClassName()), (Throwable)e);
            throw new DeploymentException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        return result;
    }

    public boolean isInstalled() {
        return !this.context.isInstall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall() throws JBIException {
        if (!this.isInstalled()) {
            throw new DeploymentException("Component is not installed");
        }
        String componentName = this.context.getComponentName();
        try {
            this.container.deactivateComponent(componentName);
            this.bootstrap.init((InstallationContext)this.context);
            this.bootstrap.getExtensionMBeanName();
            this.bootstrap.onUninstall();
        }
        finally {
            this.cleanUpBootstrap();
            this.context.setInstall(true);
            if (this.bootstrap.getClass().getClassLoader() instanceof DestroyableClassLoader) {
                ((DestroyableClassLoader)this.bootstrap.getClass().getClassLoader()).destroy();
            }
            System.gc();
            this.container.getEnvironmentContext().removeComponentRootDirectory(componentName);
        }
    }

    public ObjectName getInstallerConfigurationMBean() throws JBIException {
        return this.extensionMBeanName;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    private ClassLoader buildClassLoader(File dir, String[] classPathNames, boolean parentFirst, String[] list) throws MalformedURLException, DeploymentException {
        ClassLoader[] parents;
        if (list != null && list.length > 0) {
            parents = new ClassLoader[list.length];
            for (int i = 0; i < parents.length; ++i) {
                SharedLibrary sl = this.container.getRegistry().getSharedLibrary(list[i]);
                if (sl == null) {
                    throw new DeploymentException("Shared library " + list[i] + " is not installed");
                }
                parents[i] = sl.getClassLoader();
            }
        } else {
            parents = new ClassLoader[]{this.getClass().getClassLoader()};
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (int i = 0; i < classPathNames.length; ++i) {
            File file = new File(dir, classPathNames[i]);
            if (!file.exists()) {
                LOG.warn((Object)("Unable to add File " + file + " to class path as it doesn't exist: " + file.getAbsolutePath()));
            }
            urls.add(file.toURL());
        }
        JarFileClassLoader cl = new JarFileClassLoader("Component ClassLoader", urls.toArray(new URL[urls.size()]), parents, !parentFirst, new String[0], new String[]{"java.", "javax."});
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Component class loader: " + cl));
        }
        return cl;
    }
}

