/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import org.apache.servicemix.jbi.deployment.ClassPath;
import org.apache.servicemix.jbi.framework.SharedLibraryMBean;
import org.apache.servicemix.jbi.management.AttributeInfoHelper;
import org.apache.servicemix.jbi.management.MBeanInfoProvider;
import org.apache.xbean.classloader.DestroyableClassLoader;
import org.apache.xbean.classloader.JarFileClassLoader;

public class SharedLibrary
implements SharedLibraryMBean,
MBeanInfoProvider {
    private org.apache.servicemix.jbi.deployment.SharedLibrary library;
    private File installationDir;
    private ClassLoader classLoader;

    public SharedLibrary(org.apache.servicemix.jbi.deployment.SharedLibrary library, File installationDir) {
        this.library = library;
        this.installationDir = installationDir;
        this.classLoader = this.createClassLoader();
    }

    public void dispose() {
        if (this.classLoader instanceof DestroyableClassLoader) {
            ((DestroyableClassLoader)this.classLoader).destroy();
        }
        this.classLoader = null;
    }

    public org.apache.servicemix.jbi.deployment.SharedLibrary getLibrary() {
        return this.library;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private ClassLoader createClassLoader() {
        boolean parentFirst = this.library.isParentFirstClassLoaderDelegation();
        ClassLoader parent = this.getClass().getClassLoader();
        ClassPath cp = this.library.getSharedLibraryClassPath();
        String[] classPathNames = cp.getPathElements();
        URL[] urls = new URL[classPathNames.length];
        for (int i = 0; i < classPathNames.length; ++i) {
            File file = new File(this.installationDir, classPathNames[i]);
            try {
                urls[i] = file.toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(classPathNames[i], e);
            }
        }
        return new JarFileClassLoader(this.library.getIdentification().getName(), urls, parent, !parentFirst, new String[0], new String[]{"java.", "javax."});
    }

    public String getDescription() {
        return this.library.getIdentification().getDescription();
    }

    public String getName() {
        return this.library.getIdentification().getName();
    }

    public String getVersion() {
        return this.library.getVersion();
    }

    public Object getObjectToManage() {
        return this;
    }

    public MBeanAttributeInfo[] getAttributeInfos() throws JMException {
        AttributeInfoHelper helper = new AttributeInfoHelper();
        helper.addAttribute(this.getObjectToManage(), "name", "name of the shared library");
        helper.addAttribute(this.getObjectToManage(), "description", "description of this shared library");
        helper.addAttribute(this.getObjectToManage(), "version", "version of this shared library");
        return helper.getAttributeInfos();
    }

    public MBeanOperationInfo[] getOperationInfos() throws JMException {
        return null;
    }

    public String getSubType() {
        return null;
    }

    public String getType() {
        return "SharedLibrary";
    }

    public void setPropertyChangeListener(PropertyChangeListener l) {
    }
}

