/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.monitoring;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.event.ComponentAdapter;
import org.apache.servicemix.jbi.event.ComponentEvent;
import org.apache.servicemix.jbi.event.ComponentListener;
import org.apache.servicemix.jbi.event.EndpointAdapter;
import org.apache.servicemix.jbi.event.EndpointEvent;
import org.apache.servicemix.jbi.event.EndpointListener;
import org.apache.servicemix.jbi.event.ExchangeEvent;
import org.apache.servicemix.jbi.event.ExchangeListener;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.framework.Endpoint;
import org.apache.servicemix.jbi.management.AttributeInfoHelper;
import org.apache.servicemix.jbi.management.BaseSystemService;
import org.apache.servicemix.jbi.management.ManagementContext;
import org.apache.servicemix.jbi.management.OperationInfoHelper;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;
import org.apache.servicemix.jbi.monitoring.ComponentStats;
import org.apache.servicemix.jbi.monitoring.ComponentStatsMBean;
import org.apache.servicemix.jbi.monitoring.EndpointStats;
import org.apache.servicemix.jbi.monitoring.EndpointStatsMBean;
import org.apache.servicemix.jbi.monitoring.StatisticsServiceMBean;
import org.apache.servicemix.jbi.servicedesc.AbstractServiceEndpoint;
import org.apache.servicemix.jbi.servicedesc.EndpointSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsService
extends BaseSystemService
implements StatisticsServiceMBean {
    private static final Log LOG = LogFactory.getLog(StatisticsService.class);
    private ConcurrentHashMap<String, ComponentStats> componentStats = new ConcurrentHashMap();
    private ConcurrentHashMap<String, EndpointStats> endpointStats = new ConcurrentHashMap();
    private ComponentListener componentListener;
    private EndpointListener endpointListener;
    private ExchangeListener exchangeListener;
    private boolean dumpStats = true;
    private long statsInterval = 5L;
    private Timer statsTimer;
    private TimerTask timerTask;

    @Override
    public long getStatsInterval() {
        return this.statsInterval;
    }

    @Override
    public void setStatsInterval(long statsInterval) {
        this.statsInterval = statsInterval;
    }

    @Override
    public boolean isDumpStats() {
        return this.dumpStats;
    }

    @Override
    public void setDumpStats(boolean value) {
        if (this.dumpStats && !value) {
            if (this.timerTask != null) {
                this.timerTask.cancel();
            }
        } else if (!this.dumpStats && value) {
            this.dumpStats = value;
            this.scheduleStatsTimer();
        }
        this.dumpStats = value;
    }

    @Override
    protected Class<StatisticsServiceMBean> getServiceMBean() {
        return StatisticsServiceMBean.class;
    }

    @Override
    public String getDescription() {
        return "EndpointStats service";
    }

    @Override
    public void resetAllStats() {
        for (ComponentStats componentStats : this.componentStats.values()) {
            componentStats.reset();
        }
        for (EndpointStats endpointStats : this.endpointStats.values()) {
            endpointStats.reset();
        }
    }

    @Override
    public void start() throws JBIException {
        super.start();
        this.container.addListener(this.exchangeListener);
        if (this.isDumpStats()) {
            this.scheduleStatsTimer();
        }
    }

    @Override
    public void stop() throws JBIException {
        this.container.removeListener(this.exchangeListener);
        super.stop();
        for (ComponentStats stats : this.componentStats.values()) {
            stats.close();
        }
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        if (this.statsTimer != null) {
            this.statsTimer.cancel();
        }
    }

    @Override
    public void init(JBIContainer container) throws JBIException {
        this.initComponentListener(container);
        this.initEndpointListener(container);
        this.exchangeListener = new ExchangeListener(){

            public void exchangeSent(ExchangeEvent event) {
                StatisticsService.this.onExchangeSent(event);
            }

            public void exchangeAccepted(ExchangeEvent event) {
                StatisticsService.this.onExchangeAccepted(event);
            }
        };
        super.init(container);
    }

    private void initComponentListener(final JBIContainer container) {
        this.componentListener = new ComponentAdapter(){

            public void componentInitialized(ComponentEvent event) {
                StatisticsService.this.createComponentStats(container, event.getComponent());
            }

            public void componentShutDown(ComponentEvent event) {
                StatisticsService.this.removeComponentStats(container, event.getComponent());
            }
        };
        container.addListener(this.componentListener);
        for (ComponentMBeanImpl component : container.getRegistry().getComponentRegistry().getComponents()) {
            this.createComponentStats(container, component);
        }
    }

    private void initEndpointListener(final JBIContainer container) {
        this.endpointListener = new EndpointAdapter(){

            public void internalEndpointRegistered(EndpointEvent event) {
                StatisticsService.this.createEndpointStats(container, (AbstractServiceEndpoint)event.getEndpoint());
            }

            public void internalEndpointUnregistered(EndpointEvent event) {
                StatisticsService.this.removeEndpointStats(container, (AbstractServiceEndpoint)event.getEndpoint());
            }

            public void externalEndpointRegistered(EndpointEvent event) {
                StatisticsService.this.createEndpointStats(container, (AbstractServiceEndpoint)event.getEndpoint());
            }

            public void externalEndpointUnregistered(EndpointEvent event) {
                StatisticsService.this.removeEndpointStats(container, (AbstractServiceEndpoint)event.getEndpoint());
            }
        };
        container.addListener(this.endpointListener);
        for (Endpoint mbean : container.getRegistry().getEndpointRegistry().getEndpointMBeans()) {
            AbstractServiceEndpoint endpoint = (AbstractServiceEndpoint)container.getEndpoint(container.getComponent(mbean.getComponentName()).getContext(), mbean.getServiceName(), mbean.getEndpointName());
            this.createEndpointStats(container, endpoint);
        }
    }

    protected void onExchangeSent(ExchangeEvent event) {
        MessageExchange me = event.getExchange();
        if (me.getStatus() == ExchangeStatus.ACTIVE && me.getRole() == MessageExchange.Role.CONSUMER && me.getMessage("out") == null && me.getFault() == null && me instanceof MessageExchangeImpl) {
            MessageExchangeImpl mei = (MessageExchangeImpl)me;
            String source = (String)me.getProperty("org.apache.servicemix.senderEndpoint");
            if (source == null) {
                source = mei.getSourceId().getName();
                ComponentStats stats = this.componentStats.get(source);
                stats.incrementOutbound();
            } else {
                ServiceEndpoint[] ses = this.getContainer().getRegistry().getEndpointRegistry().getAllEndpointsForComponent(mei.getSourceId());
                for (int i = 0; i < ses.length; ++i) {
                    if (!EndpointSupport.getKey(ses[i]).equals(source)) continue;
                    source = EndpointSupport.getUniqueKey(ses[i]);
                    EndpointStats stats = this.endpointStats.get(source);
                    stats.incrementOutbound();
                    break;
                }
            }
        }
    }

    protected void onExchangeAccepted(ExchangeEvent event) {
        MessageExchange me = event.getExchange();
        if (me.getStatus() == ExchangeStatus.ACTIVE && me.getRole() == MessageExchange.Role.PROVIDER && me.getMessage("out") == null && me.getFault() == null && me instanceof MessageExchangeImpl) {
            String source = EndpointSupport.getUniqueKey(me.getEndpoint());
            EndpointStats stats = this.endpointStats.get(source);
            stats.incrementInbound();
        }
    }

    protected void scheduleStatsTimer() {
        if (this.statsTimer == null) {
            this.statsTimer = new Timer(true);
        }
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.timerTask = new TimerTask(){

            public void run() {
                StatisticsService.this.doDumpStats();
            }
        };
        long interval = this.statsInterval * 1000L;
        this.statsTimer.scheduleAtFixedRate(this.timerTask, interval, interval);
    }

    protected void doDumpStats() {
        for (ComponentStats stats : this.componentStats.values()) {
            stats.dumpStats();
        }
    }

    @Override
    public MBeanAttributeInfo[] getAttributeInfos() throws JMException {
        AttributeInfoHelper helper = new AttributeInfoHelper();
        helper.addAttribute(this.getObjectToManage(), "dumpStats", "Periodically dump Component statistics");
        helper.addAttribute(this.getObjectToManage(), "statsInterval", "Interval (secs) before dumping statistics");
        return AttributeInfoHelper.join(super.getAttributeInfos(), helper.getAttributeInfos());
    }

    @Override
    public MBeanOperationInfo[] getOperationInfos() throws JMException {
        OperationInfoHelper helper = new OperationInfoHelper();
        helper.addOperation(this.getObjectToManage(), "resetAllStats", "reset all statistics");
        return OperationInfoHelper.join(super.getOperationInfos(), helper.getOperationInfos());
    }

    private void createComponentStats(JBIContainer container, ComponentMBeanImpl component) {
        block2: {
            String key = component.getName();
            ComponentStats stats = new ComponentStats(component);
            this.componentStats.putIfAbsent(key, stats);
            ManagementContext context = container.getManagementContext();
            try {
                context.registerMBean(context.createObjectName(context.createObjectNameProps(stats, true)), stats, ComponentStatsMBean.class);
            }
            catch (Exception e) {
                LOG.info((Object)("Unable to register component statistics MBean: " + e.getMessage()));
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)"Unable to register component statistics MBean", (Throwable)e);
            }
        }
    }

    private void removeComponentStats(JBIContainer container, ComponentMBeanImpl component) {
        block3: {
            String key = component.getName();
            ComponentStats stats = this.componentStats.remove(key);
            if (stats == null) {
                return;
            }
            ManagementContext context = container.getManagementContext();
            try {
                context.unregisterMBean(context.createObjectName(context.createObjectNameProps(stats, true)));
            }
            catch (Exception e) {
                LOG.info((Object)("Unable to unregister component statistics MBean: " + e));
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)"Unable to unregister component statistics MBean", (Throwable)e);
            }
        }
    }

    private void createEndpointStats(JBIContainer container, AbstractServiceEndpoint endpoint) {
        block2: {
            String key = EndpointSupport.getUniqueKey(endpoint);
            ComponentStats compStats = this.componentStats.get(endpoint.getComponentNameSpace().getName());
            EndpointStats stats = new EndpointStats(endpoint, compStats.getMessagingStats());
            this.endpointStats.putIfAbsent(key, stats);
            ManagementContext context = container.getManagementContext();
            try {
                context.registerMBean(context.createObjectName(context.createObjectNameProps(stats, true)), stats, EndpointStatsMBean.class);
            }
            catch (Exception e) {
                LOG.info((Object)("Unable to register endpoint statistics MBean: " + e.getMessage()));
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)"Unable to register endpoint statistics MBean", (Throwable)e);
            }
        }
    }

    private void removeEndpointStats(JBIContainer containner, AbstractServiceEndpoint endpoint) {
        block2: {
            String key = EndpointSupport.getUniqueKey(endpoint);
            EndpointStats stats = this.endpointStats.remove(key);
            ManagementContext context = this.container.getManagementContext();
            try {
                context.unregisterMBean(context.createObjectName(context.createObjectNameProps(stats, true)));
            }
            catch (Exception e) {
                LOG.info((Object)("Unable to unregister endpoint statistics MBean: " + e.getMessage()));
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)"Unable to unregister endpoint statistics MBean", (Throwable)e);
            }
        }
    }

    protected ConcurrentHashMap<String, EndpointStats> getEndpointStats() {
        return this.endpointStats;
    }

    protected ConcurrentHashMap<String, ComponentStats> getComponentStats() {
        return this.componentStats;
    }
}

