/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.resolver;

import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.jbi.NoServiceAvailableException;
import org.apache.servicemix.jbi.resolver.EndpointResolverSupport;

public class ExternalServiceNameEndpointResolver
extends EndpointResolverSupport {
    private QName serviceName;

    public ExternalServiceNameEndpointResolver() {
    }

    public ExternalServiceNameEndpointResolver(QName serviceName) {
        this.serviceName = serviceName;
    }

    public ServiceEndpoint[] resolveAvailableEndpoints(ComponentContext context, MessageExchange exchange) {
        return context.getExternalEndpointsForService(this.serviceName);
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
    }

    protected JBIException createServiceUnavailableException() {
        return new NoServiceAvailableException(this.serviceName);
    }
}

