/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.security.auth.Subject;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.jbi.util.ByteArrayDataSource;
import org.apache.servicemix.jbi.util.FileUtil;
import org.xml.sax.SAXException;

public final class MessageUtil {
    private MessageUtil() {
    }

    public static void transfer(NormalizedMessage source, NormalizedMessage dest) throws MessagingException {
        dest.setContent(source.getContent());
        for (String name : source.getPropertyNames()) {
            dest.setProperty(name, source.getProperty(name));
        }
        for (String name : source.getAttachmentNames()) {
            dest.addAttachment(name, source.getAttachment(name));
        }
        dest.setSecuritySubject(source.getSecuritySubject());
    }

    public static NormalizedMessage copy(NormalizedMessage source) throws MessagingException {
        if (source instanceof Fault) {
            return new FaultImpl((Fault)source);
        }
        return new NormalizedMessageImpl(source);
    }

    public static NormalizedMessage copyIn(MessageExchange exchange) throws MessagingException {
        return MessageUtil.copy(exchange.getMessage("in"));
    }

    public static NormalizedMessage copyOut(MessageExchange exchange) throws MessagingException {
        return MessageUtil.copy(exchange.getMessage("out"));
    }

    public static Fault copyFault(MessageExchange exchange) throws MessagingException {
        return (Fault)MessageUtil.copy(exchange.getMessage("fault"));
    }

    public static void transferInToIn(MessageExchange source, MessageExchange dest) throws MessagingException {
        MessageUtil.transferToIn(source.getMessage("in"), dest);
    }

    public static void transferOutToIn(MessageExchange source, MessageExchange dest) throws MessagingException {
        MessageUtil.transferToIn(source.getMessage("out"), dest);
    }

    public static void transferToIn(NormalizedMessage sourceMsg, MessageExchange dest) throws MessagingException {
        MessageUtil.transferTo(sourceMsg, dest, "in");
    }

    public static void transferOutToOut(MessageExchange source, MessageExchange dest) throws MessagingException {
        MessageUtil.transferToOut(source.getMessage("out"), dest);
    }

    public static void transferInToOut(MessageExchange source, MessageExchange dest) throws MessagingException {
        MessageUtil.transferToOut(source.getMessage("in"), dest);
    }

    public static void transferToOut(NormalizedMessage sourceMsg, MessageExchange dest) throws MessagingException {
        MessageUtil.transferTo(sourceMsg, dest, "out");
    }

    public static void transferFaultToFault(MessageExchange source, MessageExchange dest) throws MessagingException {
        MessageUtil.transferToFault(source.getFault(), dest);
    }

    public static void transferToFault(Fault fault, MessageExchange dest) throws MessagingException {
        MessageUtil.transferTo((NormalizedMessage)fault, dest, "fault");
    }

    public static void transferTo(NormalizedMessage sourceMsg, MessageExchange dest, String name) throws MessagingException {
        Fault destMsg = sourceMsg instanceof Fault ? dest.createFault() : dest.createMessage();
        MessageUtil.transfer(sourceMsg, (NormalizedMessage)destMsg);
        dest.setMessage((NormalizedMessage)destMsg, name);
    }

    public static void transferTo(MessageExchange source, MessageExchange dest, String name) throws MessagingException {
        NormalizedMessage sourceMsg = source.getMessage(name);
        Fault destMsg = sourceMsg instanceof Fault ? dest.createFault() : dest.createMessage();
        MessageUtil.transfer(sourceMsg, (NormalizedMessage)destMsg);
        dest.setMessage((NormalizedMessage)destMsg, name);
    }

    public static void enableContentRereadability(NormalizedMessage message) throws MessagingException {
        if (message.getContent() instanceof StreamSource) {
            try {
                String content = new SourceTransformer().contentToString(message);
                if (content != null) {
                    message.setContent((Source)new StringSource(content));
                }
            }
            catch (TransformerException e) {
                throw new MessagingException("Unable to convert message content into StringSource", (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new MessagingException("Unable to convert message content into StringSource", (Throwable)e);
            }
            catch (IOException e) {
                throw new MessagingException("Unable to convert message content into StringSource", (Throwable)e);
            }
            catch (SAXException e) {
                throw new MessagingException("Unable to convert message content into StringSource", (Throwable)e);
            }
        }
    }

    public static class FaultImpl
    extends NormalizedMessageImpl
    implements Fault {
        private static final long serialVersionUID = -6076815664102825860L;

        public FaultImpl() {
        }

        public FaultImpl(Fault fault) throws MessagingException {
            super((NormalizedMessage)fault);
        }
    }

    public static class NormalizedMessageImpl
    implements NormalizedMessage,
    Serializable {
        private static final long serialVersionUID = -5813947566001096708L;
        private Subject subject;
        private Source content;
        private Map properties = new HashMap();
        private Map attachments = new HashMap();

        public NormalizedMessageImpl() {
        }

        public NormalizedMessageImpl(NormalizedMessage message) throws MessagingException {
            try {
                String str = new SourceTransformer().contentToString(message);
                if (str != null) {
                    this.content = new StringSource(str);
                }
                for (String name : message.getPropertyNames()) {
                    this.properties.put(name, message.getProperty(name));
                }
                for (String name : message.getAttachmentNames()) {
                    DataHandler dh = message.getAttachment(name);
                    DataSource ds = dh.getDataSource();
                    if (!(ds instanceof ByteArrayDataSource)) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        FileUtil.copyInputStream(ds.getInputStream(), baos);
                        ByteArrayDataSource bads = new ByteArrayDataSource(baos.toByteArray(), ds.getContentType());
                        bads.setName(ds.getName());
                        dh = new DataHandler((DataSource)bads);
                    }
                    this.attachments.put(name, dh);
                }
                this.subject = message.getSecuritySubject();
            }
            catch (MessagingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessagingException((Throwable)e);
            }
        }

        public void addAttachment(String id, DataHandler data) throws MessagingException {
            this.attachments.put(id, data);
        }

        public Source getContent() {
            return this.content;
        }

        public DataHandler getAttachment(String id) {
            return (DataHandler)this.attachments.get(id);
        }

        public Set getAttachmentNames() {
            return this.attachments.keySet();
        }

        public void removeAttachment(String id) throws MessagingException {
            this.attachments.remove(id);
        }

        public void setContent(Source content) throws MessagingException {
            this.content = content;
        }

        public void setProperty(String name, Object value) {
            this.properties.put(name, value);
        }

        public void setSecuritySubject(Subject sub) {
            this.subject = sub;
        }

        public Set getPropertyNames() {
            return this.properties.keySet();
        }

        public Object getProperty(String name) {
            return this.properties.get(name);
        }

        public Subject getSecuritySubject() {
            return this.subject;
        }
    }
}

