/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.locks;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReentrantReadWriteLock
implements ReadWriteLock,
Serializable {
    static final int SHARED_SHIFT = 16;
    static final int SHARED_UNIT = 65536;
    static final int EXCLUSIVE_MASK = 65535;
    private static final long serialVersionUID = -6992448646407690164L;
    private final ReadLock readerLock;
    private final WriteLock writerLock;
    private final Sync sync;

    public ReentrantReadWriteLock() {
        this.sync = new NonfairSync();
        this.readerLock = new ReadLock(this);
        this.writerLock = new WriteLock(this);
    }

    public ReentrantReadWriteLock(boolean fair) {
        this.sync = fair ? new FairSync() : new NonfairSync();
        this.readerLock = new ReadLock(this);
        this.writerLock = new WriteLock(this);
    }

    @Override
    public WriteLock writeLock() {
        return this.writerLock;
    }

    @Override
    public ReadLock readLock() {
        return this.readerLock;
    }

    static int sharedCount(int c) {
        return c >>> 16;
    }

    static int exclusiveCount(int c) {
        return c & 0xFFFF;
    }

    public final boolean isFair() {
        return this.sync instanceof FairSync;
    }

    protected Thread getOwner() {
        return this.sync.getOwner();
    }

    public int getReadLockCount() {
        return this.sync.getReadLockCount();
    }

    public boolean isWriteLocked() {
        return this.sync.isWriteLocked();
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.sync.isHeldExclusively();
    }

    public int getWriteHoldCount() {
        return this.sync.getWriteHoldCount();
    }

    protected Collection<Thread> getQueuedWriterThreads() {
        return this.sync.getExclusiveQueuedThreads();
    }

    protected Collection<Thread> getQueuedReaderThreads() {
        return this.sync.getSharedQueuedThreads();
    }

    public final boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    public final boolean hasQueuedThread(Thread thread) {
        return this.sync.isQueued(thread);
    }

    public final int getQueueLength() {
        return this.sync.getQueueLength();
    }

    protected Collection<Thread> getQueuedThreads() {
        return this.sync.getQueuedThreads();
    }

    public boolean hasWaiters(Condition condition) {
        if (condition == null) {
            throw new NullPointerException();
        }
        if (!(condition instanceof AbstractQueuedSynchronizer.ConditionObject)) {
            throw new IllegalArgumentException("not owner");
        }
        return this.sync.hasWaiters((AbstractQueuedSynchronizer.ConditionObject)condition);
    }

    public int getWaitQueueLength(Condition condition) {
        if (condition == null) {
            throw new NullPointerException();
        }
        if (!(condition instanceof AbstractQueuedSynchronizer.ConditionObject)) {
            throw new IllegalArgumentException("not owner");
        }
        return this.sync.getWaitQueueLength((AbstractQueuedSynchronizer.ConditionObject)condition);
    }

    protected Collection<Thread> getWaitingThreads(Condition condition) {
        if (condition == null) {
            throw new NullPointerException();
        }
        if (!(condition instanceof AbstractQueuedSynchronizer.ConditionObject)) {
            throw new IllegalArgumentException("not owner");
        }
        return this.sync.getWaitingThreads((AbstractQueuedSynchronizer.ConditionObject)condition);
    }

    public String toString() {
        int c = this.sync.getCount();
        int w = ReentrantReadWriteLock.exclusiveCount(c);
        int r = ReentrantReadWriteLock.sharedCount(c);
        return super.toString() + "[Write locks = " + w + ", Read locks = " + r + "]";
    }

    public static class WriteLock
    implements Lock,
    Serializable {
        private static final long serialVersionUID = -4992448646407690164L;
        private final Sync sync;

        protected WriteLock(ReentrantReadWriteLock lock) {
            this.sync = lock.sync;
        }

        public void lock() {
            this.sync.wlock();
        }

        public void lockInterruptibly() throws InterruptedException {
            this.sync.acquireInterruptibly(1);
        }

        public boolean tryLock() {
            return this.sync.nonfairTryAcquire(1);
        }

        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            return this.sync.tryAcquireNanos(1, unit.toNanos(timeout));
        }

        public void unlock() {
            this.sync.release(1);
        }

        public Condition newCondition() {
            return this.sync.newCondition();
        }

        public String toString() {
            Thread owner = this.sync.getOwner();
            return super.toString() + (owner == null ? "[Unlocked]" : "[Locked by thread " + owner.getName() + "]");
        }
    }

    public static class ReadLock
    implements Lock,
    Serializable {
        private static final long serialVersionUID = -5992448646407690164L;
        private final Sync sync;

        protected ReadLock(ReentrantReadWriteLock lock) {
            this.sync = lock.sync;
        }

        public void lock() {
            this.sync.acquireShared(1);
        }

        public void lockInterruptibly() throws InterruptedException {
            this.sync.acquireSharedInterruptibly(1);
        }

        public boolean tryLock() {
            return this.sync.nonfairTryAcquireShared(1) >= 0;
        }

        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            return this.sync.tryAcquireSharedNanos(1, unit.toNanos(timeout));
        }

        public void unlock() {
            this.sync.releaseShared(1);
        }

        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            int r = this.sync.getReadLockCount();
            return super.toString() + "[Read locks = " + r + "]";
        }
    }

    static final class FairSync
    extends Sync {
        FairSync() {
        }

        protected boolean tryAcquire(int acquires) {
            acquires = ReentrantReadWriteLock.exclusiveCount(acquires);
            Thread current = Thread.currentThread();
            int c = this.getState();
            int w = ReentrantReadWriteLock.exclusiveCount(c);
            if (w + acquires >= 65536) {
                throw new Error("Maximum lock count exceeded");
            }
            Thread first = this.getFirstQueuedThread();
            if ((w == 0 || current != this.owner) && (c != 0 || first != null && first != current)) {
                return false;
            }
            if (!this.compareAndSetState(c, c + acquires)) {
                return false;
            }
            this.owner = current;
            return true;
        }

        protected int tryAcquireShared(int acquires) {
            int nextc;
            int c;
            Thread current = Thread.currentThread();
            do {
                Thread first;
                if ((first = this.getFirstQueuedThread()) != null && first != current) {
                    return -1;
                }
                c = this.getState();
                nextc = c + (acquires << 16);
                if (nextc < c) {
                    throw new Error("Maximum lock count exceeded");
                }
                if (ReentrantReadWriteLock.exclusiveCount(c) == 0 || this.owner == Thread.currentThread()) continue;
                return -1;
            } while (!this.compareAndSetState(c, nextc));
            return 1;
        }

        void wlock() {
            this.acquire(1);
        }
    }

    static final class NonfairSync
    extends Sync {
        NonfairSync() {
        }

        protected boolean tryAcquire(int acquires) {
            return this.nonfairTryAcquire(acquires);
        }

        protected int tryAcquireShared(int acquires) {
            return this.nonfairTryAcquireShared(acquires);
        }

        void wlock() {
            if (this.compareAndSetState(0, 1)) {
                this.owner = Thread.currentThread();
            } else {
                this.acquire(1);
            }
        }
    }

    static abstract class Sync
    extends AbstractQueuedSynchronizer {
        transient Thread owner;

        Sync() {
        }

        abstract void wlock();

        final boolean nonfairTryAcquire(int acquires) {
            acquires = ReentrantReadWriteLock.exclusiveCount(acquires);
            Thread current = Thread.currentThread();
            int c = this.getState();
            int w = ReentrantReadWriteLock.exclusiveCount(c);
            if (w + acquires >= 65536) {
                throw new Error("Maximum lock count exceeded");
            }
            if (c != 0 && (w == 0 || current != this.owner)) {
                return false;
            }
            if (!this.compareAndSetState(c, c + acquires)) {
                return false;
            }
            this.owner = current;
            return true;
        }

        final int nonfairTryAcquireShared(int acquires) {
            int nextc;
            int c;
            do {
                if ((nextc = (c = this.getState()) + (acquires << 16)) < c) {
                    throw new Error("Maximum lock count exceeded");
                }
                if (ReentrantReadWriteLock.exclusiveCount(c) == 0 || this.owner == Thread.currentThread()) continue;
                return -1;
            } while (!this.compareAndSetState(c, nextc));
            return 1;
        }

        protected final boolean tryRelease(int releases) {
            Thread current = Thread.currentThread();
            int c = this.getState();
            if (this.owner != current) {
                throw new IllegalMonitorStateException();
            }
            int nextc = c - releases;
            boolean free = false;
            if (ReentrantReadWriteLock.exclusiveCount(c) == releases) {
                free = true;
                this.owner = null;
            }
            this.setState(nextc);
            return free;
        }

        protected final boolean tryReleaseShared(int releases) {
            int nextc;
            int c;
            do {
                if ((nextc = (c = this.getState()) - (releases << 16)) >= 0) continue;
                throw new IllegalMonitorStateException();
            } while (!this.compareAndSetState(c, nextc));
            return nextc == 0;
        }

        protected final boolean isHeldExclusively() {
            return ReentrantReadWriteLock.exclusiveCount(this.getState()) != 0 && this.owner == Thread.currentThread();
        }

        final AbstractQueuedSynchronizer.ConditionObject newCondition() {
            return new AbstractQueuedSynchronizer.ConditionObject(this);
        }

        final Thread getOwner() {
            int c = ReentrantReadWriteLock.exclusiveCount(this.getState());
            Thread o = this.owner;
            return c == 0 ? null : o;
        }

        final int getReadLockCount() {
            return ReentrantReadWriteLock.sharedCount(this.getState());
        }

        final boolean isWriteLocked() {
            return ReentrantReadWriteLock.exclusiveCount(this.getState()) != 0;
        }

        final int getWriteHoldCount() {
            int c = ReentrantReadWriteLock.exclusiveCount(this.getState());
            Thread o = this.owner;
            return o == Thread.currentThread() ? c : 0;
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this.setState(0);
        }

        final int getCount() {
            return this.getState();
        }
    }
}

