/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.wsdl;

import java.util.Collection;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.apache.servicemix.soap.bindings.soap.Soap11;
import org.apache.servicemix.soap.bindings.soap.impl.Wsdl1SoapBindingImpl;
import org.apache.servicemix.soap.bindings.soap.impl.Wsdl1SoapMessageImpl;
import org.apache.servicemix.soap.bindings.soap.impl.Wsdl1SoapOperationImpl;
import org.apache.servicemix.soap.bindings.soap.impl.Wsdl1SoapPartImpl;
import org.apache.servicemix.soap.bindings.soap.model.wsdl1.Wsdl1SoapBinding;
import org.apache.servicemix.soap.interceptors.jbi.JbiConstants;
import org.apache.servicemix.soap.wsdl.WSDLUtils;

public class Wsdl1Soap11BindingFactory {
    public static Wsdl1SoapBinding createWsdl1SoapBinding(Port wsdlPort) {
        Wsdl1SoapBindingImpl binding = new Wsdl1SoapBindingImpl(Soap11.getInstance());
        for (ExtensibilityElement element : wsdlPort.getExtensibilityElements()) {
            if (!(element instanceof SOAPAddress)) continue;
            SOAPAddress soapAddress = (SOAPAddress)element;
            binding.setLocationURI(soapAddress.getLocationURI());
        }
        Binding wsdlBinding = wsdlPort.getBinding();
        for (ExtensibilityElement element : wsdlBinding.getExtensibilityElements()) {
            if (!(element instanceof SOAPBinding)) continue;
            SOAPBinding soapBinding = (SOAPBinding)element;
            binding.setTransportURI(soapBinding.getTransportURI());
            binding.setStyle(Wsdl1Soap11BindingFactory.getStyle(soapBinding.getStyle()));
        }
        PortType wsdlPortType = wsdlBinding.getPortType();
        for (Operation wsdlOperation : wsdlPortType.getOperations()) {
            BindingOperation wsdlBindingOperation = wsdlBinding.getBindingOperation(wsdlOperation.getName(), null, null);
            SOAPOperation wsdlSoapOperation = WSDLUtils.getExtension((ElementExtensible)wsdlBindingOperation, SOAPOperation.class);
            Wsdl1SoapOperationImpl operation = new Wsdl1SoapOperationImpl();
            operation.setName(new QName(wsdlPortType.getQName().getNamespaceURI(), wsdlOperation.getName()));
            if (wsdlSoapOperation != null) {
                operation.setSoapAction(wsdlSoapOperation.getSoapActionURI());
                operation.setStyle(Wsdl1Soap11BindingFactory.getStyle(wsdlSoapOperation.getStyle()));
            } else {
                operation.setSoapAction("");
            }
            if (operation.getStyle() == null) {
                operation.setStyle(binding.getStyle() != null ? binding.getStyle() : Wsdl1SoapBinding.Style.DOCUMENT);
            }
            if (wsdlOperation.getStyle() == OperationType.ONE_WAY) {
                operation.setMep(JbiConstants.IN_ONLY);
            } else if (wsdlOperation.getStyle() == OperationType.REQUEST_RESPONSE) {
                operation.setMep(JbiConstants.IN_OUT);
            }
            Wsdl1Soap11BindingFactory.createInput(operation, wsdlBindingOperation);
            Wsdl1Soap11BindingFactory.createOutput(operation, wsdlBindingOperation);
            Collection faults = wsdlOperation.getFaults().values();
            for (Fault fault : faults) {
                Wsdl1Soap11BindingFactory.createFault(operation, wsdlBindingOperation.getBindingFaults().get(fault.getName()));
            }
            binding.addOperation(operation);
        }
        return binding;
    }

    private static void createFault(Wsdl1SoapOperationImpl operation, Object object) {
    }

    private static void createInput(Wsdl1SoapOperationImpl operation, BindingOperation wsdlBindingOperation) {
        Operation wsdlOperation = wsdlBindingOperation.getOperation();
        Input wsdlInput = wsdlOperation.getInput();
        if (wsdlInput == null) {
            return;
        }
        BindingInput wsdlBindingInput = wsdlBindingOperation.getBindingInput();
        SOAPBody wsdlSoapBody = WSDLUtils.getExtension((ElementExtensible)wsdlBindingInput, SOAPBody.class);
        List<SOAPHeader> wsdlSoapHeaders = WSDLUtils.getExtensions((ElementExtensible)wsdlBindingInput, SOAPHeader.class);
        Wsdl1SoapMessageImpl input = new Wsdl1SoapMessageImpl();
        input.setName(wsdlInput.getMessage().getQName());
        input.setNamespace(wsdlSoapBody.getNamespaceURI());
        String inputName = wsdlInput.getName();
        if (inputName == null || inputName.length() == 0) {
            inputName = wsdlOperation.getName();
        }
        input.setMessageName(inputName);
        for (Part wsdlPart : wsdlInput.getMessage().getOrderedParts(null)) {
            Wsdl1SoapPartImpl part = new Wsdl1SoapPartImpl();
            part.setName(wsdlPart.getName());
            part.setType(wsdlPart.getTypeName());
            part.setElement(wsdlPart.getElementName());
            if (wsdlSoapBody.getParts() == null && wsdlInput.getMessage().getOrderedParts(null).size() == 1 || wsdlSoapBody.getParts().contains(part.getName())) {
                part.setBody(true);
                if (operation.getStyle() == Wsdl1SoapBinding.Style.DOCUMENT) {
                    input.setElementName(wsdlPart.getElementName());
                }
            } else {
                boolean header = false;
                for (SOAPHeader h : wsdlSoapHeaders) {
                    if (!wsdlPart.getName().equals(h.getPart())) continue;
                    header = true;
                }
                if (header) {
                    part.setHeader(true);
                } else {
                    throw new IllegalStateException("Unbound part: " + part.getName());
                }
            }
            input.addPart(part);
        }
        if (operation.getStyle() == Wsdl1SoapBinding.Style.RPC) {
            input.setElementName(new QName(input.getNamespace(), operation.getName().getLocalPart()));
        }
        operation.setInput(input);
    }

    private static void createOutput(Wsdl1SoapOperationImpl operation, BindingOperation wsdlBindingOperation) {
        Operation wsdlOperation = wsdlBindingOperation.getOperation();
        Output wsdlOutput = wsdlOperation.getOutput();
        if (wsdlOutput == null) {
            return;
        }
        BindingOutput wsdlBindingOutput = wsdlBindingOperation.getBindingOutput();
        SOAPBody wsdlSoapBody = WSDLUtils.getExtension((ElementExtensible)wsdlBindingOutput, SOAPBody.class);
        List<SOAPHeader> wsdlSoapHeaders = WSDLUtils.getExtensions((ElementExtensible)wsdlBindingOutput, SOAPHeader.class);
        Wsdl1SoapMessageImpl output = new Wsdl1SoapMessageImpl();
        output.setName(wsdlOutput.getMessage().getQName());
        output.setNamespace(wsdlSoapBody.getNamespaceURI());
        String outputName = wsdlOutput.getName();
        if (outputName == null || outputName.length() == 0) {
            outputName = wsdlOperation.getName() + "Response";
        }
        output.setMessageName(outputName);
        for (Part wsdlPart : wsdlOutput.getMessage().getOrderedParts(null)) {
            Wsdl1SoapPartImpl part = new Wsdl1SoapPartImpl();
            part.setName(wsdlPart.getName());
            part.setType(wsdlPart.getTypeName());
            part.setElement(wsdlPart.getElementName());
            if (wsdlSoapBody.getParts() == null && wsdlOutput.getMessage().getOrderedParts(null).size() == 1 || wsdlSoapBody.getParts().contains(part.getName())) {
                part.setBody(true);
                output.setElementName(wsdlPart.getElementName());
            } else {
                boolean header = false;
                for (SOAPHeader h : wsdlSoapHeaders) {
                    if (!wsdlPart.getName().equals(h.getPart())) continue;
                    header = true;
                }
                if (header) {
                    part.setHeader(true);
                } else {
                    throw new IllegalStateException("Unbound part: " + part.getName());
                }
            }
            output.addPart(part);
        }
        if (operation.getStyle() == Wsdl1SoapBinding.Style.RPC) {
            output.setElementName(new QName(output.getNamespace(), operation.getName().getLocalPart() + "Response"));
        }
        operation.setOutput(output);
    }

    private static Wsdl1SoapBinding.Style getStyle(String str) {
        if ("document".equalsIgnoreCase(str)) {
            return Wsdl1SoapBinding.Style.DOCUMENT;
        }
        if ("rpc".equalsIgnoreCase(str)) {
            return Wsdl1SoapBinding.Style.RPC;
        }
        return null;
    }
}

