/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common;

import javax.jbi.JBIException;
import javax.jbi.management.DeploymentException;
import org.apache.commons.logging.Log;
import org.apache.servicemix.common.Deployer;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ManagementSupport;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.ServiceUnit;

public abstract class AbstractDeployer
implements Deployer {
    protected final transient Log logger;
    protected ServiceMixComponent component;

    public AbstractDeployer(ServiceMixComponent component) {
        this.component = component;
        this.logger = component.getLogger();
    }

    protected DeploymentException failure(String task, String info, Throwable e) {
        return ManagementSupport.failure(task, this.component.getComponentName(), info, e);
    }

    public void undeploy(ServiceUnit su) throws DeploymentException {
        try {
            su.shutDown();
        }
        catch (JBIException e) {
            throw new DeploymentException("Unable to shutDown service unit", (Throwable)e);
        }
    }

    protected void validate(Endpoint endpoint) throws DeploymentException {
        endpoint.validate();
    }
}

