/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointSupport;
import org.apache.servicemix.common.ExchangeProcessor;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.executors.Executor;
import org.apache.servicemix.executors.ExecutorFactory;
import org.apache.servicemix.executors.impl.ExecutorFactoryImpl;

public class AsyncBaseLifeCycle
implements ComponentLifeCycle {
    public static final String INITIALIZED = "Initialized";
    protected transient Log logger;
    protected ServiceMixComponent component;
    protected ComponentContext context;
    protected ObjectName mbeanName;
    protected ExecutorFactory executorFactory;
    protected Executor executor;
    protected AtomicBoolean running = new AtomicBoolean(false);
    protected DeliveryChannel channel;
    protected Thread poller;
    protected AtomicBoolean polling = new AtomicBoolean(false);
    protected TransactionManager transactionManager;
    protected boolean workManagerCreated;
    protected Map<String, ExchangeProcessor> processors = new ConcurrentHashMap<String, ExchangeProcessor>();
    protected ThreadLocal<String> correlationId = new ThreadLocal();
    protected String currentState = "Unknown";

    public AsyncBaseLifeCycle() {
    }

    public AsyncBaseLifeCycle(ServiceMixComponent component) {
        this();
        this.setComponent(component);
    }

    protected void setComponent(ServiceMixComponent component) {
        this.component = component;
        this.logger = component.getLogger();
    }

    public ObjectName getExtensionMBeanName() {
        return this.mbeanName;
    }

    protected Object getExtensionMBean() throws Exception {
        return null;
    }

    protected ObjectName createExtensionMBeanName() throws Exception {
        return this.context.getMBeanNames().createCustomComponentMBeanName("Configuration");
    }

    public QName getEPRServiceName() {
        return null;
    }

    public String getCurrentState() {
        return this.currentState;
    }

    protected void setCurrentState(String currentState) {
        this.currentState = currentState;
    }

    public boolean isStarted() {
        return this.currentState != null && this.currentState.equals("Started");
    }

    public boolean isStopped() {
        return this.currentState != null && this.currentState.equals("Stopped");
    }

    public boolean isShutDown() {
        return this.currentState != null && this.currentState.equals("Shutdown");
    }

    public boolean isInitialized() {
        return this.currentState != null && this.currentState.equals(INITIALIZED);
    }

    public boolean isUnknown() {
        return this.currentState == null || this.currentState.equals("Unknown");
    }

    public void init(ComponentContext context) throws JBIException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Initializing component");
            }
            this.context = context;
            this.channel = context.getDeliveryChannel();
            try {
                this.transactionManager = (TransactionManager)context.getTransactionManager();
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.doInit();
            this.setCurrentState(INITIALIZED);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Component initialized");
            }
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling init", (Throwable)e);
        }
    }

    protected void doInit() throws Exception {
        MBeanServer server;
        Object mbean = this.getExtensionMBean();
        if (mbean != null && (server = this.context.getMBeanServer()) != null) {
            this.mbeanName = this.createExtensionMBeanName();
            if (server.isRegistered(this.mbeanName)) {
                server.unregisterMBean(this.mbeanName);
            }
            server.registerMBean(mbean, this.mbeanName);
        }
        if (this.executorFactory == null) {
            this.executorFactory = this.findExecutorFactory();
        }
        if (this.executorFactory == null) {
            this.executorFactory = this.createExecutorFactory();
        }
        this.executor = this.executorFactory.createExecutor("component." + this.getContext().getComponentName());
    }

    public void shutDown() throws JBIException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Shutting down component");
            }
            this.doShutDown();
            this.setCurrentState("Shutdown");
            this.context = null;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Component shut down");
            }
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling shutdown", (Throwable)e);
        }
    }

    protected void doShutDown() throws Exception {
        if (this.mbeanName != null) {
            MBeanServer server = this.context.getMBeanServer();
            if (server == null) {
                throw new JBIException("null mBeanServer");
            }
            if (server.isRegistered(this.mbeanName)) {
                server.unregisterMBean(this.mbeanName);
            }
        }
        this.executor.shutdown();
        this.executor = null;
    }

    public void start() throws JBIException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Starting component");
            }
            if (this.running.compareAndSet(false, true)) {
                this.doStart();
                this.setCurrentState("Started");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Component started");
            }
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling start", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        AtomicBoolean atomicBoolean = this.polling;
        synchronized (atomicBoolean) {
            this.executor.execute(new Runnable(){

                public void run() {
                    AsyncBaseLifeCycle.this.poller = Thread.currentThread();
                    AsyncBaseLifeCycle.this.pollDeliveryChannel();
                }
            });
            this.polling.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pollDeliveryChannel() {
        AtomicBoolean atomicBoolean = this.polling;
        synchronized (atomicBoolean) {
            this.polling.set(true);
            this.polling.notify();
        }
        while (this.running.get()) {
            try {
                final MessageExchange exchange = this.channel.accept(1000L);
                if (exchange == null) continue;
                final Transaction tx = (Transaction)exchange.getProperty("javax.jbi.transaction.jta");
                if (tx != null) {
                    if (this.transactionManager == null) {
                        throw new IllegalStateException("Exchange is enlisted in a transaction, but no transaction manager is available");
                    }
                    this.transactionManager.suspend();
                }
                this.executor.execute(new Runnable(){

                    public void run() {
                        AsyncBaseLifeCycle.this.processExchangeInTx(exchange, tx);
                    }
                });
            }
            catch (Throwable t) {
                if (!this.running.get()) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)"Polling thread will stop");
                    continue;
                }
                this.logger.error((Object)"Error polling delivery channel", t);
            }
        }
        atomicBoolean = this.polling;
        synchronized (atomicBoolean) {
            this.polling.set(false);
            this.polling.notify();
        }
    }

    public void stop() throws JBIException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Stopping component");
            }
            if (this.running.compareAndSet(true, false)) {
                this.doStop();
                this.setCurrentState("Stopped");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Component stopped");
            }
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling stop", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        try {
            AtomicBoolean atomicBoolean = this.polling;
            synchronized (atomicBoolean) {
                if (this.polling.get()) {
                    this.poller.interrupt();
                    this.polling.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.poller = null;
        }
    }

    public ComponentContext getContext() {
        return this.context;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    protected ExecutorFactory createExecutorFactory() {
        return new ExecutorFactoryImpl();
    }

    protected ExecutorFactory findExecutorFactory() {
        try {
            Method getContainerMth = this.context.getClass().getMethod("getContainer", new Class[0]);
            Object container = getContainerMth.invoke((Object)this.context, new Object[0]);
            Method getWorkManagerMth = container.getClass().getMethod("getExecutorFactory", new Class[0]);
            return (ExecutorFactory)getWorkManagerMth.invoke(container, new Object[0]);
        }
        catch (Throwable t) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"JBI container is not ServiceMix. Will create our own ExecutorFactory", t);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processExchangeInTx(MessageExchange exchange, Transaction tx) {
        try {
            if (tx != null) {
                this.transactionManager.resume(tx);
            }
            this.processExchange(exchange);
        }
        catch (Throwable t) {
            this.logger.error((Object)("Error processing exchange " + exchange), t);
            try {
                if (this.transactionManager != null && this.transactionManager.getStatus() == 0 && this.exceptionShouldRollbackTx(t)) {
                    this.transactionManager.setRollbackOnly();
                }
                exchange.setError(t instanceof Exception ? (Exception)t : new Exception(t));
                this.channel.send(exchange);
            }
            catch (Exception inner) {
                this.logger.error((Object)"Error setting exchange status to ERROR", (Throwable)inner);
            }
        }
        finally {
            try {
                int status;
                if (tx != null && (status = this.transactionManager.getStatus()) != 6) {
                    this.logger.error((Object)"Transaction is still active after exchange processing. Trying to rollback transaction.");
                    try {
                        this.transactionManager.rollback();
                    }
                    catch (Throwable t) {
                        this.logger.error((Object)"Error trying to rollback transaction.", t);
                    }
                }
            }
            catch (Throwable t) {
                this.logger.error((Object)"Error checking transaction status.", t);
            }
        }
    }

    protected boolean exceptionShouldRollbackTx(Throwable t) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processExchange(MessageExchange exchange) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Received exchange: status: " + exchange.getStatus() + ", role: " + (exchange.getRole() == MessageExchange.Role.CONSUMER ? "consumer" : "provider")));
        }
        if (exchange.getRole() == MessageExchange.Role.PROVIDER) {
            ExchangeProcessor processor;
            boolean dynamic = false;
            ServiceEndpoint endpoint = exchange.getEndpoint();
            String key = EndpointSupport.getKey(exchange.getEndpoint());
            Endpoint ep = this.component.getRegistry().getEndpoint(key);
            if (ep == null) {
                if (endpoint.getServiceName().equals(this.getEPRServiceName())) {
                    ep = this.getResolvedEPR(exchange.getEndpoint());
                    dynamic = true;
                }
                if (ep == null) {
                    throw new IllegalStateException("Endpoint not found: " + key);
                }
            }
            if ((processor = ep.getProcessor()) == null) {
                throw new IllegalStateException("No processor found for endpoint: " + key);
            }
            try {
                this.doProcess(ep, processor, exchange);
            }
            finally {
                if (dynamic) {
                    ep.deactivate();
                }
            }
        } else {
            ExchangeProcessor processor = null;
            Endpoint ep = null;
            if (exchange.getProperty("org.apache.servicemix.senderEndpoint") != null) {
                String key = exchange.getProperty("org.apache.servicemix.senderEndpoint").toString();
                ep = this.component.getRegistry().getEndpoint(key);
                if (ep != null) {
                    processor = ep.getProcessor();
                }
            } else {
                processor = this.processors.remove(exchange.getExchangeId());
            }
            if (processor == null) {
                throw new IllegalStateException("No processor found for: " + exchange.getExchangeId());
            }
            this.doProcess(ep, processor, exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcess(Endpoint ep, ExchangeProcessor processor, MessageExchange exchange) throws Exception {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            String correlationID;
            ClassLoader cl;
            ClassLoader classLoader = cl = ep != null ? ep.getServiceUnit().getConfigurationClassLoader() : null;
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
            if ((correlationID = (String)exchange.getProperty("org.apache.servicemix.correlationId")) != null) {
                this.correlationId.set(correlationID);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieved correlation id: " + correlationID));
            }
            processor.process(exchange);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
            this.correlationId.set(null);
        }
    }

    public void sendConsumerExchange(MessageExchange exchange, ExchangeProcessor processor) throws MessagingException {
        if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            this.processors.put(exchange.getExchangeId(), processor);
        }
        this.channel.send(exchange);
    }

    public void sendConsumerExchange(MessageExchange exchange, Endpoint endpoint) throws MessagingException {
        this.prepareConsumerExchange(exchange, endpoint);
        this.channel.send(exchange);
    }

    public void prepareConsumerExchange(MessageExchange exchange, Endpoint endpoint) {
        String correlationIDValue = (String)exchange.getProperty("org.apache.servicemix.correlationId");
        if (correlationIDValue == null) {
            correlationIDValue = this.correlationId.get();
            if (correlationIDValue == null) {
                correlationIDValue = exchange.getExchangeId();
                exchange.setProperty("org.apache.servicemix.correlationId", (Object)exchange.getExchangeId());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Created correlation id: " + correlationIDValue));
                }
            } else {
                exchange.setProperty("org.apache.servicemix.correlationId", (Object)correlationIDValue);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Correlation id retrieved from ThreadLocal: " + correlationIDValue));
                }
            }
        }
        String key = EndpointSupport.getKey(endpoint);
        exchange.setProperty("org.apache.servicemix.senderEndpoint", (Object)key);
    }

    protected Endpoint getResolvedEPR(ServiceEndpoint ep) throws Exception {
        throw new UnsupportedOperationException("Component does not handle EPR exchanges");
    }
}

