/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common;

import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.common.BaseLifeCycle;
import org.apache.servicemix.common.BaseServiceUnitManager;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointSupport;
import org.apache.servicemix.common.Registry;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.executors.Executor;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public abstract class BaseComponent
implements ServiceMixComponent {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected BaseLifeCycle lifeCycle = this.createLifeCycle();
    protected Registry registry = this.createRegistry();
    protected BaseServiceUnitManager serviceUnitManager = this.createServiceUnitManager();

    public ComponentLifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    public ServiceUnitManager getServiceUnitManager() {
        return this.serviceUnitManager;
    }

    public Document getServiceDescription(ServiceEndpoint endpoint) {
        String key;
        Endpoint ep;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Querying service description for " + endpoint));
        }
        if ((ep = this.registry.getEndpoint(key = EndpointSupport.getKey(endpoint))) != null) {
            Document doc = ep.getDescription();
            if (doc == null && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No description found for " + key));
            }
            return doc;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No endpoint found for " + key));
        }
        return null;
    }

    public boolean isExchangeWithConsumerOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
        String key = EndpointSupport.getKey(endpoint);
        Endpoint ep = this.registry.getEndpoint(key);
        if (ep != null) {
            if (ep.getRole() != MessageExchange.Role.PROVIDER) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Endpoint " + key + " is a consumer. Refusing exchange with consumer."));
                }
                return false;
            }
            return ep.isExchangeOkay(exchange);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No endpoint found for " + key + ". Refusing exchange with consumer."));
        }
        return false;
    }

    public boolean isExchangeWithProviderOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
        return true;
    }

    public ServiceEndpoint resolveEndpointReference(DocumentFragment epr) {
        return null;
    }

    protected BaseLifeCycle createLifeCycle() {
        return new BaseLifeCycle(this);
    }

    protected BaseServiceUnitManager createServiceUnitManager() {
        return null;
    }

    protected Registry createRegistry() {
        return new Registry(this);
    }

    public ComponentContext getComponentContext() {
        return this.lifeCycle.getContext();
    }

    public String getComponentName() {
        if (this.getComponentContext() == null) {
            return "Component (" + this.getClass().getName() + ") not yet initialized";
        }
        return this.getComponentContext().getComponentName();
    }

    public Log getLogger() {
        return this.logger;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public Executor getExecutor() {
        return this.lifeCycle.getExecutor();
    }

    public void sendConsumerExchange(MessageExchange exchange, Endpoint endpoint) throws MessagingException {
        this.lifeCycle.sendConsumerExchange(exchange, endpoint);
    }

    public void prepareConsumerExchange(MessageExchange exchange, Endpoint endpoint) throws MessagingException {
        this.lifeCycle.prepareConsumerExchange(exchange, endpoint);
    }

    public QName getEPRElementName() {
        return null;
    }
}

