/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class PersistentConfiguration {
    public static final String CONFIG_FILE = "component.properties";
    protected String rootDir;
    protected Properties properties = new Properties();

    public boolean load() {
        if (this.rootDir == null) {
            return false;
        }
        File f = new File(this.rootDir, CONFIG_FILE);
        if (!f.exists()) {
            return false;
        }
        try {
            this.properties.load(new FileInputStream(f));
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load component configuration", e);
        }
    }

    public void save() {
        if (this.rootDir != null) {
            File f = new File(this.rootDir, CONFIG_FILE);
            try {
                this.properties.store(new FileOutputStream(f), null);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not store component configuration", e);
            }
        }
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(String rootDir) {
        this.rootDir = rootDir;
    }
}

