/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointSupport;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.ServiceUnit;

public class Registry {
    protected ServiceMixComponent component;
    protected Map<String, Endpoint> endpoints;
    protected Map<String, ServiceUnit> serviceUnits;

    public Registry(ServiceMixComponent component) {
        this.component = component;
        this.endpoints = new HashMap<String, Endpoint>();
        this.serviceUnits = new HashMap<String, ServiceUnit>();
    }

    public Endpoint getEndpoint(String key) {
        return this.endpoints.get(key);
    }

    public boolean isRegistered(ServiceUnit su) {
        return this.isServiceUnitRegistered(su.getName());
    }

    public boolean isServiceUnitRegistered(String name) {
        return this.serviceUnits.containsKey(name);
    }

    public ServiceUnit getServiceUnit(String name) {
        return this.serviceUnits.get(name);
    }

    public void registerEndpoint(Endpoint ep) {
        String key = EndpointSupport.getKey(ep);
        if (this.endpoints.put(key, ep) != null) {
            throw new IllegalStateException("An endpoint is already registered for key: " + key);
        }
    }

    public void unregisterEndpoint(Endpoint ep) {
        this.endpoints.remove(EndpointSupport.getKey(ep));
    }

    public void registerServiceUnit(ServiceUnit su) {
        this.serviceUnits.put(su.getName(), su);
        Collection<Endpoint> endpoints = su.getEndpoints();
        for (Endpoint ep : endpoints) {
            this.registerEndpoint(ep);
        }
    }

    public void unregisterServiceUnit(ServiceUnit su) {
        this.serviceUnits.remove(su.getName());
        Collection<Endpoint> endpoints = su.getEndpoints();
        for (Endpoint ep : endpoints) {
            this.unregisterEndpoint(ep);
        }
    }
}

