/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common;

import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.jbi.resolver.URIResolver;
import org.apache.servicemix.jbi.util.DOMUtil;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResolvedEndpoint
implements ServiceEndpoint {
    private DocumentFragment reference;
    private String endpointName;
    private QName serviceName;
    private QName[] interfaces = null;

    public ResolvedEndpoint(String uri, QName serviceName) {
        this(URIResolver.createWSAEPR((String)uri), uri, serviceName);
    }

    public ResolvedEndpoint(DocumentFragment reference, String epName, QName serviceName) {
        this.reference = reference;
        this.endpointName = epName;
        this.serviceName = serviceName;
    }

    public ResolvedEndpoint(DocumentFragment reference, String epName, QName serviceName, QName[] interfaces) {
        this.reference = reference;
        this.endpointName = epName;
        this.serviceName = serviceName;
        this.interfaces = interfaces;
    }

    public DocumentFragment getAsReference(QName operationName) {
        return this.reference;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public QName[] getInterfaces() {
        return this.interfaces;
    }

    public static ServiceEndpoint resolveEndpoint(DocumentFragment epr, QName elementName, QName serviceName, String uriPrefix) {
        int elementCount = 0;
        ResolvedEndpoint resolvedEndpoint = null;
        for (Node child = epr.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            if (++elementCount == 1) {
                Element address;
                String uri;
                Element elem = (Element)child;
                String nsUri = elem.getNamespaceURI();
                String name = elem.getLocalName();
                if (elementName.getNamespaceURI().equals(nsUri) && elementName.getLocalPart().equals(name)) {
                    resolvedEndpoint = new ResolvedEndpoint(epr, DOMUtil.getElementText((Element)elem), serviceName);
                    continue;
                }
                NodeList nl = elem.getElementsByTagNameNS("http://www.w3.org/2005/08/addressing", "Address");
                if (nl.getLength() != 1 || (uri = DOMUtil.getElementText((Element)(address = (Element)nl.item(0)))) == null || uriPrefix == null || !(uri = uri.trim()).startsWith(uriPrefix)) continue;
                resolvedEndpoint = new ResolvedEndpoint(epr, uri, serviceName);
                continue;
            }
            return null;
        }
        return resolvedEndpoint;
    }
}

