/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common.xbean;

import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.jbi.management.DeploymentException;
import org.apache.servicemix.common.AbstractDeployer;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.xbean.ClassLoaderXmlPreprocessor;
import org.apache.servicemix.common.xbean.XBeanServiceUnit;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.framework.ComponentContextImpl;
import org.apache.xbean.kernel.Kernel;
import org.apache.xbean.kernel.KernelFactory;
import org.apache.xbean.kernel.ServiceName;
import org.apache.xbean.server.repository.FileSystemRepository;
import org.apache.xbean.server.repository.Repository;
import org.apache.xbean.server.spring.loader.SpringLoader;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class AbstractXBeanDeployer
extends AbstractDeployer {
    public AbstractXBeanDeployer(ServiceMixComponent component) {
        super(component);
    }

    protected String getXBeanFile() {
        return "xbean";
    }

    public boolean canDeploy(String serviceUnitName, String serviceUnitRootPath) {
        File xbean = new File(serviceUnitRootPath, this.getXBeanFile() + ".xml");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking for " + xbean + ": " + xbean.exists()));
        }
        return xbean.exists();
    }

    public ServiceUnit deploy(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
        Kernel kernel = KernelFactory.newInstance().createKernel(this.component.getComponentName() + "/" + serviceUnitName);
        try {
            XBeanServiceUnit su = new XBeanServiceUnit();
            su.setKernel(kernel);
            su.setComponent(this.component);
            su.setName(serviceUnitName);
            su.setRootPath(serviceUnitRootPath);
            ClassLoader classLoader = this.component.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            SpringLoader springLoader = this.createSpringLoader();
            springLoader.setKernel(kernel);
            springLoader.setBaseDir(new File(serviceUnitRootPath));
            springLoader.setXmlPreprocessors(this.getXmlPreProcessors(serviceUnitRootPath));
            springLoader.setBeanFactoryPostProcessors(this.getBeanFactoryPostProcessors(serviceUnitRootPath));
            ServiceName configurationName = springLoader.load(this.getXBeanFile());
            kernel.startService(configurationName);
            su.setConfiguration(configurationName);
            Thread.currentThread().setContextClassLoader(su.getConfigurationClassLoader());
            List services = this.getServices(kernel);
            if (services == null || services.size() == 0) {
                throw this.failure("deploy", "No endpoints found", null);
            }
            for (Endpoint endpoint : services) {
                endpoint.setServiceUnit(su);
                this.validate(endpoint);
                su.addEndpoint(endpoint);
            }
            if (su.getEndpoints().size() == 0) {
                throw this.failure("deploy", "No endpoint found", null);
            }
            XBeanServiceUnit xBeanServiceUnit = su;
            return xBeanServiceUnit;
        }
        catch (Throwable e) {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            kernel.destroy();
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw this.failure("deploy", "Could not deploy xbean service unit", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        }
    }

    protected SpringLoader createSpringLoader() {
        return new SpringLoader();
    }

    protected List getServices(Kernel kernel) throws DeploymentException {
        return kernel.getServices(Endpoint.class);
    }

    protected List getXmlPreProcessors(String serviceUnitRootPath) {
        JBIContainer container = null;
        try {
            container = ((ComponentContextImpl)this.component.getComponentContext()).getContainer();
        }
        catch (Throwable t) {
            // empty catch block
        }
        FileSystemRepository repository = new FileSystemRepository(new File(serviceUnitRootPath));
        ClassLoaderXmlPreprocessor classLoaderXmlPreprocessor = new ClassLoaderXmlPreprocessor((Repository)repository, container);
        return Collections.singletonList(classLoaderXmlPreprocessor);
    }

    protected List getBeanFactoryPostProcessors(String serviceUnitRootPath) {
        PropertyPlaceholderConfigurer propertyPlaceholder = new PropertyPlaceholderConfigurer();
        FileSystemResource propertiesFile = new FileSystemResource(new File(serviceUnitRootPath) + "/" + this.getXBeanFile() + ".properties");
        if (propertiesFile.getFile().exists()) {
            propertyPlaceholder.setLocation((Resource)propertiesFile);
            return Collections.singletonList(propertyPlaceholder);
        }
        return Collections.EMPTY_LIST;
    }
}

