/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.woden.ErrorHandler;
import org.apache.woden.ErrorLocator;
import org.apache.woden.ErrorReporter;
import org.apache.woden.WSDLException;
import org.apache.woden.WSDLSource;
import org.apache.woden.internal.BaseWSDLReader;
import org.apache.woden.internal.DOMWSDLFactory;
import org.apache.woden.internal.DOMWSDLSource;
import org.apache.woden.internal.ErrorLocatorImpl;
import org.apache.woden.internal.schema.ImportedSchemaImpl;
import org.apache.woden.internal.schema.InlinedSchemaImpl;
import org.apache.woden.internal.schema.SchemaConstants;
import org.apache.woden.internal.util.StringUtils;
import org.apache.woden.internal.util.dom.DOMUtils;
import org.apache.woden.internal.util.dom.QNameUtils;
import org.apache.woden.internal.util.dom.XPathUtils;
import org.apache.woden.internal.wsdl20.Constants;
import org.apache.woden.internal.wsdl20.validation.WSDLComponentValidator;
import org.apache.woden.internal.wsdl20.validation.WSDLDocumentValidator;
import org.apache.woden.schema.Schema;
import org.apache.woden.types.NCName;
import org.apache.woden.wsdl20.enumeration.Direction;
import org.apache.woden.wsdl20.enumeration.MessageLabel;
import org.apache.woden.wsdl20.extensions.ExtensionDeserializer;
import org.apache.woden.wsdl20.extensions.ExtensionElement;
import org.apache.woden.wsdl20.extensions.ExtensionRegistry;
import org.apache.woden.wsdl20.xml.BindingElement;
import org.apache.woden.wsdl20.xml.BindingFaultElement;
import org.apache.woden.wsdl20.xml.BindingFaultReferenceElement;
import org.apache.woden.wsdl20.xml.BindingMessageReferenceElement;
import org.apache.woden.wsdl20.xml.BindingOperationElement;
import org.apache.woden.wsdl20.xml.ConfigurableElement;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.apache.woden.wsdl20.xml.DocumentableElement;
import org.apache.woden.wsdl20.xml.DocumentationElement;
import org.apache.woden.wsdl20.xml.EndpointElement;
import org.apache.woden.wsdl20.xml.FeatureElement;
import org.apache.woden.wsdl20.xml.ImportElement;
import org.apache.woden.wsdl20.xml.IncludeElement;
import org.apache.woden.wsdl20.xml.InterfaceElement;
import org.apache.woden.wsdl20.xml.InterfaceFaultElement;
import org.apache.woden.wsdl20.xml.InterfaceFaultReferenceElement;
import org.apache.woden.wsdl20.xml.InterfaceMessageReferenceElement;
import org.apache.woden.wsdl20.xml.InterfaceOperationElement;
import org.apache.woden.wsdl20.xml.PropertyElement;
import org.apache.woden.wsdl20.xml.ServiceElement;
import org.apache.woden.wsdl20.xml.TypesElement;
import org.apache.woden.wsdl20.xml.WSDLElement;
import org.apache.woden.xml.XMLAttr;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaException;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class DOMWSDLReader
extends BaseWSDLReader {
    private Map fImportedSchemas = new Hashtable();
    private WSDLDocumentValidator docValidator = null;
    private WSDLComponentValidator compValidator = null;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$DescriptionElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$DocumentationElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$ImportElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$IncludeElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$TypesElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$InterfaceElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$InterfaceFaultElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$InterfaceOperationElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$InterfaceFaultReferenceElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$InterfaceMessageReferenceElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$BindingElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$BindingFaultElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$BindingOperationElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$BindingFaultReferenceElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$BindingMessageReferenceElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$ServiceElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$EndpointElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$FeatureElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$PropertyElement;

    public WSDLSource createWSDLSource() {
        return new DOMWSDLSource(this.getErrorReporter());
    }

    public DescriptionElement readWSDL(String string) throws WSDLException {
        URL uRL;
        try {
            uRL = StringUtils.getURL(null, string);
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = this.getErrorReporter().getFormattedMessage("WSDL502", new Object[]{null, string});
            throw new WSDLException("PARSER_ERROR", string2, malformedURLException);
        }
        String string3 = uRL.toString();
        InputSource inputSource = new InputSource(string3);
        return this.readWSDL(string3, inputSource);
    }

    public DescriptionElement readWSDL(String string, ErrorHandler errorHandler) throws WSDLException {
        if (errorHandler != null) {
            this.getErrorReporter().setErrorHandler(errorHandler);
        }
        return this.readWSDL(string);
    }

    public DescriptionElement readWSDL(WSDLSource wSDLSource) throws WSDLException {
        Object object;
        Object object2 = wSDLSource.getSource();
        URI uRI = wSDLSource.getBaseURI();
        String string = null;
        if (uRI != null) {
            try {
                object = StringUtils.getURL(null, uRI.toString());
            }
            catch (MalformedURLException malformedURLException) {
                String string2 = this.getErrorReporter().getFormattedMessage("WSDL502", new Object[]{null, uRI.toString()});
                throw new WSDLException("PARSER_ERROR", string2, malformedURLException);
            }
            string = ((URL)object).toString();
        }
        if (object2 instanceof Element) {
            return this.readWSDL(string, (Element)object2);
        }
        if (object2 instanceof Document) {
            return this.readWSDL(string, (Document)object2);
        }
        if (object2 instanceof InputSource) {
            return this.readWSDL(string, (InputSource)object2);
        }
        object = object2.getClass().getName();
        String string3 = this.getClass().getName();
        String string4 = this.getErrorReporter().getFormattedMessage("WSDL017", new Object[]{object, string3});
        throw new WSDLException("PARSER_ERROR", string4);
    }

    public DescriptionElement readWSDL(WSDLSource wSDLSource, ErrorHandler errorHandler) throws WSDLException {
        if (errorHandler != null) {
            this.getErrorReporter().setErrorHandler(errorHandler);
        }
        return this.readWSDL(wSDLSource);
    }

    private DescriptionElement readWSDL(String string, Element element) throws WSDLException {
        DescriptionElement descriptionElement = this.parseDescription(string, element, null);
        if (this.features.getValue("http://ws.apache.org/woden/features/validation")) {
            if (this.docValidator == null) {
                this.docValidator = new WSDLDocumentValidator();
            }
            if (this.docValidator.validate(descriptionElement, this.getErrorReporter())) {
                if (this.compValidator == null) {
                    this.compValidator = new WSDLComponentValidator();
                }
                this.compValidator.validate(descriptionElement.toComponent(), this.getErrorReporter());
            }
        }
        return descriptionElement;
    }

    private DescriptionElement readWSDL(String string, Document document) throws WSDLException {
        return this.readWSDL(string, document.getDocumentElement());
    }

    private DescriptionElement readWSDL(String string, InputSource inputSource) throws WSDLException {
        try {
            Document document = this.getDocument(inputSource, string);
            return this.readWSDL(string, document);
        }
        catch (IOException iOException) {
            String string2 = this.getErrorReporter().getFormattedMessage("WSDL503", new Object[]{string});
            throw new WSDLException("PARSER_ERROR", string2, iOException);
        }
    }

    private DescriptionElement parseDescription(String string, Element element, Map hashMap) throws WSDLException {
        Object object;
        Object object2;
        Object object3;
        this.checkElementName(element, Constants.Q_ELEM_DESCRIPTION);
        DescriptionElement descriptionElement = ((DOMWSDLFactory)this.getFactory()).newDescription();
        if (hashMap == null) {
            hashMap = new HashMap<String, DescriptionElement>();
        }
        if (this.getExtensionRegistry() != null) {
            descriptionElement.setExtensionRegistry(this.getExtensionRegistry());
        }
        if (this.getErrorReporter() != null) {
            descriptionElement.getExtensionRegistry().setErrorReporter(this.getErrorReporter());
        }
        descriptionElement.setDocumentBaseURI(this.getURI(string));
        String string2 = DOMUtils.getAttribute(element, "targetNamespace");
        if (string2 != null) {
            descriptionElement.setTargetNamespace(this.getURI(string2));
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            object3 = (Attr)namedNodeMap.item(i);
            object2 = object3.getNamespaceURI();
            object = object3.getLocalName();
            String string3 = object3.getValue();
            if (!"http://www.w3.org/2000/xmlns/".equals(object2)) continue;
            if (!"xmlns".equals(object)) {
                descriptionElement.addNamespace((String)object, this.getURI(string3));
                continue;
            }
            descriptionElement.addNamespace(null, this.getURI(string3));
        }
        this.parseExtensionAttributes(element, class$org$apache$woden$wsdl20$xml$DescriptionElement == null ? (class$org$apache$woden$wsdl20$xml$DescriptionElement = DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.DescriptionElement")) : class$org$apache$woden$wsdl20$xml$DescriptionElement, descriptionElement, descriptionElement);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, element2)) {
                this.parseDocumentation(element2, descriptionElement, descriptionElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_IMPORT, element2)) {
                if (string != null && !hashMap.containsKey(string)) {
                    hashMap.put(string, descriptionElement);
                }
                this.parseImport(element2, descriptionElement, hashMap);
            } else if (QNameUtils.matches(Constants.Q_ELEM_INCLUDE, element2)) {
                if (string != null && !hashMap.containsKey(string)) {
                    hashMap.put(string, descriptionElement);
                }
                this.parseInclude(element2, descriptionElement, hashMap);
            } else if (QNameUtils.matches(Constants.Q_ELEM_TYPES, element2)) {
                this.parseTypes(element2, descriptionElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_INTERFACE, element2)) {
                this.parseInterface(element2, descriptionElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_BINDING, element2)) {
                this.parseBinding(element2, descriptionElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_SERVICE, element2)) {
                this.parseService(element2, descriptionElement);
            } else {
                descriptionElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$DescriptionElement == null ? DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.DescriptionElement") : class$org$apache$woden$wsdl20$xml$DescriptionElement, descriptionElement, element2, descriptionElement));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        object3 = descriptionElement.getTypesElement();
        if (object3.getTypeSystem() == null) {
            object3.setTypeSystem("http://www.w3.org/2001/XMLSchema");
        }
        try {
            object2 = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            object = object2.createElementNS("http://www.w3.org/2001/XMLSchema", "import");
            object.setAttribute("namespace", "http://www.w3.org/2001/XMLSchema");
            object.setAttribute("schemaLocation", "http://www.w3.org/2001/XMLSchema.xsd");
            descriptionElement.getTypesElement().addSchema(this.parseSchemaImport((Element)object, descriptionElement));
        }
        catch (Exception exception) {
            System.out.println("A problem was encountered while creating the build in XML schema types: " + exception);
        }
        return descriptionElement;
    }

    private DocumentationElement parseDocumentation(Element element, DescriptionElement descriptionElement, DocumentableElement documentableElement) throws WSDLException {
        DocumentationElement documentationElement = documentableElement.addDocumentationElement();
        documentationElement.setContent(element);
        this.parseExtensionAttributes(element, class$org$apache$woden$wsdl20$xml$DocumentationElement == null ? (class$org$apache$woden$wsdl20$xml$DocumentationElement = DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.DocumentationElement")) : class$org$apache$woden$wsdl20$xml$DocumentationElement, documentationElement, descriptionElement);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            documentationElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$DocumentationElement == null ? DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.DocumentationElement") : class$org$apache$woden$wsdl20$xml$DocumentationElement, documentationElement, element2, descriptionElement));
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        return documentationElement;
    }

    private ImportElement parseImport(Element element, DescriptionElement descriptionElement, Map map) throws WSDLException {
        ImportElement importElement = descriptionElement.addImportElement();
        String string = DOMUtils.getAttribute(element, "namespace");
        String string2 = DOMUtils.getAttribute(element, "location");
        this.parseExtensionAttributes(element, class$org$apache$woden$wsdl20$xml$ImportElement == null ? (class$org$apache$woden$wsdl20$xml$ImportElement = DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.ImportElement")) : class$org$apache$woden$wsdl20$xml$ImportElement, importElement, descriptionElement);
        if (string != null) {
            importElement.setNamespace(this.getURI(string));
        }
        if (string2 != null) {
            importElement.setLocation(this.getURI(string2));
            DescriptionElement descriptionElement2 = this.getWSDLFromLocation(string2, descriptionElement, map);
            importElement.setDescriptionElement(descriptionElement2);
        }
        return importElement;
    }

    private IncludeElement parseInclude(Element element, DescriptionElement descriptionElement, Map map) throws WSDLException {
        IncludeElement includeElement = descriptionElement.addIncludeElement();
        String string = DOMUtils.getAttribute(element, "location");
        this.parseExtensionAttributes(element, class$org$apache$woden$wsdl20$xml$IncludeElement == null ? (class$org$apache$woden$wsdl20$xml$IncludeElement = DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.IncludeElement")) : class$org$apache$woden$wsdl20$xml$IncludeElement, includeElement, descriptionElement);
        if (string != null) {
            includeElement.setLocation(this.getURI(string));
            DescriptionElement descriptionElement2 = this.getWSDLFromLocation(string, descriptionElement, map);
            includeElement.setDescriptionElement(descriptionElement2);
        }
        return includeElement;
    }

    private TypesElement parseTypes(Element element, DescriptionElement descriptionElement) throws WSDLException {
        TypesElement typesElement = descriptionElement.getTypesElement();
        typesElement.setTypeSystem("http://www.w3.org/2001/XMLSchema");
        this.parseExtensionAttributes(element, class$org$apache$woden$wsdl20$xml$TypesElement == null ? (class$org$apache$woden$wsdl20$xml$TypesElement = DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.TypesElement")) : class$org$apache$woden$wsdl20$xml$TypesElement, typesElement, descriptionElement);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            QName qName = QNameUtils.newQName(element2);
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, element2)) {
                this.parseDocumentation(element2, descriptionElement, typesElement);
            } else if (SchemaConstants.XSD_IMPORT_QNAME_LIST.contains(qName)) {
                typesElement.addSchema(this.parseSchemaImport(element2, descriptionElement));
            } else if (SchemaConstants.XSD_SCHEMA_QNAME_LIST.contains(qName)) {
                typesElement.addSchema(this.parseSchemaInline(element2, descriptionElement));
            } else {
                typesElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$TypesElement == null ? DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.TypesElement") : class$org$apache$woden$wsdl20$xml$TypesElement, typesElement, element2, descriptionElement));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        return typesElement;
    }

    private Schema parseSchemaInline(Element element, DescriptionElement descriptionElement) throws WSDLException {
        InlinedSchemaImpl inlinedSchemaImpl = new InlinedSchemaImpl();
        inlinedSchemaImpl.setId(DOMUtils.getAttribute(element, "id"));
        String string = DOMUtils.getAttribute(element, "targetNamespace");
        if (string != null) {
            inlinedSchemaImpl.setNamespace(this.getURI(string));
        }
        String string2 = descriptionElement.getDocumentBaseURI() != null ? descriptionElement.getDocumentBaseURI().toString() : null;
        XmlSchema xmlSchema = null;
        try {
            XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();
            xmlSchema = xmlSchemaCollection.read(element, string2);
        }
        catch (XmlSchemaException xmlSchemaException) {
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL521", new Object[]{string2}, (short)1, (Exception)((Object)xmlSchemaException));
        }
        if (xmlSchema != null) {
            inlinedSchemaImpl.setSchemaDefinition(xmlSchema);
        } else {
            inlinedSchemaImpl.setReferenceable(false);
        }
        return inlinedSchemaImpl;
    }

    private Schema parseSchemaImport(Element element, DescriptionElement descriptionElement) throws WSDLException {
        Object object;
        String string;
        ImportedSchemaImpl importedSchemaImpl = new ImportedSchemaImpl();
        String string2 = DOMUtils.getAttribute(element, "namespace");
        if (string2 != null) {
            importedSchemaImpl.setNamespace(this.getURI(string2));
        }
        if ((string = DOMUtils.getAttribute(element, "schemaLocation")) != null) {
            importedSchemaImpl.setSchemaLocation(this.getURI(string));
        }
        if (importedSchemaImpl.getNamespace() == null) {
            importedSchemaImpl.setReferenceable(false);
            return importedSchemaImpl;
        }
        if (importedSchemaImpl.getSchemaLocation() == null) {
            return importedSchemaImpl;
        }
        Document document = null;
        Element element2 = null;
        URI uRI = null;
        String string3 = null;
        URL uRL = null;
        try {
            uRI = descriptionElement.getDocumentBaseURI();
            object = uRI != null ? uRI.toURL() : null;
            string3 = importedSchemaImpl.getSchemaLocation().toString();
            uRL = StringUtils.getURL((URL)object, string3);
        }
        catch (MalformedURLException malformedURLException) {
            String string4 = uRI != null ? uRI.toString() : null;
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL502", new Object[]{string4, string3}, (short)2);
            importedSchemaImpl.setReferenceable(false);
            return importedSchemaImpl;
        }
        object = uRL.toString();
        XmlSchema xmlSchema = (XmlSchema)this.fImportedSchemas.get(object);
        if (xmlSchema == null) {
            try {
                document = this.getDocument(new InputSource((String)object), (String)object);
            }
            catch (IOException iOException) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL504", new Object[]{object}, (short)1, (Exception)iOException);
                importedSchemaImpl.setReferenceable(false);
                return importedSchemaImpl;
            }
            element2 = document.getDocumentElement();
            try {
                String string5 = uRI != null ? uRI.toString() : null;
                XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();
                xmlSchema = xmlSchemaCollection.read(element2, string5);
                this.fImportedSchemas.put(object, xmlSchema);
            }
            catch (XmlSchemaException xmlSchemaException) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL522", new Object[]{object}, (short)1, (Exception)((Object)xmlSchemaException));
            }
        }
        if (xmlSchema != null) {
            importedSchemaImpl.setSchemaDefinition(xmlSchema);
        } else {
            importedSchemaImpl.setReferenceable(false);
        }
        return importedSchemaImpl;
    }

    private InterfaceElement parseInterface(Element element, DescriptionElement descriptionElement) throws WSDLException {
        Object object;
        Object object2;
        Object object3;
        String string;
        InterfaceElement interfaceElement = descriptionElement.addInterfaceElement();
        String string2 = DOMUtils.getAttribute(element, "name");
        if (string2 != null) {
            interfaceElement.setName(new NCName(string2));
        }
        if ((string = DOMUtils.getAttribute(element, "styleDefault")) != null) {
            object3 = StringUtils.parseNMTokens(string);
            object2 = null;
            object = object3.iterator();
            while (object.hasNext()) {
                object2 = (String)object.next();
                interfaceElement.addStyleDefaultURI(this.getURI((String)object2));
            }
        }
        if ((object3 = DOMUtils.getAttribute(element, "extends")) != null) {
            object2 = StringUtils.parseNMTokens((String)object3);
            object = null;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                interfaceElement.addExtendedInterfaceName(DOMUtils.getQName((String)object, element, descriptionElement));
            }
        }
        this.parseExtensionAttributes(element, class$org$apache$woden$wsdl20$xml$InterfaceElement == null ? (class$org$apache$woden$wsdl20$xml$InterfaceElement = DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceElement")) : class$org$apache$woden$wsdl20$xml$InterfaceElement, interfaceElement, descriptionElement);
        object2 = DOMUtils.getFirstChildElement(element);
        while (object2 != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, (Node)object2)) {
                this.parseDocumentation((Element)object2, descriptionElement, interfaceElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_FAULT, (Node)object2)) {
                this.parseInterfaceFault((Element)object2, descriptionElement, interfaceElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_OPERATION, (Node)object2)) {
                this.parseInterfaceOperation((Element)object2, descriptionElement, interfaceElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_FEATURE, (Node)object2)) {
                this.parseFeature((Element)object2, descriptionElement, interfaceElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_PROPERTY, (Node)object2)) {
                this.parseProperty((Element)object2, descriptionElement, interfaceElement);
            } else {
                interfaceElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$InterfaceElement == null ? DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceElement") : class$org$apache$woden$wsdl20$xml$InterfaceElement, interfaceElement, (Element)object2, descriptionElement));
            }
            object2 = DOMUtils.getNextSiblingElement((Element)object2);
        }
        return interfaceElement;
    }

    private InterfaceFaultElement parseInterfaceFault(Element element, DescriptionElement descriptionElement, InterfaceElement interfaceElement) throws WSDLException {
        Object object;
        String string;
        InterfaceFaultElement interfaceFaultElement = interfaceElement.addInterfaceFaultElement();
        interfaceFaultElement.setParentElement(interfaceElement);
        String string2 = DOMUtils.getAttribute(element, "name");
        if (string2 != null) {
            interfaceFaultElement.setName(new NCName(string2));
        }
        if ((string = DOMUtils.getAttribute(element, "element")) != null) {
            try {
                object = DOMUtils.getQName(string, element, descriptionElement);
                interfaceFaultElement.setElementName((QName)object);
            }
            catch (WSDLException wSDLException) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{string, QNameUtils.newQName(element)}, (short)2);
            }
        }
        this.parseExtensionAttributes(element, class$org$apache$woden$wsdl20$xml$InterfaceFaultElement == null ? (class$org$apache$woden$wsdl20$xml$InterfaceFaultElement = DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceFaultElement")) : class$org$apache$woden$wsdl20$xml$InterfaceFaultElement, interfaceFaultElement, descriptionElement);
        object = DOMUtils.getFirstChildElement(element);
        while (object != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, (Node)object)) {
                this.parseDocumentation((Element)object, descriptionElement, interfaceFaultElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_FEATURE, (Node)object)) {
                this.parseFeature((Element)object, descriptionElement, interfaceFaultElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_PROPERTY, (Node)object)) {
                this.parseProperty((Element)object, descriptionElement, interfaceFaultElement);
            } else {
                interfaceFaultElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$InterfaceFaultElement == null ? DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceFaultElement") : class$org$apache$woden$wsdl20$xml$InterfaceFaultElement, interfaceFaultElement, (Element)object, descriptionElement));
            }
            object = DOMUtils.getNextSiblingElement((Element)object);
        }
        return interfaceFaultElement;
    }

    private InterfaceOperationElement parseInterfaceOperation(Element element, DescriptionElement descriptionElement, InterfaceElement interfaceElement) throws WSDLException {
        Object object;
        Object object2;
        String string;
        InterfaceOperationElement interfaceOperationElement = interfaceElement.addInterfaceOperationElement();
        interfaceOperationElement.setParentElement(interfaceElement);
        String string2 = DOMUtils.getAttribute(element, "name");
        if (string2 != null) {
            interfaceOperationElement.setName(new NCName(string2));
        }
        if ((string = DOMUtils.getAttribute(element, "style")) != null) {
            object2 = StringUtils.parseNMTokens(string);
            object = null;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                interfaceOperationElement.addStyleURI(this.getURI((String)object));
            }
        }
        if ((object2 = DOMUtils.getAttribute(element, "pattern")) != null) {
            interfaceOperationElement.setPattern(this.getURI((String)object2));
        }
        this.parseExtensionAttributes(element, class$org$apache$woden$wsdl20$xml$InterfaceOperationElement == null ? (class$org$apache$woden$wsdl20$xml$InterfaceOperationElement = DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceOperationElement")) : class$org$apache$woden$wsdl20$xml$InterfaceOperationElement, interfaceOperationElement, descriptionElement);
        object = DOMUtils.getFirstChildElement(element);
        while (object != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, (Node)object)) {
                this.parseDocumentation((Element)object, descriptionElement, interfaceOperationElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_FEATURE, (Node)object)) {
                this.parseFeature((Element)object, descriptionElement, interfaceOperationElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_PROPERTY, (Node)object)) {
                this.parseProperty((Element)object, descriptionElement, interfaceOperationElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_INPUT, (Node)object)) {
                this.parseInterfaceMessageReference((Element)object, descriptionElement, interfaceOperationElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_OUTPUT, (Node)object)) {
                this.parseInterfaceMessageReference((Element)object, descriptionElement, interfaceOperationElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_INFAULT, (Node)object)) {
                this.parseInterfaceFaultReference((Element)object, descriptionElement, interfaceOperationElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_OUTFAULT, (Node)object)) {
                this.parseInterfaceFaultReference((Element)object, descriptionElement, interfaceOperationElement);
            } else {
                interfaceOperationElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$InterfaceOperationElement == null ? DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceOperationElement") : class$org$apache$woden$wsdl20$xml$InterfaceOperationElement, interfaceOperationElement, (Element)object, descriptionElement));
            }
            object = DOMUtils.getNextSiblingElement((Element)object);
        }
        return interfaceOperationElement;
    }

    private InterfaceFaultReferenceElement parseInterfaceFaultReference(Element element, DescriptionElement descriptionElement, InterfaceOperationElement interfaceOperationElement) throws WSDLException {
        Object object;
        InterfaceFaultReferenceElement interfaceFaultReferenceElement = interfaceOperationElement.addInterfaceFaultReferenceElement();
        interfaceFaultReferenceElement.setParentElement(interfaceOperationElement);
        if ("infault".equals(element.getLocalName())) {
            interfaceFaultReferenceElement.setDirection(Direction.IN);
        } else if ("outfault".equals(element.getLocalName())) {
            interfaceFaultReferenceElement.setDirection(Direction.OUT);
        }
        String string = DOMUtils.getAttribute(element, "ref");
        if (string != null) {
            try {
                object = DOMUtils.getQName(string, element, descriptionElement);
                interfaceFaultReferenceElement.setRef((QName)object);
            }
            catch (WSDLException wSDLException) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{string, QNameUtils.newQName(element)}, (short)2);
            }
        }
        if ((object = DOMUtils.getAttribute(element, "messageLabel")) != null) {
            if (((String)object).equals(MessageLabel.IN.toString())) {
                interfaceFaultReferenceElement.setMessageLabel(MessageLabel.IN);
            } else if (((String)object).equals(MessageLabel.OUT.toString())) {
                interfaceFaultReferenceElement.setMessageLabel(MessageLabel.OUT);
            } else {
                interfaceFaultReferenceElement.setMessageLabel(MessageLabel.invalidValue((String)object));
            }
        }
        this.parseExtensionAttributes(element, class$org$apache$woden$wsdl20$xml$InterfaceFaultReferenceElement == null ? (class$org$apache$woden$wsdl20$xml$InterfaceFaultReferenceElement = DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceFaultReferenceElement")) : class$org$apache$woden$wsdl20$xml$InterfaceFaultReferenceElement, interfaceFaultReferenceElement, descriptionElement);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, element2)) {
                this.parseDocumentation(element2, descriptionElement, interfaceFaultReferenceElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_FEATURE, element2)) {
                this.parseFeature(element2, descriptionElement, interfaceFaultReferenceElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_PROPERTY, element2)) {
                this.parseProperty(element2, descriptionElement, interfaceFaultReferenceElement);
            } else {
                interfaceFaultReferenceElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$InterfaceFaultReferenceElement == null ? DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceFaultReferenceElement") : class$org$apache$woden$wsdl20$xml$InterfaceFaultReferenceElement, interfaceFaultReferenceElement, element2, descriptionElement));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        return interfaceFaultReferenceElement;
    }

    private InterfaceMessageReferenceElement parseInterfaceMessageReference(Element element, DescriptionElement descriptionElement, InterfaceOperationElement interfaceOperationElement) throws WSDLException {
        Object object;
        InterfaceMessageReferenceElement interfaceMessageReferenceElement = interfaceOperationElement.addInterfaceMessageReferenceElement();
        interfaceMessageReferenceElement.setParentElement(interfaceOperationElement);
        if ("input".equals(element.getLocalName())) {
            interfaceMessageReferenceElement.setDirection(Direction.IN);
        } else if ("output".equals(element.getLocalName())) {
            interfaceMessageReferenceElement.setDirection(Direction.OUT);
        }
        String string = DOMUtils.getAttribute(element, "messageLabel");
        if (string != null) {
            if (string.equals(MessageLabel.IN.toString())) {
                interfaceMessageReferenceElement.setMessageLabel(MessageLabel.IN);
            } else if (string.equals(MessageLabel.OUT.toString())) {
                interfaceMessageReferenceElement.setMessageLabel(MessageLabel.OUT);
            } else {
                interfaceMessageReferenceElement.setMessageLabel(MessageLabel.invalidValue(string));
            }
        } else if (interfaceMessageReferenceElement.getDirection().equals(Direction.IN)) {
            interfaceMessageReferenceElement.setMessageLabel(MessageLabel.IN);
        } else {
            interfaceMessageReferenceElement.setMessageLabel(MessageLabel.OUT);
        }
        String string2 = DOMUtils.getAttribute(element, "element");
        if (string2 != null) {
            if (string2.equals("#any") || string2.equals("#none") || string2.equals("#other")) {
                interfaceMessageReferenceElement.setMessageContentModel(string2);
            } else {
                interfaceMessageReferenceElement.setMessageContentModel("#element");
                try {
                    object = DOMUtils.getQName(string2, element, descriptionElement);
                    interfaceMessageReferenceElement.setElementName((QName)object);
                }
                catch (WSDLException wSDLException) {
                    this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{string2, QNameUtils.newQName(element)}, (short)2);
                }
            }
        } else {
            interfaceMessageReferenceElement.setMessageContentModel("#other");
        }
        this.parseExtensionAttributes(element, class$org$apache$woden$wsdl20$xml$InterfaceMessageReferenceElement == null ? (class$org$apache$woden$wsdl20$xml$InterfaceMessageReferenceElement = DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceMessageReferenceElement")) : class$org$apache$woden$wsdl20$xml$InterfaceMessageReferenceElement, interfaceMessageReferenceElement, descriptionElement);
        object = DOMUtils.getFirstChildElement(element);
        while (object != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, (Node)object)) {
                this.parseDocumentation((Element)object, descriptionElement, interfaceMessageReferenceElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_FEATURE, (Node)object)) {
                this.parseFeature((Element)object, descriptionElement, interfaceMessageReferenceElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_PROPERTY, (Node)object)) {
                this.parseProperty((Element)object, descriptionElement, interfaceMessageReferenceElement);
            } else {
                interfaceMessageReferenceElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$InterfaceMessageReferenceElement == null ? DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceMessageReferenceElement") : class$org$apache$woden$wsdl20$xml$InterfaceMessageReferenceElement, interfaceMessageReferenceElement, (Element)object, descriptionElement));
            }
            object = DOMUtils.getNextSiblingElement((Element)object);
        }
        return interfaceMessageReferenceElement;
    }

    private BindingElement parseBinding(Element element, DescriptionElement descriptionElement) throws WSDLException {
        String string;
        BindingElement bindingElement = descriptionElement.addBindingElement();
        String string2 = DOMUtils.getAttribute(element, "name");
        if (string2 != null) {
            bindingElement.setName(new NCName(string2));
        }
        QName qName = null;
        String string3 = DOMUtils.getAttribute(element, "interface");
        if (string3 != null) {
            try {
                qName = DOMUtils.getQName(string3, element, descriptionElement);
                bindingElement.setInterfaceName(qName);
            }
            catch (WSDLException wSDLException) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{string3, QNameUtils.newQName(element)}, (short)2);
            }
        }
        if ((string = DOMUtils.getAttribute(element, "type")) != null) {
            bindingElement.setType(this.getURI(string));
        }
        this.parseExtensionAttributes(element, class$org$apache$woden$wsdl20$xml$BindingElement == null ? (class$org$apache$woden$wsdl20$xml$BindingElement = DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingElement")) : class$org$apache$woden$wsdl20$xml$BindingElement, bindingElement, descriptionElement);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, element2)) {
                this.parseDocumentation(element2, descriptionElement, bindingElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_FAULT, element2)) {
                this.parseBindingFault(element2, descriptionElement, bindingElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_OPERATION, element2)) {
                this.parseBindingOperation(element2, descriptionElement, bindingElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_FEATURE, element2)) {
                this.parseFeature(element2, descriptionElement, bindingElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_PROPERTY, element2)) {
                this.parseProperty(element2, descriptionElement, bindingElement);
            } else {
                bindingElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$BindingElement == null ? DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingElement") : class$org$apache$woden$wsdl20$xml$BindingElement, bindingElement, element2, descriptionElement));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        return bindingElement;
    }

    private BindingFaultElement parseBindingFault(Element element, DescriptionElement descriptionElement, BindingElement bindingElement) throws WSDLException {
        BindingFaultElement bindingFaultElement = bindingElement.addBindingFaultElement();
        bindingFaultElement.setParentElement(bindingElement);
        QName qName = null;
        String string = DOMUtils.getAttribute(element, "ref");
        if (string != null) {
            try {
                qName = DOMUtils.getQName(string, element, descriptionElement);
                bindingFaultElement.setRef(qName);
            }
            catch (WSDLException wSDLException) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{string, QNameUtils.newQName(element)}, (short)2);
            }
        }
        this.parseExtensionAttributes(element, class$org$apache$woden$wsdl20$xml$BindingFaultElement == null ? (class$org$apache$woden$wsdl20$xml$BindingFaultElement = DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingFaultElement")) : class$org$apache$woden$wsdl20$xml$BindingFaultElement, bindingFaultElement, descriptionElement);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, element2)) {
                this.parseDocumentation(element2, descriptionElement, bindingFaultElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_FEATURE, element2)) {
                this.parseFeature(element2, descriptionElement, bindingFaultElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_PROPERTY, element2)) {
                this.parseProperty(element2, descriptionElement, bindingFaultElement);
            } else {
                bindingFaultElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$BindingFaultElement == null ? DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingFaultElement") : class$org$apache$woden$wsdl20$xml$BindingFaultElement, bindingFaultElement, element2, descriptionElement));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        return bindingFaultElement;
    }

    private BindingOperationElement parseBindingOperation(Element element, DescriptionElement descriptionElement, BindingElement bindingElement) throws WSDLException {
        BindingOperationElement bindingOperationElement = bindingElement.addBindingOperationElement();
        bindingOperationElement.setParentElement(bindingElement);
        QName qName = null;
        String string = DOMUtils.getAttribute(element, "ref");
        if (string != null) {
            try {
                qName = DOMUtils.getQName(string, element, descriptionElement);
                bindingOperationElement.setRef(qName);
            }
            catch (WSDLException wSDLException) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{string, QNameUtils.newQName(element)}, (short)2);
            }
        }
        this.parseExtensionAttributes(element, class$org$apache$woden$wsdl20$xml$BindingOperationElement == null ? (class$org$apache$woden$wsdl20$xml$BindingOperationElement = DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingOperationElement")) : class$org$apache$woden$wsdl20$xml$BindingOperationElement, bindingOperationElement, descriptionElement);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, element2)) {
                this.parseDocumentation(element2, descriptionElement, bindingOperationElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_FEATURE, element2)) {
                this.parseFeature(element2, descriptionElement, bindingOperationElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_PROPERTY, element2)) {
                this.parseProperty(element2, descriptionElement, bindingOperationElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_INPUT, element2)) {
                this.parseBindingMessageReference(element2, descriptionElement, bindingOperationElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_OUTPUT, element2)) {
                this.parseBindingMessageReference(element2, descriptionElement, bindingOperationElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_INFAULT, element2)) {
                this.parseBindingFaultReference(element2, descriptionElement, bindingOperationElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_OUTFAULT, element2)) {
                this.parseBindingFaultReference(element2, descriptionElement, bindingOperationElement);
            } else {
                bindingOperationElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$BindingOperationElement == null ? DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingOperationElement") : class$org$apache$woden$wsdl20$xml$BindingOperationElement, bindingOperationElement, element2, descriptionElement));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        return bindingOperationElement;
    }

    private BindingFaultReferenceElement parseBindingFaultReference(Element element, DescriptionElement descriptionElement, BindingOperationElement bindingOperationElement) throws WSDLException {
        String string;
        BindingFaultReferenceElement bindingFaultReferenceElement = bindingOperationElement.addBindingFaultReferenceElement();
        bindingFaultReferenceElement.setParentElement(bindingOperationElement);
        QName qName = null;
        String string2 = DOMUtils.getAttribute(element, "ref");
        if (string2 != null) {
            try {
                qName = DOMUtils.getQName(string2, element, descriptionElement);
                bindingFaultReferenceElement.setRef(qName);
            }
            catch (WSDLException wSDLException) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{string2, QNameUtils.newQName(element)}, (short)2);
            }
        }
        if ((string = DOMUtils.getAttribute(element, "messageLabel")) != null) {
            if (string.equals(MessageLabel.IN.toString())) {
                bindingFaultReferenceElement.setMessageLabel(MessageLabel.IN);
            } else if (string.equals(MessageLabel.OUT.toString())) {
                bindingFaultReferenceElement.setMessageLabel(MessageLabel.OUT);
            } else {
                bindingFaultReferenceElement.setMessageLabel(MessageLabel.invalidValue(string));
            }
        }
        this.parseExtensionAttributes(element, class$org$apache$woden$wsdl20$xml$BindingFaultReferenceElement == null ? (class$org$apache$woden$wsdl20$xml$BindingFaultReferenceElement = DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingFaultReferenceElement")) : class$org$apache$woden$wsdl20$xml$BindingFaultReferenceElement, bindingFaultReferenceElement, descriptionElement);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, element2)) {
                this.parseDocumentation(element2, descriptionElement, bindingFaultReferenceElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_FEATURE, element2)) {
                this.parseFeature(element2, descriptionElement, bindingFaultReferenceElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_PROPERTY, element2)) {
                this.parseProperty(element2, descriptionElement, bindingFaultReferenceElement);
            } else {
                bindingFaultReferenceElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$BindingFaultReferenceElement == null ? DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingFaultReferenceElement") : class$org$apache$woden$wsdl20$xml$BindingFaultReferenceElement, bindingFaultReferenceElement, element2, descriptionElement));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        return bindingFaultReferenceElement;
    }

    private BindingMessageReferenceElement parseBindingMessageReference(Element element, DescriptionElement descriptionElement, BindingOperationElement bindingOperationElement) throws WSDLException {
        BindingMessageReferenceElement bindingMessageReferenceElement = bindingOperationElement.addBindingMessageReferenceElement();
        bindingMessageReferenceElement.setParentElement(bindingOperationElement);
        if ("input".equals(element.getLocalName())) {
            bindingMessageReferenceElement.setDirection(Direction.IN);
        } else if ("output".equals(element.getLocalName())) {
            bindingMessageReferenceElement.setDirection(Direction.OUT);
        }
        String string = DOMUtils.getAttribute(element, "messageLabel");
        if (string != null) {
            if (string.equals(MessageLabel.IN.toString())) {
                bindingMessageReferenceElement.setMessageLabel(MessageLabel.IN);
            } else if (string.equals(MessageLabel.OUT.toString())) {
                bindingMessageReferenceElement.setMessageLabel(MessageLabel.OUT);
            } else {
                bindingMessageReferenceElement.setMessageLabel(MessageLabel.invalidValue(string));
            }
        } else if (bindingMessageReferenceElement.getDirection().equals(Direction.IN)) {
            bindingMessageReferenceElement.setMessageLabel(MessageLabel.IN);
        } else {
            bindingMessageReferenceElement.setMessageLabel(MessageLabel.OUT);
        }
        this.parseExtensionAttributes(element, class$org$apache$woden$wsdl20$xml$BindingMessageReferenceElement == null ? (class$org$apache$woden$wsdl20$xml$BindingMessageReferenceElement = DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingMessageReferenceElement")) : class$org$apache$woden$wsdl20$xml$BindingMessageReferenceElement, bindingMessageReferenceElement, descriptionElement);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, element2)) {
                this.parseDocumentation(element2, descriptionElement, bindingMessageReferenceElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_FEATURE, element2)) {
                this.parseFeature(element2, descriptionElement, bindingMessageReferenceElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_PROPERTY, element2)) {
                this.parseProperty(element2, descriptionElement, bindingMessageReferenceElement);
            } else {
                bindingMessageReferenceElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$BindingMessageReferenceElement == null ? DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingMessageReferenceElement") : class$org$apache$woden$wsdl20$xml$BindingMessageReferenceElement, bindingMessageReferenceElement, element2, descriptionElement));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        return bindingMessageReferenceElement;
    }

    private ServiceElement parseService(Element element, DescriptionElement descriptionElement) throws WSDLException {
        ServiceElement serviceElement = descriptionElement.addServiceElement();
        String string = DOMUtils.getAttribute(element, "name");
        if (string != null) {
            serviceElement.setName(new NCName(string));
        }
        QName qName = null;
        String string2 = DOMUtils.getAttribute(element, "interface");
        if (string2 != null) {
            try {
                qName = DOMUtils.getQName(string2, element, descriptionElement);
                serviceElement.setInterfaceName(qName);
            }
            catch (WSDLException wSDLException) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{string2, QNameUtils.newQName(element)}, (short)2);
            }
        }
        this.parseExtensionAttributes(element, class$org$apache$woden$wsdl20$xml$ServiceElement == null ? (class$org$apache$woden$wsdl20$xml$ServiceElement = DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.ServiceElement")) : class$org$apache$woden$wsdl20$xml$ServiceElement, serviceElement, descriptionElement);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, element2)) {
                this.parseDocumentation(element2, descriptionElement, serviceElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_ENDPOINT, element2)) {
                this.parseEndpoint(element2, descriptionElement, serviceElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_FEATURE, element2)) {
                this.parseFeature(element2, descriptionElement, serviceElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_PROPERTY, element2)) {
                this.parseProperty(element2, descriptionElement, serviceElement);
            } else {
                serviceElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$ServiceElement == null ? DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.ServiceElement") : class$org$apache$woden$wsdl20$xml$ServiceElement, serviceElement, element2, descriptionElement));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        return serviceElement;
    }

    private EndpointElement parseEndpoint(Element element, DescriptionElement descriptionElement, ServiceElement serviceElement) throws WSDLException {
        String string;
        EndpointElement endpointElement = serviceElement.addEndpointElement();
        endpointElement.setParentElement(serviceElement);
        String string2 = DOMUtils.getAttribute(element, "name");
        if (string2 != null) {
            endpointElement.setName(new NCName(string2));
        }
        QName qName = null;
        String string3 = DOMUtils.getAttribute(element, "binding");
        if (string3 != null) {
            try {
                qName = DOMUtils.getQName(string3, element, descriptionElement);
                endpointElement.setBindingName(qName);
            }
            catch (WSDLException wSDLException) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{string3, QNameUtils.newQName(element)}, (short)2);
            }
        }
        if ((string = DOMUtils.getAttribute(element, "address")) != null) {
            endpointElement.setAddress(this.getURI(string));
        }
        this.parseExtensionAttributes(element, class$org$apache$woden$wsdl20$xml$EndpointElement == null ? (class$org$apache$woden$wsdl20$xml$EndpointElement = DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.EndpointElement")) : class$org$apache$woden$wsdl20$xml$EndpointElement, endpointElement, descriptionElement);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, element2)) {
                this.parseDocumentation(element2, descriptionElement, endpointElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_FEATURE, element2)) {
                this.parseFeature(element2, descriptionElement, endpointElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_PROPERTY, element2)) {
                this.parseProperty(element2, descriptionElement, endpointElement);
            } else {
                endpointElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$ServiceElement == null ? DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.ServiceElement") : class$org$apache$woden$wsdl20$xml$ServiceElement, endpointElement, element2, descriptionElement));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        return endpointElement;
    }

    private FeatureElement parseFeature(Element element, DescriptionElement descriptionElement, ConfigurableElement configurableElement) throws WSDLException {
        String string;
        FeatureElement featureElement = configurableElement.addFeatureElement();
        featureElement.setParentElement(configurableElement);
        String string2 = DOMUtils.getAttribute(element, "ref");
        if (string2 != null) {
            featureElement.setRef(this.getURI(string2));
        }
        featureElement.setRequired("true".equals(string = DOMUtils.getAttribute(element, "required")));
        this.parseExtensionAttributes(element, class$org$apache$woden$wsdl20$xml$FeatureElement == null ? (class$org$apache$woden$wsdl20$xml$FeatureElement = DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.FeatureElement")) : class$org$apache$woden$wsdl20$xml$FeatureElement, featureElement, descriptionElement);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, element2)) {
                this.parseDocumentation(element2, descriptionElement, featureElement);
            } else {
                featureElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$FeatureElement == null ? DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.FeatureElement") : class$org$apache$woden$wsdl20$xml$FeatureElement, featureElement, element2, descriptionElement));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        return featureElement;
    }

    private PropertyElement parseProperty(Element element, DescriptionElement descriptionElement, ConfigurableElement configurableElement) throws WSDLException {
        PropertyElement propertyElement = configurableElement.addPropertyElement();
        propertyElement.setParentElement(configurableElement);
        String string = DOMUtils.getAttribute(element, "ref");
        if (string != null) {
            propertyElement.setRef(this.getURI(string));
        }
        this.parseExtensionAttributes(element, class$org$apache$woden$wsdl20$xml$PropertyElement == null ? (class$org$apache$woden$wsdl20$xml$PropertyElement = DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.PropertyElement")) : class$org$apache$woden$wsdl20$xml$PropertyElement, propertyElement, descriptionElement);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            Object object;
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, element2)) {
                this.parseDocumentation(element2, descriptionElement, propertyElement);
            } else if (QNameUtils.matches(Constants.Q_ELEM_VALUE, element2)) {
                object = element2.getChildNodes();
                propertyElement.setValue(object);
            } else if (QNameUtils.matches(Constants.Q_ELEM_CONSTRAINT, element2)) {
                Text text;
                String string2;
                object = element2.getFirstChild();
                if (object != null && object instanceof Text && (string2 = (text = (Text)object).getData().trim()).length() > 0) {
                    if (string2.equals("#value")) {
                        propertyElement.setHasValueToken(true);
                    } else {
                        try {
                            QName qName = DOMUtils.getQName(string2, element2, descriptionElement);
                            propertyElement.setConstraintName(qName);
                        }
                        catch (WSDLException wSDLException) {
                            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{string2, QNameUtils.newQName(element2)}, (short)2, (Exception)wSDLException);
                        }
                    }
                }
            } else {
                propertyElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$PropertyElement == null ? DOMWSDLReader.class$("org.apache.woden.wsdl20.xml.PropertyElement") : class$org$apache$woden$wsdl20$xml$PropertyElement, propertyElement, element2, descriptionElement));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        return propertyElement;
    }

    private void parseExtensionAttributes(Element element, Class clazz, WSDLElement wSDLElement, DescriptionElement descriptionElement) throws WSDLException {
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            String string = attr.getLocalName();
            String string2 = attr.getNamespaceURI();
            String string3 = attr.getPrefix();
            QName qName = new QName(string2, string, string3 != null ? string3 : "");
            if (string2 == null || string2.equals("http://www.w3.org/2006/01/wsdl") || string2.equals("http://www.w3.org/2000/xmlns/") || string2.equals("http://www.w3.org/2001/XMLSchema-instance")) continue;
            XMLAttr xMLAttr = null;
            ExtensionRegistry extensionRegistry = descriptionElement.getExtensionRegistry();
            if (extensionRegistry == null) break;
            xMLAttr = extensionRegistry.createExtAttribute(clazz, qName);
            if (xMLAttr == null) continue;
            String string4 = attr.getValue();
            xMLAttr.init(element, qName, string4);
            wSDLElement.setExtensionAttribute(qName, xMLAttr);
        }
    }

    private ExtensionElement parseExtensionElement(Class clazz, WSDLElement wSDLElement, Element element, DescriptionElement descriptionElement) throws WSDLException {
        QName qName = QNameUtils.newQName(element);
        String string = element.getNamespaceURI();
        try {
            if (string == null || string.equals("http://www.w3.org/2006/01/wsdl")) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL520", new Object[]{qName, clazz.getName()}, (short)2);
                return null;
            }
            ExtensionRegistry extensionRegistry = descriptionElement.getExtensionRegistry();
            if (extensionRegistry == null) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL514", new Object[]{qName, clazz.getName()}, (short)2);
                return null;
            }
            ExtensionDeserializer extensionDeserializer = extensionRegistry.queryDeserializer(clazz, qName);
            return extensionDeserializer.unmarshall(clazz, wSDLElement, qName, element, descriptionElement, extensionRegistry);
        }
        catch (WSDLException wSDLException) {
            if (wSDLException.getLocation() == null) {
                wSDLException.setLocation(XPathUtils.getXPathExprFromNode(element));
            }
            throw wSDLException;
        }
    }

    private void checkElementName(Element element, QName qName) throws WSDLException {
        if (!QNameUtils.matches(qName, element)) {
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL501", new Object[]{qName, QNameUtils.newQName(element)}, (short)3);
        }
    }

    private Document getDocument(InputSource inputSource, String string) throws WSDLException, IOException {
        DOMParser dOMParser = new DOMParser();
        try {
            dOMParser.setFeature("http://xml.org/sax/features/namespaces", true);
            dOMParser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
        if (this.features.getValue("http://ws.apache.org/woden/features/validation")) {
            try {
                dOMParser.setFeature("http://xml.org/sax/features/validation", true);
                dOMParser.setFeature("http://apache.org/xml/features/validation/schema", true);
                dOMParser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)"http://www.w3.org/2006/01/wsdl http://www.w3.org/2006/01/wsdl/wsdl20.xsd http://www.w3.org/2006/01/wsdl-extensions http://www.w3.org/2006/01/wsdl-extensions.xsd http://www.w3.org/2001/XMLSchema http://www.w3.org/2001/XMLSchema.xsd");
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.out.println("validation not supported by parser.");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                // empty catch block
            }
        }
        Document document = null;
        try {
            dOMParser.parse(inputSource);
            document = dOMParser.getDocument();
        }
        catch (SAXException sAXException) {
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL500", new Object[]{"SAX", string}, (short)3, (Exception)sAXException);
        }
        return document;
    }

    private URI getURI(String string) throws WSDLException {
        URI uRI = null;
        if (string != null) {
            try {
                uRI = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL506", new Object[]{string}, (short)2, (Exception)uRISyntaxException);
            }
        }
        return uRI;
    }

    private DescriptionElement getWSDLFromLocation(String string, DescriptionElement descriptionElement, Map map) throws WSDLException {
        Object object;
        DescriptionElement descriptionElement2 = null;
        URL uRL = null;
        URI uRI = null;
        try {
            uRI = descriptionElement.getDocumentBaseURI();
            object = uRI != null ? uRI.toURL() : null;
            uRL = StringUtils.getURL((URL)object, string);
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = uRI != null ? uRI.toString() : null;
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL502", new Object[]{string2, string}, (short)2);
            return null;
        }
        object = uRL.toString();
        descriptionElement2 = (DescriptionElement)map.get(object);
        if (descriptionElement2 == null) {
            Element element;
            try {
                Document document = this.getDocument(new InputSource((String)object), (String)object);
                element = document.getDocumentElement();
            }
            catch (IOException iOException) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL503", new Object[]{object}, (short)1, (Exception)iOException);
                return null;
            }
            if (!QNameUtils.matches(Constants.Q_ELEM_DESCRIPTION, element)) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL501", new Object[]{Constants.Q_ELEM_DESCRIPTION, QNameUtils.newQName(element)}, (short)2);
                return null;
            }
            descriptionElement2 = this.parseDescription((String)object, element, map);
            if (!map.containsKey(object)) {
                map.put(object, descriptionElement2);
            }
        }
        return descriptionElement2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class WSDLEntityResolver
    implements EntityResolver {
        WSDLEntityResolver() {
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            return null;
        }
    }

    class ErrorHandlerWrapper
    implements org.xml.sax.ErrorHandler {
        private ErrorReporter errorReporter;

        public ErrorHandlerWrapper(ErrorReporter errorReporter) {
            this.errorReporter = errorReporter;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            ErrorLocatorImpl errorLocatorImpl = new ErrorLocatorImpl();
            errorLocatorImpl.setLineNumber(sAXParseException.getLineNumber());
            errorLocatorImpl.setColumnNumber(sAXParseException.getColumnNumber());
            try {
                this.errorReporter.reportError((ErrorLocator)errorLocatorImpl, null, sAXParseException.getMessage(), (short)2, sAXParseException.getException());
            }
            catch (WSDLException wSDLException) {
                throw new SAXException("A problem occurred setting the error in the Woden error reporter wrapper.", wSDLException);
            }
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            ErrorLocatorImpl errorLocatorImpl = new ErrorLocatorImpl();
            errorLocatorImpl.setLineNumber(sAXParseException.getLineNumber());
            errorLocatorImpl.setColumnNumber(sAXParseException.getColumnNumber());
            try {
                this.errorReporter.reportError((ErrorLocator)errorLocatorImpl, null, sAXParseException.getMessage(), (short)3, sAXParseException.getException());
            }
            catch (WSDLException wSDLException) {
                throw new SAXException("A problem occurred setting the error in the Woden error reporter wrapper.", wSDLException);
            }
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            ErrorLocatorImpl errorLocatorImpl = new ErrorLocatorImpl();
            errorLocatorImpl.setLineNumber(sAXParseException.getLineNumber());
            errorLocatorImpl.setColumnNumber(sAXParseException.getColumnNumber());
            try {
                this.errorReporter.reportError((ErrorLocator)errorLocatorImpl, null, sAXParseException.getMessage(), (short)1, sAXParseException.getException());
            }
            catch (WSDLException wSDLException) {
                throw new SAXException("A problem occurred setting the error in the Woden error reporter wrapper.", wSDLException);
            }
        }
    }
}

