/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mail.cos;

import com.oreilly.servlet.MailMessage;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import org.springframework.mail.MailException;
import org.springframework.mail.MailParseException;
import org.springframework.mail.MailSendException;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;

public class CosMailSenderImpl
implements MailSender {
    private String host;

    public void setHost(String host) {
        this.host = host;
    }

    public void send(SimpleMailMessage simpleMessage) throws MailException {
        this.send(new SimpleMailMessage[]{simpleMessage});
    }

    public void send(SimpleMailMessage[] simpleMessages) throws MailException {
        HashMap<SimpleMailMessage, IOException> failedMessages = new HashMap<SimpleMailMessage, IOException>();
        for (int i = 0; i < simpleMessages.length; ++i) {
            SimpleMailMessage simpleMessage = simpleMessages[i];
            if (simpleMessage.getReplyTo() != null) {
                throw new MailParseException("CosMailSenderImpl does not support replyTo field - " + simpleMessage);
            }
            if (simpleMessage.getSentDate() != null) {
                throw new MailParseException("CosMailSenderImpl does not support sentDate field - " + simpleMessage);
            }
            try {
                int j;
                MailMessage cosMessage = new MailMessage(this.host);
                cosMessage.from(simpleMessage.getFrom());
                if (simpleMessage.getTo() != null) {
                    for (j = 0; j < simpleMessage.getTo().length; ++j) {
                        cosMessage.to(simpleMessage.getTo()[j]);
                    }
                }
                if (simpleMessage.getCc() != null) {
                    for (j = 0; j < simpleMessage.getCc().length; ++j) {
                        cosMessage.cc(simpleMessage.getCc()[j]);
                    }
                }
                if (simpleMessage.getBcc() != null) {
                    for (j = 0; j < simpleMessage.getBcc().length; ++j) {
                        cosMessage.bcc(simpleMessage.getBcc()[j]);
                    }
                }
                cosMessage.setSubject(simpleMessage.getSubject());
                PrintStream textStream = cosMessage.getPrintStream();
                textStream.print(simpleMessage.getText());
                cosMessage.sendAndClose();
                continue;
            }
            catch (IOException ex) {
                failedMessages.put(simpleMessage, ex);
            }
        }
        if (!failedMessages.isEmpty()) {
            throw new MailSendException(failedMessages);
        }
    }
}

