/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.FileExchange;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.language.simple.FileLanguage;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileProducer
extends DefaultProducer {
    private static final transient Log LOG = LogFactory.getLog(FileProducer.class);
    private FileEndpoint endpoint;

    public FileProducer(FileEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    public FileEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        FileExchange fileExchange = (FileExchange)this.endpoint.createExchange(exchange);
        this.process(fileExchange);
        ExchangeHelper.copyResults(exchange, fileExchange);
    }

    public void process(FileExchange exchange) throws Exception {
        boolean fileSource = exchange.getIn().getBody() instanceof File;
        File target = this.createFileName(exchange.getIn());
        this.buildDirectory(target);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("About to write to: " + target + " from exchange: " + exchange));
        }
        if (fileSource) {
            File source = ExchangeHelper.getMandatoryInBody(exchange, File.class);
            this.writeFileByFile(source, target);
        } else {
            InputStream in = ExchangeHelper.getMandatoryInBody(exchange, InputStream.class);
            this.writeFileByStream(in, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileByFile(File source, File target) throws IOException {
        FileChannel in = new FileInputStream(source).getChannel();
        FileChannel out = null;
        try {
            out = this.prepareOutputFileChannel(target, out);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Using FileChannel to transfer from: " + in + " to: " + out));
            }
            in.transferTo(0L, in.size(), out);
        }
        finally {
            ObjectHelper.close(in, source.getName(), LOG);
            ObjectHelper.close(out, source.getName(), LOG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileByStream(InputStream in, File target) throws IOException {
        FileChannel out = null;
        try {
            int count;
            out = this.prepareOutputFileChannel(target, out);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Using InputStream to transfer from: " + in + " to: " + out));
            }
            int size = this.endpoint.getBufferSize();
            byte[] buffer = new byte[size];
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
            while ((count = in.read(buffer)) > 0) {
                if (count < size) {
                    byteBuffer = ByteBuffer.wrap(buffer, 0, count);
                    out.write(byteBuffer);
                    break;
                }
                out.write(byteBuffer);
                byteBuffer.clear();
            }
        }
        finally {
            ObjectHelper.close(in, target.getName(), LOG);
            ObjectHelper.close(out, target.getName(), LOG);
        }
    }

    private FileChannel prepareOutputFileChannel(File target, FileChannel out) throws IOException {
        if (this.endpoint.isAppend()) {
            out = new RandomAccessFile(target, "rw").getChannel();
            out = out.position(out.size());
        } else {
            out = new FileOutputStream(target).getChannel();
        }
        return out;
    }

    protected File createFileName(Message message) {
        File answer;
        File endpointFile;
        String name = null;
        if (!this.endpoint.isIgnoreFileNameHeader()) {
            name = message.getHeader("org.apache.camel.file.name", String.class);
        }
        Expression expression = this.endpoint.getExpression();
        if (name != null && name.indexOf("${") > -1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("org.apache.camel.file.name contains a FileLanguage expression: " + name));
            }
            expression = FileLanguage.file(name);
        }
        if (expression != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Filename evaluated as expression: " + expression));
            }
            Object result = expression.evaluate(message.getExchange());
            name = message.getExchange().getContext().getTypeConverter().convertTo(String.class, result);
        }
        if ((endpointFile = this.endpoint.getFile()).isDirectory()) {
            if (name != null) {
                answer = new File(endpointFile, name);
                if (answer.isDirectory()) {
                    answer = new File(answer, this.endpoint.getGeneratedFileName(message));
                }
            } else {
                answer = new File(endpointFile, this.endpoint.getGeneratedFileName(message));
            }
        } else {
            answer = name == null ? endpointFile : new File(endpointFile, name);
        }
        message.setHeader("org.apache.camel.file.name.produced", answer.getAbsolutePath());
        return answer;
    }

    private void buildDirectory(File file) {
        String dirName = file.getAbsolutePath();
        int index = dirName.lastIndexOf(File.separatorChar);
        if (index > 0) {
            dirName = dirName.substring(0, index);
            File dir = new File(dirName);
            dir.mkdirs();
        }
    }
}

