/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.util.Map;
import org.apache.camel.Expression;
import org.apache.camel.component.file.FileProcessStrategy;
import org.apache.camel.component.file.strategy.DefaultFileRenamer;
import org.apache.camel.component.file.strategy.DeleteFileProcessStrategy;
import org.apache.camel.component.file.strategy.FileExpressionRenamer;
import org.apache.camel.component.file.strategy.NoOpFileProcessStrategy;
import org.apache.camel.component.file.strategy.RenameFileProcessStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileProcessStrategyFactory {
    private FileProcessStrategyFactory() {
    }

    public static FileProcessStrategy createFileProcessStrategy(Map<String, Object> params) {
        boolean preMove;
        boolean isDelete = params.get("delete") != null;
        boolean isLock = params.get("lock") != null;
        String moveNamePrefix = (String)params.get("moveNamePrefix");
        String moveNamePostfix = (String)params.get("moveNamePostfix");
        String preMoveNamePrefix = (String)params.get("preMoveNamePrefix");
        String preMoveNamePostfix = (String)params.get("preMoveNamePostfix");
        Expression expression = (Expression)params.get("expression");
        Expression preMoveExpression = (Expression)params.get("preMoveExpression");
        boolean move = moveNamePrefix != null || moveNamePostfix != null;
        boolean bl = preMove = preMoveNamePrefix != null || preMoveNamePostfix != null;
        if (params.containsKey("noop")) {
            return new NoOpFileProcessStrategy(isLock);
        }
        if (move || preMove) {
            RenameFileProcessStrategy strategy = new RenameFileProcessStrategy(isLock);
            if (move) {
                strategy.setCommitRenamer(new DefaultFileRenamer(moveNamePrefix, moveNamePostfix));
            }
            if (preMove) {
                strategy.setBeginRenamer(new DefaultFileRenamer(preMoveNamePrefix, preMoveNamePostfix));
            }
            return strategy;
        }
        if (expression != null || preMoveExpression != null) {
            FileExpressionRenamer renamer;
            RenameFileProcessStrategy strategy = new RenameFileProcessStrategy(isLock);
            if (expression != null) {
                renamer = new FileExpressionRenamer();
                renamer.setExpression(expression);
                strategy.setCommitRenamer(renamer);
            }
            if (preMoveExpression != null) {
                renamer = new FileExpressionRenamer();
                renamer.setExpression(preMoveExpression);
                strategy.setBeginRenamer(renamer);
            }
            return strategy;
        }
        if (isDelete) {
            return new DeleteFileProcessStrategy(isLock);
        }
        return new RenameFileProcessStrategy(isLock);
    }
}

