/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.log.LogFormatter;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.model.LoggingLevel;
import org.apache.camel.processor.Logger;
import org.apache.camel.processor.ThroughputLogger;
import org.apache.camel.util.IntrospectionSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogComponent
extends DefaultComponent<Exchange> {
    @Override
    protected Endpoint<Exchange> createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        Logger logger;
        LoggingLevel level = this.getLoggingLevel(parameters);
        Integer groupSize = this.getAndRemoveParameter(parameters, "groupSize", Integer.class);
        if (groupSize != null) {
            logger = new ThroughputLogger(remaining, level, ObjectConverter.toInteger(groupSize));
        } else {
            LogFormatter formatter = new LogFormatter();
            IntrospectionSupport.setProperties(formatter, parameters);
            logger = new Logger(remaining);
            logger.setLevel(level);
            logger.setFormatter(formatter);
        }
        return new ProcessorEndpoint(uri, this, (Processor)logger);
    }

    protected LoggingLevel getLoggingLevel(Map parameters) {
        String levelText = this.getAndRemoveParameter(parameters, "level", String.class, "INFO");
        return LoggingLevel.valueOf(levelText.toUpperCase());
    }
}

