/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.timer.TimerEndpoint;
import org.apache.camel.impl.DefaultComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerComponent
extends DefaultComponent<Exchange> {
    private Map<String, Timer> timers = new HashMap<String, Timer>();

    public Timer getTimer(TimerEndpoint endpoint) {
        Timer answer;
        String key = endpoint.getTimerName();
        if (!endpoint.isDaemon()) {
            key = "nonDaemon:" + key;
        }
        if ((answer = this.timers.get(key)) == null) {
            answer = new Timer(endpoint.getTimerName(), endpoint.isDaemon());
            this.timers.put(key, answer);
        }
        return answer;
    }

    @Override
    protected Endpoint<Exchange> createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        TimerEndpoint answer = new TimerEndpoint(uri, this, remaining);
        String time = this.getAndRemoveParameter(parameters, "time", String.class);
        String pattern = this.getAndRemoveParameter(parameters, "pattern", String.class);
        if (time != null) {
            SimpleDateFormat sdf = pattern != null ? new SimpleDateFormat(pattern) : (time.contains("T") ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
            Date date = sdf.parse(time);
            answer.setTime(date);
        }
        this.setProperties(answer, parameters);
        return answer;
    }

    @Override
    protected void doStop() throws Exception {
        Collection<Timer> collection = this.timers.values();
        for (Timer timer : collection) {
            timer.cancel();
        }
        this.timers.clear();
    }
}

