/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.ScheduledPollConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScheduledPollConsumer<E extends Exchange>
extends ScheduledPollConsumer<E> {
    private PollingConsumer<E> pollingConsumer;

    public DefaultScheduledPollConsumer(DefaultEndpoint<E> defaultEndpoint, Processor processor) {
        super(defaultEndpoint, processor);
    }

    public DefaultScheduledPollConsumer(Endpoint<E> endpoint, Processor processor, ScheduledExecutorService executor) {
        super(endpoint, processor, executor);
    }

    @Override
    protected void poll() throws Exception {
        E exchange;
        while ((exchange = this.pollingConsumer.receiveNoWait()) != null) {
            Message out = exchange.getOut(false);
            if (out != null) {
                Object newExchange = this.getEndpoint().createExchange();
                newExchange.getIn().copyFrom(out);
                exchange = newExchange;
            }
            this.getProcessor().process((Exchange)exchange);
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.pollingConsumer = this.getEndpoint().createPollingConsumer();
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.pollingConsumer != null) {
            this.pollingConsumer.stop();
        }
    }
}

