/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.Service;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

public abstract class ServiceSupport
implements Service {
    private static int threadCounter;
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicBoolean starting = new AtomicBoolean(false);
    private AtomicBoolean stopping = new AtomicBoolean(false);
    private AtomicBoolean stopped = new AtomicBoolean(false);
    private Collection childServices;
    private String version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        if (!this.started.get() && this.starting.compareAndSet(false, true)) {
            boolean childrenStarted = false;
            Exception ex = null;
            try {
                if (this.childServices != null) {
                    ServiceHelper.startServices(this.childServices);
                }
                childrenStarted = true;
                this.doStart();
            }
            catch (Exception e) {
                ex = e;
            }
            finally {
                if (ex != null) {
                    try {
                        this.stop(childrenStarted);
                    }
                    catch (Exception exception) {}
                    throw ex;
                }
                this.started.set(true);
                this.starting.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(boolean childrenStarted) throws Exception {
        if (this.stopping.compareAndSet(false, true)) {
            try {
                try {
                    this.starting.set(false);
                    if (childrenStarted) {
                        this.doStop();
                    }
                }
                finally {
                    this.started.set(false);
                    if (this.childServices != null) {
                        ServiceHelper.stopServices(this.childServices);
                    }
                }
            }
            finally {
                this.stopped.set(true);
                this.stopping.set(false);
            }
        }
    }

    public void stop() throws Exception {
        if (this.started.get()) {
            this.stop(true);
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isStarting() {
        return this.starting.get();
    }

    public boolean isStopping() {
        return this.stopping.get();
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    protected boolean isRunAllowed() {
        return !this.stopping.get() && !this.stopped.get();
    }

    protected abstract void doStart() throws Exception;

    protected abstract void doStop() throws Exception;

    protected String getThreadName(String prefix) {
        return prefix + " thread:" + ServiceSupport.nextThreadCounter();
    }

    protected static synchronized int nextThreadCounter() {
        return ++threadCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildService(Object childService) {
        ServiceSupport serviceSupport = this;
        synchronized (serviceSupport) {
            if (this.childServices == null) {
                this.childServices = new CopyOnWriteArrayList();
            }
        }
        this.childServices.add(childService);
    }

    protected boolean removeChildService(Object childService) {
        return this.childServices != null ? this.childServices.remove(childService) : false;
    }

    protected synchronized String getVersion() {
        if (ObjectHelper.isNotNullAndNonEmpty(this.version)) {
            return this.version;
        }
        Package aPackage = this.getClass().getPackage();
        if (aPackage != null) {
            this.version = aPackage.getImplementationVersion();
            if (this.version == null) {
                this.version = aPackage.getSpecificationVersion();
            }
        }
        return this.version != null ? this.version : "";
    }
}

