/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.bean.RegistryBean;
import org.apache.camel.model.OutputType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="bean")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BeanRef
extends OutputType<ProcessorType> {
    @XmlAttribute(required=false)
    private String ref;
    @XmlAttribute(required=false)
    private String method;
    @XmlAttribute(required=false)
    private Class beanType;
    @XmlTransient
    private Object bean;

    public BeanRef() {
    }

    public BeanRef(String ref) {
        this.ref = ref;
    }

    public BeanRef(String ref, String method) {
        this.ref = ref;
        this.method = method;
    }

    public String toString() {
        return "Bean[" + this.getLabel() + "]";
    }

    @Override
    public String getShortName() {
        return "bean";
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Class getBeanType() {
        return this.beanType;
    }

    public void setBeanType(Class beanType) {
        this.beanType = beanType;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) {
        BeanProcessor answer;
        if (this.ref != null) {
            answer = new BeanProcessor(new RegistryBean(routeContext.getCamelContext(), this.ref));
        } else {
            if (this.bean == null) {
                ObjectHelper.notNull(this.beanType, "bean, ref or beanType");
                this.bean = CamelContextHelper.newInstance(routeContext.getCamelContext(), this.beanType);
            }
            answer = new BeanProcessor(this.bean, routeContext.getCamelContext());
        }
        if (this.method != null) {
            answer.setMethod(this.method);
        }
        return answer;
    }

    @Override
    public String getLabel() {
        if (this.ref != null) {
            String methodText = "";
            if (this.method != null) {
                methodText = " method: " + this.method;
            }
            return "ref: " + this.ref + methodText;
        }
        if (this.bean != null) {
            return this.bean.toString();
        }
        if (this.beanType != null) {
            return this.beanType.getName();
        }
        return "";
    }
}

