/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.config.BatchResequencerConfig;
import org.apache.camel.model.config.StreamResequencerConfig;
import org.apache.camel.model.language.ExpressionType;
import org.apache.camel.processor.Resequencer;
import org.apache.camel.processor.StreamResequencer;
import org.apache.camel.processor.resequencer.ExpressionResultComparator;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="resequencer")
public class ResequencerType
extends ProcessorType<ProcessorType> {
    @XmlElementRef
    private List<ExpressionType> expressions = new ArrayList<ExpressionType>();
    @XmlElementRef
    private List<ProcessorType<?>> outputs = new ArrayList();
    private BatchResequencerConfig batchConfig;
    private StreamResequencerConfig streamConfig;
    @XmlTransient
    private List<Expression> expressionList;

    public ResequencerType() {
        this(null);
    }

    public ResequencerType(List<Expression> expressions) {
        this.expressionList = expressions;
        this.batch();
    }

    @Override
    public String getShortName() {
        return "resequencer";
    }

    public ResequencerType stream() {
        return this.stream(StreamResequencerConfig.getDefault());
    }

    public ResequencerType batch() {
        return this.batch(BatchResequencerConfig.getDefault());
    }

    public ResequencerType stream(StreamResequencerConfig config) {
        this.streamConfig = config;
        this.batchConfig = null;
        return this;
    }

    public ResequencerType batch(BatchResequencerConfig config) {
        this.batchConfig = config;
        this.streamConfig = null;
        return this;
    }

    public ResequencerType expression(ExpressionType expression) {
        this.expressions.add(expression);
        return this;
    }

    public String toString() {
        return "Resequencer[" + this.getExpressions() + " -> " + this.getOutputs() + "]";
    }

    @Override
    public String getLabel() {
        return ExpressionType.getLabel(this.getExpressions());
    }

    public List<ExpressionType> getExpressions() {
        return this.expressions;
    }

    @Override
    public List<ProcessorType<?>> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorType<?>> outputs) {
        this.outputs = outputs;
    }

    public BatchResequencerConfig getBatchConfig() {
        return this.batchConfig;
    }

    public BatchResequencerConfig getBatchConfig(BatchResequencerConfig defaultConfig) {
        return this.batchConfig;
    }

    public StreamResequencerConfig getStreamConfig() {
        return this.streamConfig;
    }

    @XmlElement(name="batch-config", required=false)
    public void setBatchConfig(BatchResequencerConfig batchConfig) {
        this.batch(batchConfig);
    }

    @XmlElement(name="stream-config", required=false)
    public void setStreamConfig(StreamResequencerConfig streamConfig) {
        this.stream(streamConfig);
    }

    public ResequencerType timeout(long timeout) {
        if (this.batchConfig != null) {
            this.batchConfig.setBatchTimeout(timeout);
        } else {
            this.streamConfig.setTimeout(timeout);
        }
        return this;
    }

    public ResequencerType size(int batchSize) {
        if (this.batchConfig == null) {
            throw new IllegalStateException("size() only supported for batch resequencer");
        }
        this.batchConfig.setBatchSize(batchSize);
        return this;
    }

    public ResequencerType capacity(int capacity) {
        if (this.streamConfig == null) {
            throw new IllegalStateException("capacity() only supported for stream resequencer");
        }
        this.streamConfig.setCapacity(capacity);
        return this;
    }

    public ResequencerType comparator(ExpressionResultComparator<Exchange> comparator) {
        if (this.streamConfig == null) {
            throw new IllegalStateException("comparator() only supported for stream resequencer");
        }
        this.streamConfig.setComparator(comparator);
        return this;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        if (this.batchConfig != null) {
            return this.createBatchResequencer(routeContext, this.batchConfig);
        }
        return this.createStreamResequencer(routeContext, this.streamConfig);
    }

    protected Resequencer createBatchResequencer(RouteContext routeContext, BatchResequencerConfig config) throws Exception {
        Processor processor = routeContext.createProcessor(this);
        Resequencer resequencer = new Resequencer(processor, this.resolveExpressionList(routeContext));
        resequencer.setBatchSize(config.getBatchSize());
        resequencer.setBatchTimeout(config.getBatchTimeout());
        return resequencer;
    }

    protected StreamResequencer createStreamResequencer(RouteContext routeContext, StreamResequencerConfig config) throws Exception {
        config.getComparator().setExpressions(this.resolveExpressionList(routeContext));
        Processor processor = routeContext.createProcessor(this);
        StreamResequencer resequencer = new StreamResequencer(processor, config.getComparator());
        resequencer.setTimeout(config.getTimeout());
        resequencer.setCapacity(config.getCapacity());
        return resequencer;
    }

    private List<Expression> resolveExpressionList(RouteContext routeContext) {
        if (this.expressionList == null) {
            this.expressionList = new ArrayList<Expression>();
            for (ExpressionType expression : this.expressions) {
                this.expressionList.add(expression.createExpression(routeContext));
            }
        }
        if (this.expressionList.isEmpty()) {
            throw new IllegalArgumentException("No expressions configured for: " + this);
        }
        return this.expressionList;
    }
}

