/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.model.CatchType;
import org.apache.camel.model.FinallyType;
import org.apache.camel.model.OutputType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.processor.CatchProcessor;
import org.apache.camel.processor.TryProcessor;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="try")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TryType
extends OutputType<TryType> {
    @XmlTransient
    private List<CatchType> catchClauses;
    @XmlTransient
    private FinallyType finallyClause;
    @XmlTransient
    private boolean initialized;
    @XmlTransient
    private List<ProcessorType<?>> outputsWithoutCatches;

    public String toString() {
        return "Try[" + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "try";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Processor tryProcessor = this.createOutputsProcessor(routeContext, this.getOutputsWithoutCatches());
        Processor finallyProcessor = null;
        if (this.finallyClause != null) {
            finallyProcessor = this.finallyClause.createProcessor(routeContext);
        }
        ArrayList<CatchProcessor> catchProcessors = new ArrayList<CatchProcessor>();
        if (this.catchClauses != null) {
            for (CatchType catchClause : this.catchClauses) {
                catchProcessors.add(catchClause.createProcessor(routeContext));
            }
        }
        return new TryProcessor(tryProcessor, catchProcessors, finallyProcessor);
    }

    public TryType handle(Class<?> exceptionType) {
        this.popBlock();
        CatchType answer = new CatchType(exceptionType);
        this.addOutput(answer);
        this.pushBlock(answer);
        return this;
    }

    @Deprecated
    public TryType handleAll() {
        return this.finallyBlock();
    }

    public TryType finallyBlock() {
        this.popBlock();
        FinallyType answer = new FinallyType();
        this.addOutput(answer);
        this.pushBlock(answer);
        return this;
    }

    @Override
    public ProcessorType<? extends ProcessorType> end() {
        this.popBlock();
        return super.end();
    }

    public List<CatchType> getCatchClauses() {
        if (this.catchClauses == null) {
            this.checkInitialized();
        }
        return this.catchClauses;
    }

    public FinallyType getFinallyClause() {
        if (this.finallyClause == null) {
            this.checkInitialized();
        }
        return this.finallyClause;
    }

    public List<ProcessorType<?>> getOutputsWithoutCatches() {
        if (this.outputsWithoutCatches == null) {
            this.checkInitialized();
        }
        return this.outputsWithoutCatches;
    }

    @Override
    public void setOutputs(List<ProcessorType<?>> outputs) {
        this.initialized = false;
        super.setOutputs(outputs);
    }

    @Override
    public void addOutput(ProcessorType output) {
        this.initialized = false;
        super.addOutput(output);
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            this.initialized = true;
            this.outputsWithoutCatches = new ArrayList();
            this.catchClauses = new ArrayList<CatchType>();
            this.finallyClause = null;
            for (ProcessorType output : this.outputs) {
                if (output instanceof CatchType) {
                    this.catchClauses.add((CatchType)output);
                    continue;
                }
                if (output instanceof FinallyType) {
                    if (this.finallyClause != null) {
                        throw new IllegalArgumentException("Multiple finally clauses added: " + this.finallyClause + " and " + output);
                    }
                    this.finallyClause = (FinallyType)output;
                    continue;
                }
                this.outputsWithoutCatches.add(output);
            }
        }
    }
}

