/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.model.ExceptionType;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.processor.exceptionpolicy.DefaultExceptionPolicyStrategy;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyKey;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyStrategy;

public abstract class ErrorHandlerSupport
extends ServiceSupport
implements ErrorHandler {
    private Map<ExceptionPolicyKey, ExceptionType> exceptionPolicies = new LinkedHashMap<ExceptionPolicyKey, ExceptionType>();
    private ExceptionPolicyStrategy exceptionPolicy = ErrorHandlerSupport.createDefaultExceptionPolicyStrategy();

    public void addExceptionPolicy(ExceptionType exceptionType) {
        Processor processor = exceptionType.getErrorHandler();
        this.addChildService(processor);
        List<Class> list = exceptionType.getExceptionClasses();
        for (Class clazz : list) {
            ExceptionPolicyKey key = new ExceptionPolicyKey(clazz, exceptionType.getOnWhen());
            this.exceptionPolicies.put(key, exceptionType);
        }
    }

    protected boolean customProcessorForException(Exchange exchange, Throwable exception) throws Exception {
        Processor processor;
        ExceptionType policy = this.getExceptionPolicy(exchange, exception);
        if (policy != null && (processor = policy.getErrorHandler()) != null) {
            processor.process(exchange);
            return true;
        }
        return false;
    }

    protected ExceptionType getExceptionPolicy(Exchange exchange, Throwable exception) {
        if (this.exceptionPolicy == null) {
            throw new IllegalStateException("The exception policy has not been set");
        }
        return this.exceptionPolicy.getExceptionPolicy(this.exceptionPolicies, exchange, exception);
    }

    public void setExceptionPolicy(ExceptionPolicyStrategy exceptionPolicy) {
        this.exceptionPolicy = exceptionPolicy;
    }

    public static ExceptionPolicyStrategy createDefaultExceptionPolicyStrategy() {
        return new DefaultExceptionPolicyStrategy();
    }
}

