/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ExchangeHelper;

public class UnmarshalProcessor
implements Processor {
    private final DataFormat dataFormat;

    public UnmarshalProcessor(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        InputStream stream = ExchangeHelper.getMandatoryInBody(exchange, InputStream.class);
        try {
            Message out = exchange.getOut(true);
            out.copyFrom(exchange.getIn());
            Object result = this.dataFormat.unmarshal(exchange, stream);
            out.setBody(result);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }
}

