/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.server.spring.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.xbean.kernel.Kernel;
import org.apache.xbean.kernel.ServiceAlreadyExistsException;
import org.apache.xbean.kernel.ServiceFactory;
import org.apache.xbean.kernel.ServiceName;
import org.apache.xbean.kernel.ServiceNotFoundException;
import org.apache.xbean.kernel.ServiceRegistrationException;
import org.apache.xbean.kernel.StaticServiceFactory;
import org.apache.xbean.kernel.StringServiceName;
import org.apache.xbean.server.spring.loader.SpringLoader;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.support.AbstractXmlApplicationContext;

public class SpringConfiguration {
    private final AbstractXmlApplicationContext applicationContext;
    private final Map serviceFactories;
    private final Kernel kernel;

    public SpringConfiguration(AbstractXmlApplicationContext applicationContext, Kernel kernel) throws Exception {
        this.applicationContext = applicationContext;
        this.kernel = kernel;
        ClassLoader classLoader = SpringConfiguration.getClassLoader(applicationContext);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        applicationContext.refresh();
        classLoader = SpringConfiguration.getClassLoader(applicationContext);
        try {
            Map serviceNameIndex = SpringConfiguration.buildServiceNameIndex(applicationContext);
            HashMap<ServiceName, StaticServiceFactory> factories = new HashMap<ServiceName, StaticServiceFactory>(serviceNameIndex.size());
            for (Map.Entry entry : serviceNameIndex.entrySet()) {
                String beanName = (String)entry.getKey();
                ServiceName serviceName = (ServiceName)entry.getValue();
                Object bean = applicationContext.getBean(beanName);
                StaticServiceFactory serviceFactory = new StaticServiceFactory(bean, classLoader);
                factories.put(serviceName, serviceFactory);
            }
            this.serviceFactories = Collections.unmodifiableMap(factories);
            for (Map.Entry entry : this.serviceFactories.entrySet()) {
                ServiceName serviceName = (ServiceName)entry.getKey();
                StaticServiceFactory serviceFactory = (StaticServiceFactory)entry.getValue();
                kernel.registerService(serviceName, (ServiceFactory)serviceFactory);
            }
        }
        catch (ServiceAlreadyExistsException e) {
            this.destroy();
            throw e;
        }
        catch (ServiceRegistrationException e) {
            this.destroy();
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public String getId() {
        return this.applicationContext.getDisplayName();
    }

    public Map getServiceFactories() {
        return this.serviceFactories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SpringConfiguration.getClassLoader(this.applicationContext));
        try {
            for (ServiceName serviceName : this.serviceFactories.keySet()) {
                try {
                    this.kernel.unregisterService(serviceName);
                }
                catch (ServiceNotFoundException e) {
                }
                catch (ServiceRegistrationException e) {}
            }
            this.applicationContext.close();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private static Map buildServiceNameIndex(AbstractXmlApplicationContext applicationContext) {
        BeanDefinitionRegistry registry = null;
        if (applicationContext instanceof BeanDefinitionRegistry) {
            registry = (BeanDefinitionRegistry)applicationContext;
        } else if (applicationContext.getBeanFactory() instanceof BeanDefinitionRegistry) {
            registry = (BeanDefinitionRegistry)applicationContext.getBeanFactory();
        }
        if (registry != null) {
            String[] beanNames = registry.getBeanDefinitionNames();
            HashMap<String, StringServiceName> serviceNameIndex = new HashMap<String, StringServiceName>(beanNames.length);
            for (int i = 0; i < beanNames.length; ++i) {
                String beanName = beanNames[i];
                BeanDefinition def = registry.getBeanDefinition(beanName);
                if (def.isAbstract()) continue;
                StringServiceName serviceName = new StringServiceName(beanName);
                serviceNameIndex.put(beanName, serviceName);
            }
            return serviceNameIndex;
        }
        String[] beanNames = applicationContext.getBeanDefinitionNames();
        HashMap<String, StringServiceName> serviceNameIndex = new HashMap<String, StringServiceName>(beanNames.length);
        for (int i = 0; i < beanNames.length; ++i) {
            String beanName = beanNames[i];
            StringServiceName serviceName = new StringServiceName(beanName);
            serviceNameIndex.put(beanName, serviceName);
        }
        return serviceNameIndex;
    }

    protected static ClassLoader getClassLoader(AbstractXmlApplicationContext applicationContext) {
        ClassLoader classLoader = applicationContext.getClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = SpringLoader.class.getClassLoader();
        }
        return classLoader;
    }
}

