/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.ResourceAllocationException;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.BaseDestination;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.IndirectMessageReference;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.MessageReferenceFilter;
import org.apache.activemq.broker.region.PrefetchSubscription;
import org.apache.activemq.broker.region.QueueBrowserSubscription;
import org.apache.activemq.broker.region.QueueDispatchSelector;
import org.apache.activemq.broker.region.QueueMessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.cursors.PendingMessageCursor;
import org.apache.activemq.broker.region.cursors.StoreQueueCursor;
import org.apache.activemq.broker.region.cursors.VMPendingMessageCursor;
import org.apache.activemq.broker.region.group.MessageGroupHashBucketFactory;
import org.apache.activemq.broker.region.group.MessageGroupMap;
import org.apache.activemq.broker.region.group.MessageGroupMapFactory;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.broker.region.policy.DispatchPolicy;
import org.apache.activemq.broker.region.policy.RoundRobinDispatchPolicy;
import org.apache.activemq.broker.region.policy.SharedDeadLetterStrategy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerAck;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.filter.NonCachedMessageEvaluationContext;
import org.apache.activemq.selector.SelectorParser;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.thread.DeterministicTaskRunner;
import org.apache.activemq.thread.Task;
import org.apache.activemq.thread.TaskRunner;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.transaction.Synchronization;
import org.apache.activemq.usage.Usage;
import org.apache.activemq.usage.UsageListener;
import org.apache.activemq.util.BrokerSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Queue
extends BaseDestination
implements Task,
UsageListener {
    protected static final Log LOG = LogFactory.getLog(Queue.class);
    protected TaskRunnerFactory taskFactory;
    protected TaskRunner taskRunner;
    protected final List<Subscription> consumers = new ArrayList<Subscription>(50);
    protected PendingMessageCursor messages;
    private final LinkedHashMap<MessageId, QueueMessageReference> pagedInMessages = new LinkedHashMap();
    private List<QueueMessageReference> pagedInPendingDispatch = new ArrayList<QueueMessageReference>(100);
    private MessageGroupMap messageGroupOwners;
    private DispatchPolicy dispatchPolicy = new RoundRobinDispatchPolicy();
    private DeadLetterStrategy deadLetterStrategy = new SharedDeadLetterStrategy();
    private MessageGroupMapFactory messageGroupMapFactory = new MessageGroupHashBucketFactory();
    private final Object sendLock = new Object();
    private ExecutorService executor;
    protected final LinkedList<Runnable> messagesWaitingForSpace = new LinkedList();
    private final ReentrantLock dispatchLock = new ReentrantLock();
    private boolean useConsumerPriority = true;
    private boolean strictOrderDispatch = false;
    private QueueDispatchSelector dispatchSelector;
    private boolean optimizedDispatch = false;
    private boolean firstConsumer = false;
    private int timeBeforeDispatchStarts = 0;
    private int consumersBeforeDispatchStarts = 0;
    private CountDownLatch consumersBeforeStartsLatch;
    private final Runnable sendMessagesWaitingForSpaceTask = new Runnable(){

        public void run() {
            Queue.this.wakeup();
        }
    };
    private final Object iteratingMutex = new Object(){};
    private static final Comparator<Subscription> orderedCompare = new Comparator<Subscription>(){

        @Override
        public int compare(Subscription s1, Subscription s2) {
            return s2.getConsumerInfo().getPriority() - s1.getConsumerInfo().getPriority();
        }
    };
    LinkedList<RecoveryDispatch> recoveries = new LinkedList();

    public Queue(BrokerService brokerService, ActiveMQDestination destination, MessageStore store, DestinationStatistics parentStats, TaskRunnerFactory taskFactory) throws Exception {
        super(brokerService, store, destination, parentStats);
        this.taskFactory = taskFactory;
        this.dispatchSelector = new QueueDispatchSelector(destination);
    }

    @Override
    public void initialize() throws Exception {
        if (this.messages == null) {
            this.messages = this.destination.isTemporary() || this.broker == null || this.store == null ? new VMPendingMessageCursor() : new StoreQueueCursor(this.broker, this);
        }
        if (this.messages instanceof VMPendingMessageCursor) {
            this.systemUsage = this.brokerService.getSystemUsage();
            this.memoryUsage.setParent(this.systemUsage.getMemoryUsage());
        }
        if (this.isOptimizedDispatch()) {
            this.taskRunner = this.taskFactory.createTaskRunner(this, "TempQueue:  " + this.destination.getPhysicalName());
        } else {
            final Queue queue = this;
            this.executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

                public Thread newThread(Runnable runnable) {
                    QueueThread thread = new QueueThread(runnable, "QueueThread:" + Queue.this.destination, queue);
                    thread.setDaemon(true);
                    thread.setPriority(5);
                    return thread;
                }
            });
            this.taskRunner = new DeterministicTaskRunner(this.executor, this);
        }
        super.initialize();
        if (this.store != null) {
            this.messages.setSystemUsage(this.systemUsage);
            this.messages.setEnableAudit(this.isEnableAudit());
            this.messages.setMaxAuditDepth(this.getMaxAuditDepth());
            this.messages.setMaxProducersToAudit(this.getMaxProducersToAudit());
            this.messages.setUseCache(this.isUseCache());
            if (this.messages.isRecoveryRequired()) {
                this.store.recover(new MessageRecoveryListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean recoverMessage(Message message) {
                        if (Queue.this.broker.isExpired(message)) {
                            Queue.this.broker.messageExpired(Queue.this.createConnectionContext(), message);
                            Queue.this.destinationStatistics.getMessages().decrement();
                            return true;
                        }
                        if (this.hasSpace()) {
                            message.setRegionDestination(Queue.this);
                            PendingMessageCursor pendingMessageCursor = Queue.this.messages;
                            synchronized (pendingMessageCursor) {
                                try {
                                    Queue.this.messages.addMessageLast(message);
                                }
                                catch (Exception e) {
                                    LOG.fatal((Object)"Failed to add message to cursor", (Throwable)e);
                                }
                            }
                            Queue.this.destinationStatistics.getMessages().increment();
                            return true;
                        }
                        return false;
                    }

                    public boolean recoverMessageReference(MessageId messageReference) throws Exception {
                        throw new RuntimeException("Should not be called.");
                    }

                    public boolean hasSpace() {
                        return true;
                    }

                    public boolean isDuplicate(MessageId id) {
                        return false;
                    }
                });
            } else {
                int messageCount = this.store.getMessageCount();
                this.destinationStatistics.getMessages().setCount(messageCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSubscription(ConnectionContext context, Subscription sub) throws Exception {
        this.dispatchLock.lock();
        try {
            sub.add(context, this);
            this.destinationStatistics.getConsumers().increment();
            Object object = this.consumers;
            synchronized (object) {
                if (this.consumers.size() == 0) {
                    this.firstConsumer = true;
                    if (this.consumersBeforeDispatchStarts != 0) {
                        this.consumersBeforeStartsLatch = new CountDownLatch(this.consumersBeforeDispatchStarts - 1);
                    }
                } else if (this.consumersBeforeStartsLatch != null) {
                    this.consumersBeforeStartsLatch.countDown();
                }
                this.addToConsumerList(sub);
                if (sub.getConsumerInfo().isExclusive()) {
                    Subscription exclusiveConsumer = this.dispatchSelector.getExclusiveConsumer();
                    if (exclusiveConsumer == null) {
                        exclusiveConsumer = sub;
                    } else if (sub.getConsumerInfo().getPriority() > exclusiveConsumer.getConsumerInfo().getPriority()) {
                        exclusiveConsumer = sub;
                    }
                    this.dispatchSelector.setExclusiveConsumer(exclusiveConsumer);
                }
            }
            if (sub instanceof QueueBrowserSubscription) {
                this.pageInMessages(false);
                object = this.pagedInMessages;
                synchronized (object) {
                    RecoveryDispatch rd = new RecoveryDispatch();
                    rd.messages = new ArrayList<QueueMessageReference>(this.pagedInMessages.values());
                    rd.subscription = sub;
                    this.recoveries.addLast(rd);
                }
                ((QueueBrowserSubscription)sub).incrementQueueRef();
            }
            if (!this.optimizedDispatch) {
                this.wakeup();
            }
        }
        finally {
            this.dispatchLock.unlock();
        }
        if (this.optimizedDispatch) {
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubscription(ConnectionContext context, Subscription sub) throws Exception {
        this.destinationStatistics.getConsumers().decrement();
        this.dispatchLock.lock();
        try {
            List<Subscription> list = this.consumers;
            synchronized (list) {
                Subscription exclusiveConsumer;
                this.removeFromConsumerList(sub);
                if (sub.getConsumerInfo().isExclusive() && (exclusiveConsumer = this.dispatchSelector.getExclusiveConsumer()) == sub) {
                    exclusiveConsumer = null;
                    for (Subscription s : this.consumers) {
                        if (!s.getConsumerInfo().isExclusive() || exclusiveConsumer != null && s.getConsumerInfo().getPriority() <= exclusiveConsumer.getConsumerInfo().getPriority()) continue;
                        exclusiveConsumer = s;
                    }
                    this.dispatchSelector.setExclusiveConsumer(exclusiveConsumer);
                }
                ConsumerId consumerId = sub.getConsumerInfo().getConsumerId();
                this.getMessageGroupOwners().removeConsumer(consumerId);
                ArrayList<QueueMessageReference> list2 = new ArrayList<QueueMessageReference>();
                for (MessageReference ref : sub.remove(context, this)) {
                    QueueMessageReference qmr = (QueueMessageReference)ref;
                    if (qmr.getLockOwner() == sub) {
                        qmr.unlock();
                        qmr.incrementRedeliveryCounter();
                    }
                    list2.add(qmr);
                }
                if (!list2.isEmpty()) {
                    this.doDispatch(list2);
                }
            }
            if (this.consumers.isEmpty() && !(sub instanceof QueueBrowserSubscription)) {
                ArrayList<QueueMessageReference> list3 = new ArrayList<QueueMessageReference>();
                for (QueueMessageReference ref : this.pagedInMessages.values()) {
                    list3.add(ref);
                }
                this.pagedInPendingDispatch.clear();
                this.doDispatch(list3);
            }
            if (!this.optimizedDispatch) {
                this.wakeup();
            }
        }
        finally {
            this.dispatchLock.unlock();
        }
        if (this.optimizedDispatch) {
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(final ProducerBrokerExchange producerExchange, final Message message) throws Exception {
        boolean sendProducerAck;
        final ConnectionContext context = producerExchange.getConnectionContext();
        message.setRegionDestination(this);
        final ProducerInfo producerInfo = producerExchange.getProducerState().getInfo();
        boolean bl = sendProducerAck = !message.isResponseRequired() && producerInfo.getWindowSize() > 0 && !context.isInRecoveryMode();
        if (message.isExpired()) {
            this.broker.getRoot().messageExpired(context, message);
            if (sendProducerAck) {
                ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), message.getSize());
                context.getConnection().dispatchAsync(ack);
            }
            return;
        }
        if (this.isProducerFlowControl() && context.isProducerFlowControl() && this.memoryUsage.isFull()) {
            if (this.systemUsage.isSendFailIfNoSpace()) {
                throw new ResourceAllocationException("SystemUsage memory limit reached");
            }
            if (producerInfo.getWindowSize() > 0 || message.isResponseRequired()) {
                LinkedList<Runnable> ack = this.messagesWaitingForSpace;
                synchronized (ack) {
                    this.messagesWaitingForSpace.add(new Runnable(){

                        public void run() {
                            block6: {
                                try {
                                    if (Queue.this.broker.isExpired(message)) {
                                        Queue.this.broker.messageExpired(context, message);
                                    } else {
                                        Queue.this.doMessageSend(producerExchange, message);
                                    }
                                    if (sendProducerAck) {
                                        ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), message.getSize());
                                        context.getConnection().dispatchAsync(ack);
                                    } else {
                                        Response response = new Response();
                                        response.setCorrelationId(message.getCommandId());
                                        context.getConnection().dispatchAsync(response);
                                    }
                                }
                                catch (Exception e) {
                                    if (sendProducerAck || context.isInRecoveryMode()) break block6;
                                    ExceptionResponse response = new ExceptionResponse(e);
                                    response.setCorrelationId(message.getCommandId());
                                    context.getConnection().dispatchAsync(response);
                                }
                            }
                        }
                    });
                    if (!this.memoryUsage.notifyCallbackWhenNotFull(this.sendMessagesWaitingForSpaceTask)) {
                        this.sendMessagesWaitingForSpaceTask.run();
                    }
                    context.setDontSendReponse(true);
                    return;
                }
            }
            while (!this.memoryUsage.waitForSpace(1000L)) {
                if (!context.getStopping().get()) continue;
                throw new IOException("Connection closed, send aborted.");
            }
            if (message.isExpired()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Expired message: " + message));
                }
                this.broker.getRoot().messageExpired(context, message);
                return;
            }
        }
        this.doMessageSend(producerExchange, message);
        if (sendProducerAck) {
            ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), message.getSize());
            context.getConnection().dispatchAsync(ack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doMessageSend(ProducerBrokerExchange producerExchange, final Message message) throws IOException, Exception {
        final ConnectionContext context = producerExchange.getConnectionContext();
        Object object = this.sendLock;
        synchronized (object) {
            if (this.store != null && message.isPersistent()) {
                while (!this.systemUsage.getStoreUsage().waitForSpace(1000L)) {
                    if (!context.getStopping().get()) continue;
                    throw new IOException("Connection closed, send (waiting for store soace) aborted. msg: " + message);
                }
                message.getMessageId().setBrokerSequenceId(this.getDestinationSequenceId());
                this.store.addMessage(context, message);
            }
        }
        if (context.isInTransaction()) {
            message.incrementReferenceCount();
            context.getTransaction().addSynchronization(new Synchronization(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterCommit() throws Exception {
                    try {
                        if (Queue.this.broker.isExpired(message)) {
                            Queue.this.broker.messageExpired(context, message);
                            return;
                        }
                        Queue.this.sendMessage(context, message);
                    }
                    finally {
                        message.decrementReferenceCount();
                    }
                }

                public void afterRollback() throws Exception {
                    message.decrementReferenceCount();
                }
            });
        } else {
            this.sendMessage(context, message);
        }
    }

    @Override
    public void dispose(ConnectionContext context) throws IOException {
        super.dispose(context);
        if (this.store != null) {
            this.store.removeAllMessages(context);
        }
    }

    @Override
    public void gc() {
    }

    @Override
    public void acknowledge(ConnectionContext context, Subscription sub, MessageAck ack, MessageReference node) throws IOException {
        if (this.store != null && node.isPersistent()) {
            if (ack.getMessageCount() > 0) {
                MessageAck a = new MessageAck();
                ack.copy(a);
                ack = a;
                ack.setFirstMessageId(node.getMessageId());
                ack.setLastMessageId(node.getMessageId());
                ack.setMessageCount(1);
            }
            this.store.removeMessage(context, ack);
        }
    }

    Message loadMessage(MessageId messageId) throws IOException {
        Message msg = this.store.getMessage(messageId);
        if (msg != null) {
            msg.setRegionDestination(this);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int size = 0;
        PendingMessageCursor pendingMessageCursor = this.messages;
        synchronized (pendingMessageCursor) {
            size = this.messages.size();
        }
        return "Queue: destination=" + this.destination.getPhysicalName() + ", subscriptions=" + this.consumers.size() + ", memory=" + this.memoryUsage.getPercentUsage() + "%, size=" + size + ", in flight groups=" + this.messageGroupOwners;
    }

    @Override
    public void start() throws Exception {
        if (this.memoryUsage != null) {
            this.memoryUsage.start();
        }
        this.systemUsage.getMemoryUsage().addUsageListener(this);
        this.messages.start();
        this.doPageIn(false);
    }

    @Override
    public void stop() throws Exception {
        if (this.taskRunner != null) {
            this.taskRunner.shutdown();
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if (this.messages != null) {
            this.messages.stop();
        }
        this.systemUsage.getMemoryUsage().removeUsageListener(this);
        if (this.memoryUsage != null) {
            this.memoryUsage.stop();
        }
    }

    @Override
    public ActiveMQDestination getActiveMQDestination() {
        return this.destination;
    }

    public MessageGroupMap getMessageGroupOwners() {
        if (this.messageGroupOwners == null) {
            this.messageGroupOwners = this.getMessageGroupMapFactory().createMessageGroupMap();
        }
        return this.messageGroupOwners;
    }

    public DispatchPolicy getDispatchPolicy() {
        return this.dispatchPolicy;
    }

    public void setDispatchPolicy(DispatchPolicy dispatchPolicy) {
        this.dispatchPolicy = dispatchPolicy;
    }

    @Override
    public DeadLetterStrategy getDeadLetterStrategy() {
        return this.deadLetterStrategy;
    }

    public void setDeadLetterStrategy(DeadLetterStrategy deadLetterStrategy) {
        this.deadLetterStrategy = deadLetterStrategy;
    }

    public MessageGroupMapFactory getMessageGroupMapFactory() {
        return this.messageGroupMapFactory;
    }

    public void setMessageGroupMapFactory(MessageGroupMapFactory messageGroupMapFactory) {
        this.messageGroupMapFactory = messageGroupMapFactory;
    }

    public PendingMessageCursor getMessages() {
        return this.messages;
    }

    public void setMessages(PendingMessageCursor messages) {
        this.messages = messages;
    }

    public boolean isUseConsumerPriority() {
        return this.useConsumerPriority;
    }

    public void setUseConsumerPriority(boolean useConsumerPriority) {
        this.useConsumerPriority = useConsumerPriority;
    }

    public boolean isStrictOrderDispatch() {
        return this.strictOrderDispatch;
    }

    public void setStrictOrderDispatch(boolean strictOrderDispatch) {
        this.strictOrderDispatch = strictOrderDispatch;
    }

    public boolean isOptimizedDispatch() {
        return this.optimizedDispatch;
    }

    public void setOptimizedDispatch(boolean optimizedDispatch) {
        this.optimizedDispatch = optimizedDispatch;
    }

    public int getTimeBeforeDispatchStarts() {
        return this.timeBeforeDispatchStarts;
    }

    public void setTimeBeforeDispatchStarts(int timeBeforeDispatchStarts) {
        this.timeBeforeDispatchStarts = timeBeforeDispatchStarts;
    }

    public int getConsumersBeforeDispatchStarts() {
        return this.consumersBeforeDispatchStarts;
    }

    public void setConsumersBeforeDispatchStarts(int consumersBeforeDispatchStarts) {
        this.consumersBeforeDispatchStarts = consumersBeforeDispatchStarts;
    }

    private QueueMessageReference createMessageReference(Message message) {
        IndirectMessageReference result = new IndirectMessageReference(message);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message[] browse() {
        ArrayList<Message> l;
        block18: {
            l = new ArrayList<Message>();
            try {
                Message m;
                int count;
                Iterator<QueueMessageReference> i;
                this.pageInMessages(false);
                Object object = this.pagedInPendingDispatch;
                synchronized (object) {
                    i = this.pagedInPendingDispatch.iterator();
                    for (count = 0; i.hasNext() && count < this.getMaxBrowsePageSize(); ++count) {
                        l.add(i.next().getMessage());
                    }
                }
                if (count < this.getMaxBrowsePageSize()) {
                    object = this.pagedInMessages;
                    synchronized (object) {
                        i = this.pagedInMessages.values().iterator();
                        while (i.hasNext() && count < this.getMaxBrowsePageSize()) {
                            m = i.next().getMessage();
                            if (l.contains(m)) continue;
                            l.add(m);
                            ++count;
                        }
                    }
                }
                if (count >= this.getMaxBrowsePageSize()) break block18;
                object = this.messages;
                synchronized (object) {
                    try {
                        this.messages.reset();
                        while (this.messages.hasNext() && count < this.getMaxBrowsePageSize()) {
                            MessageReference node = this.messages.next();
                            this.messages.rollback(node.getMessageId());
                            if (node == null || l.contains(m = node.getMessage())) continue;
                            l.add(m);
                            ++count;
                        }
                    }
                    finally {
                        this.messages.release();
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Problem retrieving message in browse() ", (Throwable)e);
            }
        }
        return l.toArray(new Message[l.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message getMessage(String id) {
        MessageId msgId = new MessageId(id);
        try {
            MessageReference r;
            Object object = this.pagedInMessages;
            synchronized (object) {
                r = this.pagedInMessages.get(msgId);
                if (r != null) {
                    return r.getMessage();
                }
            }
            object = this.messages;
            synchronized (object) {
                try {
                    Message message;
                    block14: {
                        this.messages.reset();
                        while (this.messages.hasNext()) {
                            try {
                                r = this.messages.next();
                                this.messages.rollback(r.getMessageId());
                                if (!msgId.equals(r.getMessageId())) continue;
                                Message m = r.getMessage();
                                if (m == null) return null;
                                message = m;
                                break block14;
                            }
                            catch (IOException e) {
                                LOG.error((Object)("got an exception retrieving message " + id));
                            }
                        }
                        return null;
                    }
                    return message;
                }
                finally {
                    this.messages.release();
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)("got an exception retrieving message " + id));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() throws Exception {
        ConnectionContext c = this.createConnectionContext();
        ArrayList<QueueMessageReference> list = null;
        do {
            this.pageInMessages();
            LinkedHashMap<MessageId, QueueMessageReference> linkedHashMap = this.pagedInMessages;
            synchronized (linkedHashMap) {
                list = new ArrayList<QueueMessageReference>(this.pagedInMessages.values());
            }
            for (MessageReference messageReference : list) {
                try {
                    QueueMessageReference r = (QueueMessageReference)messageReference;
                    this.removeMessage(c, (IndirectMessageReference)r);
                }
                catch (IOException e) {}
            }
        } while (!this.pagedInMessages.isEmpty() || this.destinationStatistics.getMessages().getCount() > 0L);
        this.gc();
    }

    public boolean removeMessage(String messageId) throws Exception {
        return this.removeMatchingMessages(this.createMessageIdFilter(messageId), 1) > 0;
    }

    public int removeMatchingMessages(String selector) throws Exception {
        return this.removeMatchingMessages(selector, -1);
    }

    public int removeMatchingMessages(String selector, int maximumMessages) throws Exception {
        return this.removeMatchingMessages(this.createSelectorFilter(selector), maximumMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeMatchingMessages(MessageReferenceFilter filter, int maximumMessages) throws Exception {
        int movedCounter = 0;
        CopyOnWriteArraySet<QueueMessageReference> set = new CopyOnWriteArraySet<QueueMessageReference>();
        ConnectionContext context = this.createConnectionContext();
        do {
            this.pageInMessages();
            LinkedHashMap<MessageId, QueueMessageReference> linkedHashMap = this.pagedInMessages;
            synchronized (linkedHashMap) {
                set.addAll(this.pagedInMessages.values());
            }
            ArrayList list = new ArrayList(set);
            for (MessageReference ref : list) {
                IndirectMessageReference r = (IndirectMessageReference)ref;
                if (!filter.evaluate(context, r)) continue;
                this.removeMessage(context, r);
                set.remove(r);
                if (++movedCounter < maximumMessages || maximumMessages <= 0) continue;
                return movedCounter;
            }
        } while ((long)set.size() < this.destinationStatistics.getMessages().getCount());
        return movedCounter;
    }

    public boolean copyMessageTo(ConnectionContext context, String messageId, ActiveMQDestination dest) throws Exception {
        return this.copyMatchingMessages(context, this.createMessageIdFilter(messageId), dest, 1) > 0;
    }

    public int copyMatchingMessagesTo(ConnectionContext context, String selector, ActiveMQDestination dest) throws Exception {
        return this.copyMatchingMessagesTo(context, selector, dest, -1);
    }

    public int copyMatchingMessagesTo(ConnectionContext context, String selector, ActiveMQDestination dest, int maximumMessages) throws Exception {
        return this.copyMatchingMessages(context, this.createSelectorFilter(selector), dest, maximumMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copyMatchingMessages(ConnectionContext context, MessageReferenceFilter filter, ActiveMQDestination dest, int maximumMessages) throws Exception {
        int movedCounter = 0;
        int count = 0;
        CopyOnWriteArraySet<QueueMessageReference> set = new CopyOnWriteArraySet<QueueMessageReference>();
        do {
            int oldMaxSize = this.getMaxPageSize();
            this.setMaxPageSize((int)this.destinationStatistics.getMessages().getCount());
            this.pageInMessages();
            this.setMaxPageSize(oldMaxSize);
            LinkedHashMap<MessageId, QueueMessageReference> linkedHashMap = this.pagedInMessages;
            synchronized (linkedHashMap) {
                set.addAll(this.pagedInMessages.values());
            }
            ArrayList list = new ArrayList(set);
            for (MessageReference ref : list) {
                IndirectMessageReference r = (IndirectMessageReference)ref;
                if (filter.evaluate(context, r)) {
                    r.incrementReferenceCount();
                    try {
                        Message m = r.getMessage();
                        BrokerSupport.resend(context, m, dest);
                        if (++movedCounter >= maximumMessages && maximumMessages > 0) {
                            int n = movedCounter;
                            return n;
                        }
                    }
                    finally {
                        r.decrementReferenceCount();
                    }
                }
                ++count;
            }
        } while ((long)count < this.destinationStatistics.getMessages().getCount());
        return movedCounter;
    }

    public boolean moveMessageTo(ConnectionContext context, String messageId, ActiveMQDestination dest) throws Exception {
        return this.moveMatchingMessagesTo(context, this.createMessageIdFilter(messageId), dest, 1) > 0;
    }

    public int moveMatchingMessagesTo(ConnectionContext context, String selector, ActiveMQDestination dest) throws Exception {
        return this.moveMatchingMessagesTo(context, selector, dest, Integer.MAX_VALUE);
    }

    public int moveMatchingMessagesTo(ConnectionContext context, String selector, ActiveMQDestination dest, int maximumMessages) throws Exception {
        return this.moveMatchingMessagesTo(context, this.createSelectorFilter(selector), dest, maximumMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int moveMatchingMessagesTo(ConnectionContext context, MessageReferenceFilter filter, ActiveMQDestination dest, int maximumMessages) throws Exception {
        int movedCounter = 0;
        CopyOnWriteArraySet<QueueMessageReference> set = new CopyOnWriteArraySet<QueueMessageReference>();
        do {
            this.doPageIn(true);
            LinkedHashMap<MessageId, QueueMessageReference> linkedHashMap = this.pagedInMessages;
            synchronized (linkedHashMap) {
                set.addAll(this.pagedInMessages.values());
            }
            ArrayList list = new ArrayList(set);
            for (MessageReference ref : list) {
                IndirectMessageReference r = (IndirectMessageReference)ref;
                if (filter.evaluate(context, r)) {
                    Message m = r.getMessage();
                    BrokerSupport.resend(context, m, dest);
                    this.removeMessage(context, r);
                    set.remove(r);
                    if (++movedCounter < maximumMessages || maximumMessages <= 0) continue;
                    return movedCounter;
                }
                PendingMessageCursor pendingMessageCursor = this.messages;
                synchronized (pendingMessageCursor) {
                    this.messages.rollback(r.getMessageId());
                }
            }
        } while ((long)set.size() < this.destinationStatistics.getMessages().getCount() && set.size() < maximumMessages);
        return movedCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RecoveryDispatch getNextRecoveryDispatch() {
        LinkedHashMap<MessageId, QueueMessageReference> linkedHashMap = this.pagedInMessages;
        synchronized (linkedHashMap) {
            if (this.recoveries.isEmpty()) {
                return null;
            }
            return this.recoveries.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRecoveryDispatchEmpty() {
        LinkedHashMap<MessageId, QueueMessageReference> linkedHashMap = this.pagedInMessages;
        synchronized (linkedHashMap) {
            return this.recoveries.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean iterate() {
        boolean pageInMoreMessages = false;
        Object object = this.iteratingMutex;
        synchronized (object) {
            boolean bl;
            RecoveryDispatch rd;
            LinkedList<Runnable> linkedList = this.messagesWaitingForSpace;
            synchronized (linkedList) {
                while (!this.messagesWaitingForSpace.isEmpty() && !this.memoryUsage.isFull()) {
                    Runnable op = this.messagesWaitingForSpace.removeFirst();
                    op.run();
                }
            }
            while ((rd = this.getNextRecoveryDispatch()) != null) {
                pageInMoreMessages = true;
                try {
                    NonCachedMessageEvaluationContext msgContext = new NonCachedMessageEvaluationContext();
                    msgContext.setDestination(this.destination);
                    for (QueueMessageReference node : rd.messages) {
                        if (node.isAcked()) continue;
                        ((MessageEvaluationContext)msgContext).setMessageReference(node);
                        if (!rd.subscription.matches(node, msgContext)) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(this.destination.getQualifiedName() + " - Recovery - Message pushed '" + node.hashCode() + " - " + node + "' to subscription: '" + rd.subscription + "'"));
                        }
                        rd.subscription.add(node);
                    }
                    if (!(rd.subscription instanceof QueueBrowserSubscription)) continue;
                    ((QueueBrowserSubscription)rd.subscription).decrementQueueRef();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.firstConsumer) {
                this.firstConsumer = false;
                try {
                    if (this.consumersBeforeDispatchStarts > 0) {
                        int timeout = 1000;
                        if (this.timeBeforeDispatchStarts > 0) {
                            timeout = this.timeBeforeDispatchStarts;
                        }
                        if (this.consumersBeforeStartsLatch.await(timeout, TimeUnit.MILLISECONDS)) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)(this.consumers.size() + " consumers subscribed. Starting dispatch."));
                            }
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(timeout + " ms elapsed and " + this.consumers.size() + " consumers subscribed. Starting dispatch."));
                        }
                    }
                    if (this.timeBeforeDispatchStarts > 0 && this.consumersBeforeDispatchStarts <= 0) {
                        this.iteratingMutex.wait(this.timeBeforeDispatchStarts);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(this.timeBeforeDispatchStarts + " ms elapsed. Starting dispatch."));
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)e);
                }
            }
            PendingMessageCursor e = this.messages;
            synchronized (e) {
                pageInMoreMessages |= !this.messages.isEmpty();
            }
            this.dispatchLock.lock();
            try {
                bl = !this.pagedInPendingDispatch.isEmpty();
            }
            finally {
                this.dispatchLock.unlock();
            }
            if (pageInMoreMessages |= bl) {
                try {
                    this.pageInMessages(false);
                }
                catch (Throwable e2) {
                    LOG.error((Object)"Failed to page in more queue messages ", e2);
                }
            }
            return !this.messagesWaitingForSpace.isEmpty();
        }
    }

    protected MessageReferenceFilter createMessageIdFilter(final String messageId) {
        return new MessageReferenceFilter(){

            public boolean evaluate(ConnectionContext context, MessageReference r) {
                return messageId.equals(r.getMessageId().toString());
            }

            public String toString() {
                return "MessageIdFilter: " + messageId;
            }
        };
    }

    protected MessageReferenceFilter createSelectorFilter(String selector) throws InvalidSelectorException {
        final BooleanExpression selectorExpression = new SelectorParser().parse(selector);
        return new MessageReferenceFilter(){

            public boolean evaluate(ConnectionContext context, MessageReference r) throws JMSException {
                MessageEvaluationContext messageEvaluationContext = context.getMessageEvaluationContext();
                messageEvaluationContext.setMessageReference(r);
                if (messageEvaluationContext.getDestination() == null) {
                    messageEvaluationContext.setDestination(Queue.this.getActiveMQDestination());
                }
                return selectorExpression.matches(messageEvaluationContext);
            }
        };
    }

    protected void removeMessage(ConnectionContext c, QueueMessageReference r) throws IOException {
        MessageAck ack = new MessageAck();
        ack.setAckType((byte)2);
        ack.setDestination(this.destination);
        ack.setMessageID(r.getMessageId());
        this.removeMessage(c, null, r, ack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMessage(ConnectionContext context, Subscription sub, QueueMessageReference reference, MessageAck ack) throws IOException {
        reference.setAcked(true);
        if (!ack.isInTransaction()) {
            this.acknowledge(context, sub, ack, reference);
            reference.drop();
            this.destinationStatistics.getMessages().decrement();
            LinkedHashMap<MessageId, QueueMessageReference> linkedHashMap = this.pagedInMessages;
            synchronized (linkedHashMap) {
                this.pagedInMessages.remove(reference.getMessageId());
            }
            this.wakeup();
        } else {
            try {
                this.acknowledge(context, sub, ack, reference);
                context.getTransaction().addSynchronization(new Synchronization(reference){
                    final /* synthetic */ QueueMessageReference val$reference;
                    {
                        this.val$reference = queueMessageReference;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void afterCommit() throws Exception {
                        this.val$reference.drop();
                        Queue.this.destinationStatistics.getMessages().decrement();
                        LinkedHashMap linkedHashMap = Queue.this.pagedInMessages;
                        synchronized (linkedHashMap) {
                            Queue.this.pagedInMessages.remove(this.val$reference.getMessageId());
                        }
                        Queue.this.wakeup();
                    }

                    public void afterRollback() throws Exception {
                        this.val$reference.setAcked(false);
                    }
                });
            }
            catch (Throwable throwable) {
                context.getTransaction().addSynchronization(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageExpired(ConnectionContext context, PrefetchSubscription prefetchSubscription, MessageReference reference) {
        ((QueueMessageReference)reference).drop();
        this.destinationStatistics.getMessages().decrement();
        LinkedHashMap<MessageId, QueueMessageReference> linkedHashMap = this.pagedInMessages;
        synchronized (linkedHashMap) {
            this.pagedInMessages.remove(reference.getMessageId());
        }
        this.wakeup();
    }

    protected ConnectionContext createConnectionContext() {
        ConnectionContext answer = new ConnectionContext(new NonCachedMessageEvaluationContext());
        answer.getMessageEvaluationContext().setDestination(this.getActiveMQDestination());
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendMessage(ConnectionContext context, Message msg) throws Exception {
        while (!this.systemUsage.getTempUsage().waitForSpace(1000L)) {
            if (!context.getStopping().get()) continue;
            throw new IOException("Connection closed, send (waiting for temp storage) aborted. message: " + msg);
        }
        PendingMessageCursor pendingMessageCursor = this.messages;
        synchronized (pendingMessageCursor) {
            this.messages.addMessageLast(msg);
        }
        this.destinationStatistics.getEnqueues().increment();
        this.destinationStatistics.getMessages().increment();
        this.wakeup();
    }

    @Override
    public void wakeup() {
        if (this.optimizedDispatch || this.isSlave()) {
            this.iterate();
        } else {
            try {
                this.taskRunner.wakeup();
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Task Runner failed to wakeup ", (Throwable)e);
            }
        }
    }

    private boolean isSlave() {
        return this.broker.getBrokerService().isSlave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QueueMessageReference> doPageIn(boolean force) throws Exception {
        ArrayList<QueueMessageReference> resultList;
        block19: {
            ArrayList<QueueMessageReference> result = null;
            resultList = null;
            this.dispatchLock.lock();
            try {
                int toPageIn = this.getMaxPageSize() + Math.max(0, (int)this.destinationStatistics.getInflight().getCount()) - this.pagedInMessages.size();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.destination.getPhysicalName() + " toPageIn: " + toPageIn + ", Inflight: " + this.destinationStatistics.getInflight().getCount() + ", pagedInMessages.size " + this.pagedInMessages.size()));
                }
                toPageIn = Math.max(0, Math.min(toPageIn, this.getMaxPageSize()));
                if (this.isLazyDispatch() && !force) {
                    toPageIn = Math.min(this.getConsumerMessageCountBeforeFull(), toPageIn);
                }
                if ((force || !this.consumers.isEmpty()) && toPageIn > 0) {
                    this.messages.setMaxBatchSize(toPageIn);
                    int count = 0;
                    result = new ArrayList<QueueMessageReference>(toPageIn);
                    Object object = this.messages;
                    synchronized (object) {
                        try {
                            this.messages.reset();
                            while (this.messages.hasNext() && count < toPageIn) {
                                MessageReference node = this.messages.next();
                                node.incrementReferenceCount();
                                this.messages.remove();
                                if (!this.broker.isExpired(node)) {
                                    QueueMessageReference ref = this.createMessageReference(node.getMessage());
                                    result.add(ref);
                                    ++count;
                                    continue;
                                }
                                this.broker.messageExpired(this.createConnectionContext(), node);
                                this.destinationStatistics.getMessages().decrement();
                            }
                        }
                        finally {
                            this.messages.release();
                        }
                    }
                    object = this.pagedInMessages;
                    synchronized (object) {
                        resultList = new ArrayList(result.size());
                        for (QueueMessageReference ref : result) {
                            if (this.pagedInMessages.containsKey(ref.getMessageId())) continue;
                            this.pagedInMessages.put(ref.getMessageId(), ref);
                            resultList.add(ref);
                        }
                        break block19;
                    }
                }
                resultList = new ArrayList<QueueMessageReference>();
            }
            finally {
                this.dispatchLock.unlock();
            }
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDispatch(List<QueueMessageReference> list) throws Exception {
        this.dispatchLock.lock();
        try {
            if (!this.pagedInPendingDispatch.isEmpty()) {
                this.pagedInPendingDispatch = this.doActualDispatch(this.pagedInPendingDispatch);
            }
            if (list != null && !list.isEmpty()) {
                if (this.pagedInPendingDispatch.isEmpty()) {
                    this.pagedInPendingDispatch.addAll(this.doActualDispatch(list));
                } else {
                    for (QueueMessageReference qmr : list) {
                        if (!this.pagedInPendingDispatch.contains(qmr)) {
                            this.pagedInPendingDispatch.add(qmr);
                        }
                        this.wakeup();
                    }
                }
            }
        }
        finally {
            this.dispatchLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QueueMessageReference> doActualDispatch(List<QueueMessageReference> list) throws Exception {
        ArrayList<Subscription> consumers;
        List<Subscription> list2 = this.consumers;
        synchronized (list2) {
            if (this.consumers.isEmpty()) {
                return list;
            }
            consumers = new ArrayList<Subscription>(this.consumers);
        }
        ArrayList<QueueMessageReference> rc = new ArrayList<QueueMessageReference>(list.size());
        HashSet<Subscription> fullConsumers = new HashSet<Subscription>(this.consumers.size());
        for (QueueMessageReference node : list) {
            Subscription target = null;
            int interestCount = 0;
            for (Subscription s : consumers) {
                if (s instanceof QueueBrowserSubscription) {
                    ++interestCount;
                    continue;
                }
                if (this.dispatchSelector.canSelect(s, node)) {
                    if (!fullConsumers.contains(s)) {
                        if (!s.isFull()) {
                            s.add(node);
                            target = s;
                            break;
                        }
                        fullConsumers.add(s);
                    }
                    ++interestCount;
                    continue;
                }
                if (node.isDropped() || node.isAcked() || node.isDropped() && !s.getConsumerInfo().isBrowser()) continue;
                ++interestCount;
            }
            if (target == null && interestCount > 0 || consumers.size() == 0) {
                rc.add(node);
            }
            if (target == null || this.strictOrderDispatch || consumers.size() <= 1 || this.dispatchSelector.isExclusiveConsumer(target)) continue;
            List<Subscription> list3 = this.consumers;
            synchronized (list3) {
                if (this.removeFromConsumerList(target)) {
                    this.addToConsumerList(target);
                    consumers = new ArrayList<Subscription>(this.consumers);
                }
            }
        }
        return rc;
    }

    private void pageInMessages() throws Exception {
        this.pageInMessages(true);
    }

    protected void pageInMessages(boolean force) throws Exception {
        this.doDispatch(this.doPageIn(force));
    }

    private void addToConsumerList(Subscription sub) {
        if (this.useConsumerPriority) {
            this.consumers.add(sub);
            Collections.sort(this.consumers, orderedCompare);
        } else {
            this.consumers.add(sub);
        }
    }

    private boolean removeFromConsumerList(Subscription sub) {
        return this.consumers.remove(sub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getConsumerMessageCountBeforeFull() throws Exception {
        int total = 0;
        boolean zeroPrefetch = false;
        List<Subscription> list = this.consumers;
        synchronized (list) {
            for (Subscription s : this.consumers) {
                zeroPrefetch |= s.getPrefetchSize() == 0;
                int countBeforeFull = s.countBeforeFull();
                total += countBeforeFull;
            }
        }
        if (total == 0 && zeroPrefetch) {
            total = 1;
        }
        return total;
    }

    @Override
    public void onUsageChanged(Usage usage, int oldPercentUsage, int newPercentUsage) {
        if (oldPercentUsage > newPercentUsage) {
            try {
                this.taskRunner.wakeup();
            }
            catch (InterruptedException e) {
                LOG.warn((Object)(this.getName() + " failed to wakeup task runner on usageChange: " + e));
            }
        }
    }

    class RecoveryDispatch {
        public ArrayList<QueueMessageReference> messages;
        public Subscription subscription;

        RecoveryDispatch() {
        }
    }

    final class QueueThread
    extends Thread {
        final Queue queue;

        public QueueThread(Runnable runnable, String name, Queue queue2) {
            super(runnable, name);
            this.queue = queue2;
        }
    }
}

