/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.converter;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jms.JmsBinding;

@Converter
public class ActiveMQMessageConverter {
    private JmsBinding binding = new JmsBinding();

    @Converter
    public ActiveMQMessage toMessage(Exchange exchange) throws JMSException {
        ActiveMQMessage message = ActiveMQMessageConverter.createActiveMQMessage(exchange);
        this.getBinding().appendJmsProperties((Message)message, exchange, exchange.getIn());
        return message;
    }

    @Converter
    public Processor toProcessor(final MessageListener listener) {
        return new Processor(){

            public void process(Exchange exchange) throws Exception {
                ActiveMQMessage message = ActiveMQMessageConverter.this.toMessage(exchange);
                listener.onMessage((Message)message);
            }

            public String toString() {
                return "Processor of MessageListener: " + listener;
            }
        };
    }

    private static ActiveMQMessage createActiveMQMessage(Exchange exchange) throws JMSException {
        Object body = exchange.getIn().getBody();
        if (body instanceof String) {
            ActiveMQTextMessage answer = new ActiveMQTextMessage();
            answer.setText((String)body);
            return answer;
        }
        if (body instanceof Serializable) {
            ActiveMQObjectMessage answer = new ActiveMQObjectMessage();
            answer.setObject((Serializable)body);
            return answer;
        }
        return new ActiveMQMessage();
    }

    public JmsBinding getBinding() {
        return this.binding;
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }
}

