/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.IOException;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.filter.DestinationFilter;
import org.apache.activemq.network.ConduitBridge;
import org.apache.activemq.network.DemandSubscription;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.transport.Transport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DurableConduitBridge
extends ConduitBridge {
    private static final Log LOG = LogFactory.getLog(DurableConduitBridge.class);

    public DurableConduitBridge(NetworkBridgeConfiguration configuration, Transport localBroker, Transport remoteBroker) {
        super(configuration, localBroker, remoteBroker);
    }

    protected void setupStaticDestinations() {
        super.setupStaticDestinations();
        ActiveMQDestination[] dests = this.durableDestinations;
        if (dests != null) {
            for (int i = 0; i < dests.length; ++i) {
                ActiveMQDestination dest = dests[i];
                if (!this.isPermissableDestination(dest) || this.doesConsumerExist(dest)) continue;
                DemandSubscription sub = this.createDemandSubscription(dest);
                if (dest.isTopic()) {
                    sub.getLocalInfo().setSubscriptionName(this.getSubscriberName(dest));
                }
                try {
                    this.addSubscription(sub);
                }
                catch (IOException e) {
                    LOG.error((Object)("Failed to add static destination " + dest), (Throwable)e);
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Forwarding messages for durable destination: " + dest));
            }
        }
    }

    protected DemandSubscription createDemandSubscription(ConsumerInfo info) throws IOException {
        if (this.addToAlreadyInterestedConsumers(info)) {
            return null;
        }
        info.addNetworkConsumerId(info.getConsumerId());
        if (info.isDurable() || info.getDestination().isQueue() && !info.getDestination().isTemporary()) {
            info.setConsumerId(new ConsumerId(this.localSessionInfo.getSessionId(), this.consumerIdGenerator.getNextSequenceId()));
        }
        if (info.isDurable()) {
            info.setSubscriptionName(this.getSubscriberName(info.getDestination()));
        }
        info.setSelector(null);
        return this.doCreateDemandSubscription(info);
    }

    protected String getSubscriberName(ActiveMQDestination dest) {
        String subscriberName = this.configuration.getBrokerName() + "_" + dest.getPhysicalName();
        return subscriberName;
    }

    protected boolean doesConsumerExist(ActiveMQDestination dest) {
        DestinationFilter filter = DestinationFilter.parseFilter(dest);
        for (DemandSubscription ds : this.subscriptionMapByLocalId.values()) {
            if (!filter.matches(ds.getLocalInfo().getDestination())) continue;
            return true;
        }
        return false;
    }
}

