/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.util.Set;
import javax.jms.Destination;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.security.AuthorizationMap;
import org.apache.activemq.security.SecurityAdminMBean;
import org.apache.activemq.security.SecurityContext;

public class AuthorizationBroker
extends BrokerFilter
implements SecurityAdminMBean {
    private final AuthorizationMap authorizationMap;

    public AuthorizationBroker(Broker next, AuthorizationMap authorizationMap) {
        super(next);
        this.authorizationMap = authorizationMap;
    }

    public void addDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        this.addDestination(context, info.getDestination());
        super.addDestinationInfo(context, info);
    }

    public org.apache.activemq.broker.region.Destination addDestination(ConnectionContext context, ActiveMQDestination destination) throws Exception {
        SecurityContext securityContext = context.getSecurityContext();
        if (securityContext == null) {
            throw new SecurityException("User is not authenticated.");
        }
        if (!securityContext.isBrokerContext()) {
            Set<?> allowedACLs = null;
            allowedACLs = !destination.isTemporary() ? this.authorizationMap.getAdminACLs(destination) : this.authorizationMap.getTempDestinationAdminACLs();
            if (allowedACLs != null && !securityContext.isInOneOf(allowedACLs)) {
                throw new SecurityException("User " + securityContext.getUserName() + " is not authorized to create: " + destination);
            }
        }
        return super.addDestination(context, destination);
    }

    public void removeDestination(ConnectionContext context, ActiveMQDestination destination, long timeout) throws Exception {
        SecurityContext securityContext = context.getSecurityContext();
        if (securityContext == null) {
            throw new SecurityException("User is not authenticated.");
        }
        Set<?> allowedACLs = null;
        allowedACLs = !destination.isTemporary() ? this.authorizationMap.getAdminACLs(destination) : this.authorizationMap.getTempDestinationAdminACLs();
        if (allowedACLs != null && !securityContext.isInOneOf(allowedACLs)) {
            throw new SecurityException("User " + securityContext.getUserName() + " is not authorized to remove: " + destination);
        }
        super.removeDestination(context, destination, timeout);
    }

    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        SecurityContext subject = context.getSecurityContext();
        if (subject == null) {
            throw new SecurityException("User is not authenticated.");
        }
        Set<?> allowedACLs = null;
        allowedACLs = !info.getDestination().isTemporary() ? this.authorizationMap.getReadACLs(info.getDestination()) : this.authorizationMap.getTempDestinationReadACLs();
        if (allowedACLs != null && !subject.isInOneOf(allowedACLs)) {
            throw new SecurityException("User " + subject.getUserName() + " is not authorized to read from: " + info.getDestination());
        }
        subject.getAuthorizedReadDests().put(info.getDestination(), info.getDestination());
        return super.addConsumer(context, info);
    }

    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        SecurityContext subject = context.getSecurityContext();
        if (subject == null) {
            throw new SecurityException("User is not authenticated.");
        }
        if (info.getDestination() != null) {
            Set<?> allowedACLs = null;
            allowedACLs = !info.getDestination().isTemporary() ? this.authorizationMap.getWriteACLs(info.getDestination()) : this.authorizationMap.getTempDestinationWriteACLs();
            if (allowedACLs != null && !subject.isInOneOf(allowedACLs)) {
                throw new SecurityException("User " + subject.getUserName() + " is not authorized to write to: " + info.getDestination());
            }
            subject.getAuthorizedWriteDests().put(info.getDestination(), info.getDestination());
        }
        super.addProducer(context, info);
    }

    public void send(ProducerBrokerExchange producerExchange, Message messageSend) throws Exception {
        SecurityContext subject = producerExchange.getConnectionContext().getSecurityContext();
        if (subject == null) {
            throw new SecurityException("User is not authenticated.");
        }
        if (!subject.getAuthorizedWriteDests().contains(messageSend.getDestination())) {
            Set<?> allowedACLs = null;
            allowedACLs = !messageSend.getDestination().isTemporary() ? this.authorizationMap.getWriteACLs(messageSend.getDestination()) : this.authorizationMap.getTempDestinationWriteACLs();
            if (allowedACLs != null && !subject.isInOneOf(allowedACLs)) {
                throw new SecurityException("User " + subject.getUserName() + " is not authorized to write to: " + messageSend.getDestination());
            }
            subject.getAuthorizedWriteDests().put(messageSend.getDestination(), messageSend.getDestination());
        }
        super.send(producerExchange, messageSend);
    }

    public void addQueueRole(String queue, String operation, String role) {
        this.addDestinationRole(new ActiveMQQueue(queue), operation, role);
    }

    public void addTopicRole(String topic, String operation, String role) {
        this.addDestinationRole(new ActiveMQTopic(topic), operation, role);
    }

    public void removeQueueRole(String queue, String operation, String role) {
        this.removeDestinationRole(new ActiveMQQueue(queue), operation, role);
    }

    public void removeTopicRole(String topic, String operation, String role) {
        this.removeDestinationRole(new ActiveMQTopic(topic), operation, role);
    }

    public void addDestinationRole(Destination destination, String operation, String role) {
    }

    public void removeDestinationRole(Destination destination, String operation, String role) {
    }

    public void addRole(String role) {
    }

    public void addUserRole(String user, String role) {
    }

    public void removeRole(String role) {
    }

    public void removeUserRole(String user, String role) {
    }
}

