/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.transport.stomp.FrameTranslator;
import org.apache.activemq.transport.stomp.LegacyFrameTranslator;
import org.apache.activemq.transport.stomp.ProtocolConverter;
import org.apache.activemq.transport.stomp.ProtocolException;
import org.apache.activemq.transport.stomp.StompFrame;

public class XStreamFrameTranslator
extends LegacyFrameTranslator {
    XStream xStream = new XStream();

    public ActiveMQMessage convertFrame(ProtocolConverter converter, StompFrame command) throws JMSException, ProtocolException {
        ActiveMQMessage msg;
        Map<String, String> headers = command.getHeaders();
        if (headers.containsKey("content-length")) {
            msg = super.convertFrame(converter, command);
        } else {
            try {
                ActiveMQObjectMessage objMsg = new ActiveMQObjectMessage();
                Object obj = this.unmarshall(new String(command.getContent(), "UTF-8"), headers.get("transformation"));
                objMsg.setObject((Serializable)obj);
                msg = objMsg;
            }
            catch (Throwable e) {
                msg = super.convertFrame(converter, command);
            }
        }
        FrameTranslator.Helper.copyStandardHeadersFromFrameToMessage(converter, command, msg, this);
        return msg;
    }

    public StompFrame convertMessage(ProtocolConverter converter, ActiveMQMessage message) throws IOException, JMSException {
        if (message.getDataStructureType() == 26) {
            StompFrame command = new StompFrame();
            command.setAction("MESSAGE");
            HashMap<String, String> headers = new HashMap<String, String>(25);
            command.setHeaders(headers);
            FrameTranslator.Helper.copyStandardHeadersFromMessageToFrame(converter, message, command, this);
            ActiveMQObjectMessage msg = (ActiveMQObjectMessage)message.copy();
            command.setContent(this.marshall(msg.getObject(), (String)headers.get("transformation")).getBytes("UTF-8"));
            return command;
        }
        return super.convertMessage(converter, message);
    }

    protected String marshall(Serializable object, String transformation) throws JMSException {
        StringWriter buffer = new StringWriter();
        Object out = transformation.equalsIgnoreCase("jms-json") ? new JettisonMappedXmlDriver().createWriter((Writer)buffer) : new PrettyPrintWriter((Writer)buffer);
        this.getXStream().marshal((Object)object, (HierarchicalStreamWriter)out);
        return buffer.toString();
    }

    protected Object unmarshall(String text, String transformation) {
        Object in = transformation.equalsIgnoreCase("jms-json") ? new JettisonMappedXmlDriver().createReader((Reader)new StringReader(text)) : new XppReader((Reader)new StringReader(text));
        return this.getXStream().unmarshal((HierarchicalStreamReader)in);
    }

    public XStream getXStream() {
        if (this.xStream == null) {
            this.xStream = this.createXStream();
        }
        return this.xStream;
    }

    public void setXStream(XStream xStream) {
        this.xStream = xStream;
    }

    protected XStream createXStream() {
        return new XStream();
    }
}

