/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.xbean;

import java.beans.PropertyEditorManager;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import org.apache.activemq.broker.BrokerFactoryHandler;
import org.apache.activemq.broker.BrokerService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xbean.spring.context.ResourceXmlApplicationContext;
import org.apache.xbean.spring.context.impl.URIEditor;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.ResourceUtils;

public class XBeanBrokerFactory
implements BrokerFactoryHandler {
    private static final transient Log LOG = LogFactory.getLog(XBeanBrokerFactory.class);

    public BrokerService createBroker(URI config) throws Exception {
        String uri = config.getSchemeSpecificPart();
        ApplicationContext context = this.createApplicationContext(uri);
        BrokerService broker = null;
        try {
            broker = (BrokerService)context.getBean("broker");
        }
        catch (BeansException e) {
            // empty catch block
        }
        if (broker == null) {
            String name;
            String[] names = context.getBeanNamesForType(BrokerService.class);
            for (int i = 0; i < names.length && (broker = (BrokerService)context.getBean(name = names[i])) == null; ++i) {
            }
        }
        if (broker == null) {
            throw new IllegalArgumentException("The configuration has no BrokerService instance for resource: " + config);
        }
        return broker;
    }

    protected ApplicationContext createApplicationContext(String uri) throws MalformedURLException {
        LOG.debug((Object)("Now attempting to figure out the type of resource: " + uri));
        File file = new File(uri);
        Object resource = file.exists() ? new FileSystemResource(uri) : (ResourceUtils.isUrl((String)uri) ? new UrlResource(uri) : new ClassPathResource(uri));
        return new ResourceXmlApplicationContext((Resource)resource);
    }

    static {
        PropertyEditorManager.registerEditor(URI.class, URIEditor.class);
    }
}

