/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.xbean;

import java.io.IOException;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.usage.SystemUsage;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class XBeanBrokerService
extends BrokerService
implements InitializingBean,
DisposableBean,
ApplicationContextAware {
    private boolean start = true;
    private boolean destroyApplicationContextOnShutdown = false;
    private ApplicationContext applicationContext;

    public void afterPropertiesSet() throws Exception {
        this.ensureSystemUsageHasStore();
        if (this.start) {
            this.start();
        }
        if (this.destroyApplicationContextOnShutdown) {
            this.addShutdownHook(new Runnable(){

                public void run() {
                    if (XBeanBrokerService.this.applicationContext instanceof ConfigurableApplicationContext) {
                        ((ConfigurableApplicationContext)XBeanBrokerService.this.applicationContext).close();
                    }
                }
            });
        }
    }

    private void ensureSystemUsageHasStore() throws IOException {
        SystemUsage usage = this.getSystemUsage();
        if (usage.getStoreUsage().getStore() == null) {
            usage.getStoreUsage().setStore(this.getPersistenceAdapter());
        }
        if (usage.getTempUsage().getStore() == null) {
            usage.getTempUsage().setStore(this.getTempDataStore());
        }
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public void setDestroyApplicationContextOnShutdown(boolean destroy) {
        this.destroyApplicationContextOnShutdown = destroy;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

