/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.xml;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.woden.ErrorLocator;
import org.apache.woden.ErrorReporter;
import org.apache.woden.WSDLException;
import org.apache.woden.internal.ErrorLocatorImpl;
import org.apache.woden.internal.util.StringUtils;
import org.apache.woden.internal.util.dom.DOMUtils;
import org.apache.woden.internal.xml.XMLAttrImpl;
import org.apache.woden.wsdl20.extensions.rpc.Argument;
import org.apache.woden.wsdl20.extensions.rpc.Direction;
import org.apache.woden.xml.ArgumentArrayAttr;
import org.w3c.dom.Element;

public class ArgumentArrayAttrImpl
extends XMLAttrImpl
implements ArgumentArrayAttr {
    public ArgumentArrayAttrImpl() {
    }

    protected ArgumentArrayAttrImpl(Element element, QName qName, String string, ErrorReporter errorReporter) throws WSDLException {
        super(element, qName, string, errorReporter);
    }

    public Argument[] getArgumentArray() {
        return (Argument[])this.getContent();
    }

    protected Object convert(Element element, String string) throws WSDLException {
        List list;
        int n;
        this.setValid(false);
        if (string != null && (n = (list = StringUtils.parseNMTokens(string)).size()) % 2 == 0) {
            int n2 = n / 2;
            Argument[] argumentArray = new Argument[n2];
            Iterator iterator = list.iterator();
            for (int i = 0; i < n2; ++i) {
                String string2 = (String)iterator.next();
                QName qName = this.convertQName(element, string2);
                if (qName == null) {
                    return null;
                }
                String string3 = (String)iterator.next();
                Direction direction = this.convertDirection(string3);
                if (direction == null) {
                    return null;
                }
                argumentArray[i] = new Argument(qName, direction);
            }
            this.setValid(true);
            return argumentArray;
        }
        this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL510", new Object[]{string}, (short)2, (Exception)new IllegalArgumentException());
        return null;
    }

    private QName convertQName(Element element, String string) throws WSDLException {
        QName qName = null;
        try {
            qName = DOMUtils.getQName(string, element);
        }
        catch (WSDLException wSDLException) {
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL510", new Object[]{string}, (short)2, (Exception)wSDLException);
        }
        return qName;
    }

    private Direction convertDirection(String string) throws WSDLException {
        Direction[] directionArray = new Direction[]{Direction.IN, Direction.INOUT, Direction.OUT, Direction.RETURN};
        for (int i = 0; i < directionArray.length; ++i) {
            if (!string.equals(directionArray[i].toString())) continue;
            return directionArray[i];
        }
        this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL510", new Object[]{string}, (short)2, (Exception)new IllegalArgumentException());
        return null;
    }
}

