/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.tool.converter;

import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.AttributeExtensible;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.woden.tool.converter.Utils;

public class Convert {
    private static String NS_URI_WSDL_2_0_BASE = "http://www.w3.org/2006/01";
    private static String NS_URI_WSDL_2_0 = NS_URI_WSDL_2_0_BASE + "/wsdl";
    private static String NS_URI_WSDL_2_0_SOAP = NS_URI_WSDL_2_0 + "/soap";
    private static String NS_URI_WSDL_2_0_SOAP_1_1_HTTP = NS_URI_WSDL_2_0_BASE + "/soap11/bindings/HTTP";
    private static String NS_URI_WSDL_2_0_SOAP_1_2_HTTP = "http://www.w3.org/2003/05/soap/bindings/HTTP";
    private static String NS_URI_WSDL_1_1 = "http://schemas.xmlsoap.org/wsdl/";
    private static String NS_URI_WSDL_1_1_SOAP = "http://schemas.xmlsoap.org/wsdl/soap/";
    private static String NS_URI_WSDL_1_1_SOAP_HTTP = "http://schemas.xmlsoap.org/soap/http";
    private static String NS_URI_WSP = "http://schemas.xmlsoap.org/ws/2004/09/policy";
    private static Map patternMappings = new HashMap();
    public static String COPY;
    public static String IGNORE;
    private static Map baseExtToBehaviorMap;
    private Map extToBehaviorMap = baseExtToBehaviorMap;
    static /* synthetic */ Class class$javax$wsdl$Binding;
    static /* synthetic */ Class class$javax$wsdl$BindingOperation;
    static /* synthetic */ Class class$javax$wsdl$Port;
    static /* synthetic */ Class class$javax$wsdl$Definition;
    static /* synthetic */ Class class$javax$wsdl$Operation;
    static /* synthetic */ Class class$javax$wsdl$Service;
    static /* synthetic */ Class class$javax$wsdl$Types;
    static /* synthetic */ Class class$org$apache$woden$tool$converter$Convert;

    public Map getExtToBehaviorMap() {
        return this.extToBehaviorMap;
    }

    public void setExtToBehaviorMap(Map map) {
        this.extToBehaviorMap = map;
    }

    public String convertDefinition(String string, Definition definition, String string2, boolean bl, boolean bl2) throws WSDLException, IOException {
        return this.convertDefinition(string, definition, new HashMap(), new HashMap(), new HashMap(), string2, bl, bl2);
    }

    private String convertDefinition(String string, Definition definition, Map map, Map map2, Map map3, String string2, boolean bl, boolean bl2) throws WSDLException, IOException {
        String string3 = definition.getDocumentBaseURI();
        String string4 = new File(string3).getName() + "2";
        OutputStream outputStream = Utils.getOutputStream(string2, string4, bl2, bl);
        PrintWriter printWriter = new PrintWriter(outputStream);
        ExtensionRegistry extensionRegistry = definition.getExtensionRegistry();
        printWriter.print("<description");
        String string5 = definition.getTargetNamespace();
        String string6 = this.convertNamespaceDecls(string, definition.getNamespaces(), printWriter, definition);
        this.convertExtensions(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = Convert.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, (ElementExtensible)definition, printWriter, definition);
        map3.put(definition, string4);
        this.convertImports(string, definition.getImports(), printWriter, definition, string5, string6, map, map2, map3, string2, bl, bl2);
        this.convertTypes(definition.getTypes(), printWriter, definition, extensionRegistry);
        this.convertPortTypes(definition.getPortTypes(), printWriter, definition, string6, map, map2);
        this.convertBindings(definition.getBindings(), printWriter, definition, string5, string6, map, map2);
        this.convertServices(definition.getServices(), printWriter, definition, string5, string6);
        printWriter.println("</description>");
        printWriter.flush();
        printWriter.close();
        return string4;
    }

    public String convertFile(String string, String string2, String string3, boolean bl, boolean bl2) throws WSDLException, IOException {
        WSDLFactory wSDLFactory = WSDLFactory.newInstance();
        WSDLReader wSDLReader = wSDLFactory.newWSDLReader();
        wSDLReader.setFeature("javax.wsdl.verbose", bl);
        Definition definition = wSDLReader.readWSDL(string2);
        return this.convertDefinition(string, definition, string3, bl, bl2);
    }

    private String convertNamespaceDecls(String string, Map map, PrintWriter printWriter, Definition definition) {
        String string2;
        String string3 = string2 = string != null && !string.equals("") ? string : definition.getTargetNamespace();
        if (string2 == null || string2.equals("")) {
            throw new IllegalArgumentException("If the source WSDL v1.1 document does not specify a targetNamespace, you must use the -targetNS command-line argument to specify one.");
        }
        printWriter.println(" xmlns=\"" + NS_URI_WSDL_2_0 + "\"");
        printWriter.print("             targetNamespace=\"" + string2 + "\"");
        definition.addNamespace("tns", string2);
        definition.addNamespace("wsoap", NS_URI_WSDL_2_0_SOAP);
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string4;
                String string5 = (String)iterator.next();
                if (string5.equals("") || string5.equals("soap") || (string4 = definition.getNamespace(string5)).equals(NS_URI_WSDL_1_1_SOAP) || string4.equals(NS_URI_WSDL_1_1)) continue;
                printWriter.print("\n             xmlns:" + string5 + "=\"" + string4 + "\"");
            }
        }
        printWriter.println(">");
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void convertExtensionAttrs(AttributeExtensible attributeExtensible, PrintWriter printWriter, Definition definition) throws WSDLException {
        Map map = attributeExtensible.getExtensionAttributes();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            QName qName = (QName)iterator.next();
            Object v = map.get(qName);
            String string = null;
            QName qName2 = null;
            if (v instanceof String) {
                string = (String)v;
            } else if (v instanceof QName) {
                qName2 = (QName)v;
            } else {
                if (!(v instanceof List)) throw new WSDLException("CONFIGURATION_ERROR", "Unknown type of extension attribute '" + qName + "': " + v.getClass().getName());
                List list = (List)v;
                int n = list.size();
                if (n > 0) {
                    Object e = list.get(0);
                    if (e instanceof String) {
                        string = StringUtils.getNMTokens((List)list);
                    } else {
                        if (!(e instanceof QName)) throw new WSDLException("CONFIGURATION_ERROR", "Unknown type of extension attribute '" + qName + "': " + e.getClass().getName());
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int i = 0; i < n; ++i) {
                            QName qName3 = (QName)list.get(i);
                            stringBuffer.append((i > 0 ? " " : "") + DOMUtils.getQualifiedValue((String)qName3.getNamespaceURI(), (String)qName3.getLocalPart(), (Definition)definition));
                        }
                        string = stringBuffer.toString();
                    }
                } else {
                    string = "";
                }
            }
            if (qName2 != null) {
                DOMUtils.printQualifiedAttribute((QName)qName, (QName)qName2, (Definition)definition, (PrintWriter)printWriter);
                continue;
            }
            DOMUtils.printQualifiedAttribute((QName)qName, (String)string, (Definition)definition, (PrintWriter)printWriter);
        }
    }

    private void convertExtensions(Class clazz, ElementExtensible elementExtensible, PrintWriter printWriter, Definition definition) throws WSDLException {
        List list = elementExtensible.getExtensibilityElements();
        if (list != null) {
            ExtensionRegistry extensionRegistry = definition.getExtensionRegistry();
            Iterator iterator = list.iterator();
            String string = clazz.getName();
            while (iterator.hasNext()) {
                ExtensibilityElement extensibilityElement = (ExtensibilityElement)iterator.next();
                QName qName = extensibilityElement.getElementType();
                String string2 = (String)this.extToBehaviorMap.get(string + qName);
                if (string2 == null) {
                    throw new IllegalArgumentException("Encountered unknown extension element '" + qName + "', as a child of " + "a " + string + ".");
                }
                if (string2.equals(COPY)) {
                    ExtensionSerializer extensionSerializer = extensionRegistry.querySerializer(clazz, qName);
                    extensionSerializer.marshall(clazz, qName, extensibilityElement, printWriter, definition, extensionRegistry);
                    continue;
                }
                if (string2.equals(IGNORE)) continue;
                throw new IllegalArgumentException("Encountered unknown behavior '" + string2 + "' registered for extension " + "element '" + qName + "', as a child of a " + string + ".");
            }
        }
    }

    private void convertImports(String string, Map map, PrintWriter printWriter, Definition definition, String string2, String string3, Map map2, Map map3, Map map4, String string4, boolean bl, boolean bl2) throws WSDLException, IOException {
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Import import_ = (Import)iterator2.next();
                Definition definition2 = import_.getDefinition();
                String string5 = null;
                if (definition2 != null) {
                    string5 = definition2.getTargetNamespace();
                    if (string5 == null || string5.equals("")) {
                        throw new IllegalArgumentException("You cannot <import> WSDL v1.1 documents that do not specify the targetNamespace attribute on the definition element.");
                    }
                    if (!string5.equals(import_.getNamespaceURI())) {
                        throw new IllegalArgumentException("The value of the namespace attribute on the <import> element must match the value of the targetNamespace attribute specified on the document being imported.");
                    }
                } else {
                    string5 = import_.getNamespaceURI();
                    if (string5 == null || string5.equals("")) {
                        throw new IllegalArgumentException("You cannot <import> WSDL v1.1 documents wihout either specifying the targetNamespace attribute on the imported definition element or specifying the namespace attribute on the <import> element.");
                    }
                }
                if (string != null && !string.equals("")) {
                    if (string5.equals(string2)) {
                        string5 = string;
                    } else if (!string5.equals(string)) {
                        string = null;
                    }
                }
                String string6 = null;
                String string7 = import_.getLocationURI();
                if (string7 != null && !string7.equals("") && definition2 != null && (string6 = (String)map4.get(definition2)) == null) {
                    string6 = this.convertDefinition(string, definition2, map2, map3, map4, string4, bl, bl2);
                }
                if (string5.equals(string3)) {
                    if (string6 == null) continue;
                    printWriter.print("  <include location=\"" + string6 + "\"");
                    this.convertExtensionAttrs((AttributeExtensible)import_, printWriter, definition);
                    printWriter.println("/>");
                    continue;
                }
                printWriter.print("  <import namespace=\"" + string5 + "\"");
                if (string6 != null) {
                    printWriter.print(" location=\"" + string6 + "\"");
                }
                this.convertExtensionAttrs((AttributeExtensible)import_, printWriter, definition);
                printWriter.println("/>");
            }
        }
    }

    private void convertTypes(Types types, PrintWriter printWriter, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        if (types == null) {
            return;
        }
        List list = types.getExtensibilityElements();
        if (list != null && list.size() > 0) {
            printWriter.println("  <types>");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ExtensibilityElement extensibilityElement = (ExtensibilityElement)iterator.next();
                QName qName = extensibilityElement.getElementType();
                ExtensionSerializer extensionSerializer = extensionRegistry.querySerializer(class$javax$wsdl$Types == null ? Convert.class$("javax.wsdl.Types") : class$javax$wsdl$Types, extensibilityElement.getElementType());
                extensionSerializer.marshall(class$javax$wsdl$Types == null ? Convert.class$("javax.wsdl.Types") : class$javax$wsdl$Types, qName, extensibilityElement, printWriter, definition, extensionRegistry);
            }
            printWriter.println("  </types>");
        }
    }

    private void convertPortTypes(Map map, PrintWriter printWriter, Definition definition, String string, Map map2, Map map3) throws WSDLException {
        if (map == null) {
            return;
        }
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            PortType portType = (PortType)iterator.next();
            if (portType.isUndefined()) continue;
            QName qName = portType.getQName();
            printWriter.print("  <interface name=\"" + qName.getLocalPart() + "\"");
            this.convertExtensionAttrs((AttributeExtensible)portType, printWriter, definition);
            printWriter.println(">");
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter2 = new PrintWriter(stringWriter);
            StringWriter stringWriter2 = new StringWriter();
            PrintWriter printWriter3 = new PrintWriter(stringWriter2);
            this.convertOperations(portType.getOperations(), printWriter3, printWriter2, definition, string, map2, map3);
            printWriter3.flush();
            printWriter.print(stringWriter2.toString());
            printWriter2.flush();
            printWriter.print(stringWriter.toString());
            printWriter.println("  </interface>");
        }
    }

    private void convertOperations(List list, PrintWriter printWriter, PrintWriter printWriter2, Definition definition, String string, Map map, Map map2) throws WSDLException {
        if (list != null && list.size() > 0) {
            HashSet<String> hashSet = new HashSet<String>();
            HashMap hashMap = new HashMap();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2;
                Operation operation = (Operation)iterator.next();
                String string3 = string2 = operation.getName();
                int n = 1;
                while (hashSet.contains(string3)) {
                    string3 = string2 + "_" + n++;
                }
                hashSet.add(string3);
                map.put(operation, new QName(string, string3));
                OperationType operationType = operation.getStyle();
                printWriter2.println("    <operation name=\"" + string3 + "\"");
                printWriter2.print("               pattern=\"" + patternMappings.get(operationType) + "\"");
                printWriter2.println(">");
                this.convertExtensions(class$javax$wsdl$Operation == null ? Convert.class$("javax.wsdl.Operation") : class$javax$wsdl$Operation, (ElementExtensible)operation, printWriter2, definition);
                this.convertInput(operation.getInput(), printWriter2, definition);
                this.convertOutput(operation.getOutput(), printWriter2, definition);
                this.convertFaults(operation.getFaults(), printWriter, printWriter2, definition, string, hashMap, map2);
                printWriter2.println("    </operation>");
            }
        }
    }

    private void convertFaults(Map map, PrintWriter printWriter, PrintWriter printWriter2, Definition definition, String string, Map map2, Map map3) throws WSDLException {
        if (map == null) {
            return;
        }
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Fault fault = (Fault)iterator.next();
            String string2 = fault.getName();
            if (string2 == null || string2.equals("")) {
                throw new IllegalArgumentException("WSDL v1.1 requires a name to be specified for every fault element.");
            }
            Message message = fault.getMessage();
            if (message == null || message.isUndefined()) {
                throw new IllegalArgumentException("WSDL v1.1 requires a (defined) message to be specified for every fault element.");
            }
            List list = message.getExtensibilityElements();
            if (list != null && list.size() > 0) {
                throw new IllegalArgumentException("Encountered extensibility elements within a message and cannot determine what to do with them: " + message);
            }
            List list2 = message.getOrderedParts(null);
            int n = list2.size();
            if (n == 1) {
                Part part = (Part)list2.get(0);
                QName qName = part.getElementName();
                if (qName == null) {
                    throw new IllegalArgumentException("The conversion utility currently supports only doc/lit style.");
                }
                QName qName2 = (QName)map2.get(string2);
                String string3 = string2;
                int n2 = 1;
                while (qName2 != null && !qName2.equals(qName)) {
                    string2 = string3 + "_" + n2++;
                    qName2 = (QName)map2.get(string2);
                }
                if (qName2 == null) {
                    printWriter.print("    <fault name=\"" + string2 + "\"");
                    DOMUtils.printQualifiedAttribute((String)"element", (QName)qName, (Definition)definition, (PrintWriter)printWriter);
                    printWriter.println("/>");
                    map2.put(string2, qName);
                }
                QName qName3 = new QName(string, string2);
                printWriter2.print("      <outfault");
                DOMUtils.printQualifiedAttribute((String)"ref", (QName)qName3, (Definition)definition, (PrintWriter)printWriter2);
                printWriter2.println(" messageLabel=\"Out\"/>");
                map3.put(fault, qName3);
                continue;
            }
            throw new IllegalArgumentException("Encountered a fault message with a number of parts other than 1: " + list2);
        }
    }

    private void convertInput(Input input, PrintWriter printWriter, Definition definition) throws WSDLException {
        Message message;
        if (input != null && (message = input.getMessage()) != null) {
            List list = message.getExtensibilityElements();
            if (list != null && list.size() > 0) {
                throw new IllegalArgumentException("Encountered extensibility elements within a message and cannot determine what to do with them: " + message);
            }
            List list2 = message.getOrderedParts(null);
            int n = list2.size();
            if (n == 1) {
                Part part = (Part)list2.get(0);
                QName qName = part.getElementName();
                String string = "In";
                printWriter.print("      <input messageLabel=\"" + string + "\"");
                DOMUtils.printQualifiedAttribute((String)"element", (QName)qName, (Definition)definition, (PrintWriter)printWriter);
                this.convertExtensionAttrs((AttributeExtensible)input, printWriter, definition);
                printWriter.println("/>");
            } else if (n == 0) {
                printWriter.print("      <input messageLabel=\"In\" element=\"#none\"");
                this.convertExtensionAttrs((AttributeExtensible)input, printWriter, definition);
                printWriter.println("/>");
            } else {
                throw new IllegalArgumentException("Encountered an input message with a number of parts other than 0 or 1: " + list2);
            }
        }
    }

    private void convertOutput(Output output, PrintWriter printWriter, Definition definition) throws WSDLException {
        Message message;
        if (output != null && (message = output.getMessage()) != null) {
            List list = message.getExtensibilityElements();
            if (list != null && list.size() > 0) {
                throw new IllegalArgumentException("Encountered extensibility elements within a message and cannot determine what to do with them: " + message);
            }
            List list2 = message.getOrderedParts(null);
            int n = list2.size();
            if (n == 1) {
                Part part = (Part)list2.get(0);
                QName qName = part.getElementName();
                String string = "Out";
                printWriter.print("      <output messageLabel=\"" + string + "\"");
                DOMUtils.printQualifiedAttribute((String)"element", (QName)qName, (Definition)definition, (PrintWriter)printWriter);
                this.convertExtensionAttrs((AttributeExtensible)output, printWriter, definition);
                printWriter.println("/>");
            } else if (n == 0) {
                printWriter.print("      <output messageLabel=\"Out\" element=\"#none\"");
                this.convertExtensionAttrs((AttributeExtensible)output, printWriter, definition);
                printWriter.println("/>");
            } else {
                throw new IllegalArgumentException("Encountered an output message with a number of parts other than 0 or 1: " + list2);
            }
        }
    }

    private void convertBindings(Map map, PrintWriter printWriter, Definition definition, String string, String string2, Map map2, Map map3) throws WSDLException {
        if (map == null) {
            return;
        }
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Object object;
            BindingOperation bindingOperation;
            Object object2;
            Object object3;
            Object object4;
            Binding binding = (Binding)iterator.next();
            if (binding.isUndefined()) continue;
            QName qName = binding.getQName();
            PortType portType = binding.getPortType();
            if (portType.isUndefined()) continue;
            QName qName2 = null;
            HashSet<ExtensibilityElement> hashSet = new HashSet<ExtensibilityElement>();
            String string3 = null;
            String string4 = "1.1";
            String string5 = null;
            List list = binding.getExtensibilityElements();
            if (list.size() > 0 && (object4 = (ExtensibilityElement)list.get(0)) instanceof SOAPBinding) {
                object3 = (SOAPBinding)object4;
                string3 = NS_URI_WSDL_2_0_SOAP;
                object2 = object3.getTransportURI();
                if (NS_URI_WSDL_1_1_SOAP_HTTP.equals(object2)) {
                    string5 = NS_URI_WSDL_2_0_SOAP_1_1_HTTP;
                }
            }
            printWriter.print("  <binding name=\"" + qName.getLocalPart() + "\"");
            if (portType != null && (qName2 = portType.getQName()) != null) {
                object4 = qName2.getNamespaceURI();
                if (!((String)object4).equals(string2) && ((String)object4).equals(string)) {
                    qName2 = new QName(string2, qName2.getLocalPart());
                }
                printWriter.print("\n          ");
                DOMUtils.printQualifiedAttribute((String)"interface", (QName)qName2, (Definition)definition, (PrintWriter)printWriter);
            }
            if (string3 != null) {
                printWriter.print("\n           type=\"" + string3 + "\"");
            }
            if (string4 != null) {
                printWriter.print("\n          ");
                DOMUtils.printQualifiedAttribute((QName)new QName(NS_URI_WSDL_2_0_SOAP, "version"), (String)string4, (Definition)definition, (PrintWriter)printWriter);
            }
            if (string5 != null) {
                printWriter.print("\n          ");
                DOMUtils.printQualifiedAttribute((QName)new QName(NS_URI_WSDL_2_0_SOAP, "protocol"), (String)string5, (Definition)definition, (PrintWriter)printWriter);
            }
            printWriter.println(">");
            this.convertExtensions(class$javax$wsdl$Binding == null ? Convert.class$("javax.wsdl.Binding") : class$javax$wsdl$Binding, (ElementExtensible)binding, printWriter, definition);
            object4 = binding.getBindingOperations();
            object3 = new StringWriter();
            object2 = new PrintWriter((Writer)object3);
            Iterator iterator2 = object4.iterator();
            while (iterator2.hasNext()) {
                SOAPOperation sOAPOperation;
                Object object5;
                Object object6;
                Object object7;
                Object object8;
                Object object9;
                bindingOperation = (BindingOperation)iterator2.next();
                object = bindingOperation.getOperation();
                Map map4 = bindingOperation.getBindingFaults();
                if (map4 != null) {
                    object9 = map4.values().iterator();
                    while (object9.hasNext()) {
                        object8 = (BindingFault)object9.next();
                        object7 = object8.getName();
                        if (object7 == null && (object6 = object8.getExtensibilityElements()) != null) {
                            object5 = object6.iterator();
                            while (object5.hasNext()) {
                                sOAPOperation = (ExtensibilityElement)object5.next();
                                if (!(sOAPOperation instanceof SOAPFault)) continue;
                                SOAPFault sOAPFault = (SOAPFault)sOAPOperation;
                                object7 = sOAPFault.getName();
                            }
                        }
                        if (object7 == null) {
                            throw new IllegalArgumentException("WSDL v1.1 requires a name to be specified for every wsdl:fault and soap:fault element.");
                        }
                        object6 = object.getFault((String)object7);
                        if (object6 == null) {
                            throw new IllegalArgumentException("Unable to resolve referenced fault '" + (String)object7 + "'.");
                        }
                        object5 = (QName)map3.get(object6);
                        if (object5 == null) {
                            throw new IllegalArgumentException("Unable to resolve referenced fault '" + (String)object7 + "'.");
                        }
                        hashSet.add((ExtensibilityElement)object5);
                    }
                }
                if ((object9 = (QName)map2.get(object)) == null) {
                    throw new IllegalArgumentException("Unable to resolve referenced operation '" + object.getName() + "'.");
                }
                object8 = null;
                object7 = bindingOperation.getExtensibilityElements();
                if (object7 != null) {
                    object6 = object7.iterator();
                    while (object6.hasNext()) {
                        object5 = (ExtensibilityElement)object6.next();
                        if (!(object5 instanceof SOAPOperation)) continue;
                        sOAPOperation = (SOAPOperation)object5;
                        object8 = sOAPOperation.getSoapActionURI();
                    }
                }
                ((PrintWriter)object2).print("    <operation");
                DOMUtils.printQualifiedAttribute((String)"ref", (QName)object9, (Definition)definition, (PrintWriter)object2);
                if (object8 != null) {
                    DOMUtils.printQualifiedAttribute((QName)new QName(NS_URI_WSDL_2_0_SOAP, "action"), (String)object8, (Definition)definition, (PrintWriter)object2);
                }
                ((PrintWriter)object2).println(">");
                this.convertExtensions(class$javax$wsdl$BindingOperation == null ? Convert.class$("javax.wsdl.BindingOperation") : class$javax$wsdl$BindingOperation, (ElementExtensible)bindingOperation, (PrintWriter)object2, definition);
                ((PrintWriter)object2).println("    </operation>");
            }
            bindingOperation = hashSet.iterator();
            while (bindingOperation.hasNext()) {
                object = (QName)bindingOperation.next();
                printWriter.print("    <fault");
                DOMUtils.printQualifiedAttribute((String)"ref", (QName)object, (Definition)definition, (PrintWriter)printWriter);
                printWriter.println("/>");
            }
            ((PrintWriter)object2).flush();
            printWriter.print(((StringWriter)object3).toString());
            printWriter.println("  </binding>");
        }
    }

    private void convertServices(Map map, PrintWriter printWriter, Definition definition, String string, String string2) throws WSDLException {
        if (map == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            PortType portType;
            String string3;
            Service service = (Service)iterator.next();
            QName qName = service.getQName();
            String string4 = null;
            if (qName != null) {
                string4 = qName.getLocalPart();
            }
            if (string4 == null || string4.equals("")) {
                throw new IllegalArgumentException("WSDL v1.1 requires a name to be specified for every service element.");
            }
            Map map2 = service.getPorts();
            if (map2 == null || map2.size() == 0) {
                return;
            }
            HashMap<PortType, Vector<String>> hashMap = new HashMap<PortType, Vector<String>>();
            Iterator iterator2 = map2.values().iterator();
            while (iterator2.hasNext()) {
                string3 = (Port)iterator2.next();
                portType = this.getServicePortType((Port)string3);
                if (portType.isUndefined()) continue;
                Vector<String> vector = (Vector<String>)hashMap.get(portType);
                if (vector == null) {
                    vector = new Vector<String>();
                    hashMap.put(portType, vector);
                }
                vector.add(string3);
            }
            string3 = string4;
            portType = hashMap.keySet().iterator();
            int n = 0;
            while (portType.hasNext()) {
                if (n > 0 || hashSet.contains(string3)) {
                    string3 = string4 + "_" + n++;
                    while (hashSet.contains(string3)) {
                        string3 = string4 + "_" + n++;
                    }
                }
                hashSet.add(string3);
                PortType portType2 = (PortType)portType.next();
                QName qName2 = this.getServiceInterfaceType(string4, portType2, string, string2);
                List list = (List)hashMap.get(portType2);
                printWriter.println("  <service name=\"" + string3 + "\"");
                printWriter.print("          ");
                DOMUtils.printQualifiedAttribute((String)"interface", (QName)qName2, (Definition)definition, (PrintWriter)printWriter);
                printWriter.println(">");
                this.convertExtensions(class$javax$wsdl$Service == null ? Convert.class$("javax.wsdl.Service") : class$javax$wsdl$Service, (ElementExtensible)service, printWriter, definition);
                this.convertPorts(list, printWriter, definition, string, string2);
                printWriter.println("  </service>");
                if (n != 0) continue;
                ++n;
            }
        }
    }

    private PortType getServicePortType(Port port) {
        Binding binding = port.getBinding();
        PortType portType = null;
        if (binding != null) {
            portType = binding.getPortType();
        }
        return portType;
    }

    private QName getServiceInterfaceType(String string, PortType portType, String string2, String string3) {
        QName qName = null;
        if (portType != null) {
            qName = portType.getQName();
        }
        if (qName == null) {
            throw new IllegalArgumentException("Unable to determine the portType referenced by service '" + string + "'.");
        }
        String string4 = qName.getNamespaceURI();
        if (!string4.equals(string3) && string4.equals(string2)) {
            qName = new QName(string3, qName.getLocalPart());
        }
        return qName;
    }

    private void convertPorts(List list, PrintWriter printWriter, Definition definition, String string, String string2) throws WSDLException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ExtensibilityElement extensibilityElement;
            Port port = (Port)iterator.next();
            String string3 = port.getName();
            Binding binding = port.getBinding();
            QName qName = null;
            if (binding != null) {
                qName = binding.getQName();
            }
            if (qName == null) {
                throw new IllegalArgumentException("Unable to determine the type of the binding referenced by port '" + port.getName() + "'.");
            }
            String string4 = qName.getNamespaceURI();
            if (!string4.equals(string2) && string4.equals(string)) {
                qName = new QName(string2, qName.getLocalPart());
            }
            string4 = null;
            List list2 = port.getExtensibilityElements();
            if (list2.size() > 0 && (extensibilityElement = (ExtensibilityElement)list2.get(0)) instanceof SOAPAddress) {
                SOAPAddress sOAPAddress = (SOAPAddress)extensibilityElement;
                string4 = sOAPAddress.getLocationURI();
            }
            printWriter.println("    <endpoint name=\"" + string3 + "\"");
            printWriter.print("             ");
            DOMUtils.printQualifiedAttribute((String)"binding", (QName)qName, (Definition)definition, (PrintWriter)printWriter);
            if (string4 != null) {
                printWriter.print("\n              address=\"" + string4 + "\"");
            }
            printWriter.println(">");
            this.convertExtensions(class$javax$wsdl$Port == null ? Convert.class$("javax.wsdl.Port") : class$javax$wsdl$Port, (ElementExtensible)port, printWriter, definition);
            printWriter.println("    </endpoint>");
        }
    }

    private static void printUsage(String string) {
        System.err.println("Error: " + string + "\n\n" + "Usage:\n\n" + "  java " + (class$org$apache$woden$tool$converter$Convert == null ? (class$org$apache$woden$tool$converter$Convert = Convert.class$("org.apache.woden.tool.converter.Convert")) : class$org$apache$woden$tool$converter$Convert).getName() + " [args]\n\n" + "    args:\n\n" + "      -wsdl         file-or-URL-of-wsdl1.1-document\n" + "      [-targetNS    new-target-namespace]\n" + "      [-dir        targetDir]   default: .\n" + "      [-verbose     (on|off)]   default: on\n" + "      [-overwrite   (on|off)]   default: off" + "   (Overwrite existing files?)");
        System.exit(1);
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        if (stringArray.length % 2 != 0) {
            Convert.printUsage("Incorrect number of arguments.");
        }
        String string = null;
        String string2 = null;
        String string3 = ".";
        boolean bl = true;
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; i += 2) {
            String string4 = stringArray[i];
            String string5 = stringArray[i + 1];
            if (string4.equals("-wsdl")) {
                string = string5;
                continue;
            }
            if (string4.equals("-targetNS")) {
                string2 = string5;
                continue;
            }
            if (string4.equals("-dir")) {
                string3 = string5;
                continue;
            }
            if (string4.equals("-verbose")) {
                bl = string5.equals("on");
                continue;
            }
            if (string4.equals("-overwrite")) {
                bl2 = string5.equals("on");
                continue;
            }
            Convert.printUsage("Unrecognized argument '" + string4 + "'.");
        }
        if (string != null) {
            Convert convert = new Convert();
            convert.convertFile(string2, string, string3, bl, bl2);
        } else {
            Convert.printUsage("No WSDL 1.1 document was specified (use the '-wsdl' argument.)");
        }
        long l2 = System.currentTimeMillis();
        if (bl) {
            System.out.println("Done.\nElapsed time: " + (l2 - l) + "ms");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        patternMappings.put(OperationType.ONE_WAY, NS_URI_WSDL_2_0 + "/in-only");
        patternMappings.put(OperationType.REQUEST_RESPONSE, NS_URI_WSDL_2_0 + "/in-out");
        patternMappings.put(OperationType.SOLICIT_RESPONSE, NS_URI_WSDL_2_0 + "/out-in");
        patternMappings.put(OperationType.NOTIFICATION, NS_URI_WSDL_2_0 + "/out-only");
        patternMappings.put(null, NS_URI_WSDL_2_0 + "/in-out");
        COPY = "copy";
        IGNORE = "ignore";
        baseExtToBehaviorMap = new HashMap();
        baseExtToBehaviorMap.put((class$javax$wsdl$Binding == null ? (class$javax$wsdl$Binding = Convert.class$("javax.wsdl.Binding")) : class$javax$wsdl$Binding).getName() + new QName(NS_URI_WSDL_1_1_SOAP, "binding"), IGNORE);
        baseExtToBehaviorMap.put((class$javax$wsdl$BindingOperation == null ? (class$javax$wsdl$BindingOperation = Convert.class$("javax.wsdl.BindingOperation")) : class$javax$wsdl$BindingOperation).getName() + new QName(NS_URI_WSDL_1_1_SOAP, "operation"), IGNORE);
        baseExtToBehaviorMap.put((class$javax$wsdl$Port == null ? (class$javax$wsdl$Port = Convert.class$("javax.wsdl.Port")) : class$javax$wsdl$Port).getName() + new QName(NS_URI_WSDL_1_1_SOAP, "address"), IGNORE);
        baseExtToBehaviorMap.put((class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = Convert.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition).getName() + new QName(NS_URI_WSP, "UsingPolicy"), COPY);
        baseExtToBehaviorMap.put((class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = Convert.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition).getName() + new QName(NS_URI_WSP, "Policy"), COPY);
        baseExtToBehaviorMap.put((class$javax$wsdl$Operation == null ? (class$javax$wsdl$Operation = Convert.class$("javax.wsdl.Operation")) : class$javax$wsdl$Operation).getName() + new QName(NS_URI_WSP, "PolicyReference"), COPY);
        baseExtToBehaviorMap.put((class$javax$wsdl$Binding == null ? (class$javax$wsdl$Binding = Convert.class$("javax.wsdl.Binding")) : class$javax$wsdl$Binding).getName() + new QName(NS_URI_WSP, "PolicyReference"), COPY);
        baseExtToBehaviorMap.put((class$javax$wsdl$BindingOperation == null ? (class$javax$wsdl$BindingOperation = Convert.class$("javax.wsdl.BindingOperation")) : class$javax$wsdl$BindingOperation).getName() + new QName(NS_URI_WSP, "PolicyReference"), COPY);
        baseExtToBehaviorMap.put((class$javax$wsdl$Service == null ? (class$javax$wsdl$Service = Convert.class$("javax.wsdl.Service")) : class$javax$wsdl$Service).getName() + new QName(NS_URI_WSP, "PolicyReference"), COPY);
        baseExtToBehaviorMap.put((class$javax$wsdl$Port == null ? (class$javax$wsdl$Port = Convert.class$("javax.wsdl.Port")) : class$javax$wsdl$Port).getName() + new QName(NS_URI_WSP, "PolicyReference"), COPY);
    }
}

