/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.store.redis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.servicemix.store.Entry;
import org.apache.servicemix.store.base.BaseStore;
import org.idevlab.rjc.RedisNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class RedisStore
extends BaseStore {
    private static final Logger LOG = LoggerFactory.getLogger(RedisStore.class);
    private RedisNode redisNode;
    private String storeName;
    private String idgenName;
    private Long timeout = 0L;
    private BASE64Encoder encoder = new BASE64Encoder();
    private BASE64Decoder decoder = new BASE64Decoder();

    public RedisStore(RedisNode redisNode, String storeName) {
        this.redisNode = redisNode;
        this.storeName = storeName;
        this.idgenName = storeName + ".idgen";
    }

    public RedisStore(RedisNode redisNode, String storeName, Long timeout) {
        this.redisNode = redisNode;
        this.storeName = storeName;
        this.idgenName = storeName + ".idgen";
        this.timeout = timeout;
    }

    public boolean hasFeature(String feature) {
        return "Clustered".equals(feature) || "Persistent".equals(feature);
    }

    public void store(String id, Object data) throws IOException {
        LOG.debug("Storing object with id: " + id);
        ObjectOutputStream out = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            out = new ObjectOutputStream(buffer);
            out.writeObject(new Entry(data));
            out.close();
            this.redisNode.set(id, this.encoder.encode(buffer.toByteArray()));
            this.fireAddedEvent(id, data);
        }
        catch (Exception e) {
            throw (IOException)new IOException("Error storing object").initCause(e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public String store(Object data) throws IOException {
        Long id = this.redisNode.incr(this.idgenName);
        this.store(String.valueOf(id), data);
        return null;
    }

    public Object load(String id) throws IOException {
        LOG.debug("Loading/Removing object with id: " + id);
        Entry result = this.removeEntry(id);
        if (result != null) {
            this.fireRemovedEvent(id, result.getData());
        }
        return result;
    }

    public Object evict(String id) throws IOException {
        LOG.debug("Evicting object with id: " + id);
        Entry result = this.removeEntry(id);
        if (result != null) {
            this.fireEvictedEvent(id, result.getData());
        }
        return result;
    }

    public Object peek(String id) throws IOException {
        LOG.debug("Peeking object with id: " + id);
        Object result = null;
        try {
            result = this.parseEntry(this.redisNode.get(id)).getData();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not load object from store", e);
        }
        return result;
    }

    private Entry removeEntry(String id) throws IOException {
        Entry result = null;
        if (this.timeout > 0L) {
            this.evict();
        }
        try {
            result = this.parseEntry(this.redisNode.get(id));
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not load object from store", e);
        }
        this.redisNode.del(new String[]{id});
        return result;
    }

    private Entry parseEntry(String string) throws IOException, ClassNotFoundException {
        ByteArrayInputStream buffer = new ByteArrayInputStream(this.decoder.decodeBuffer(string));
        ObjectInputStream out = new ObjectInputStream(buffer);
        return (Entry)out.readObject();
    }

    private void evict() throws IOException {
        long now = System.currentTimeMillis();
        for (String key : this.redisNode.keys("*")) {
            long age = 0L;
            try {
                age = now - this.parseEntry(this.redisNode.get(key)).getTime();
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Could not load object from store", e);
            }
            if (age <= this.timeout) continue;
            LOG.debug("Removing object with id " + key + " from store after " + age + " ms");
            this.evict(key);
        }
    }
}

