/*
 * Decompiled with CFR 0.152.
 */
package org.idevlab.rjc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.idevlab.rjc.DebugParams;
import org.idevlab.rjc.RedisCommands;
import org.idevlab.rjc.SortingParams;
import org.idevlab.rjc.ZParams;
import org.idevlab.rjc.ds.RedisConnection;
import org.idevlab.rjc.protocol.Protocol;
import org.idevlab.rjc.util.SafeEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client
implements RedisCommands {
    private final RedisConnection conn;
    private boolean isInMulti;

    public Client(RedisConnection conn) {
        this.conn = conn;
    }

    public void close() {
        this.conn.close();
    }

    public boolean isInMulti() {
        return this.isInMulti;
    }

    public void ping() {
        this.conn.sendCommand(Protocol.Command.PING);
    }

    @Override
    public void set(String key, String value) {
        this.conn.sendCommand(Protocol.Command.SET, key, value);
    }

    @Override
    public void get(String key) {
        this.conn.sendCommand(Protocol.Command.GET, new byte[][]{SafeEncoder.encode(key)});
    }

    public void quit() {
        this.conn.sendCommand(Protocol.Command.QUIT);
    }

    @Override
    public void exists(String key) {
        this.conn.sendCommand(Protocol.Command.EXISTS, new byte[][]{SafeEncoder.encode(key)});
    }

    @Override
    public void del(String ... keys) {
        this.conn.sendCommand(Protocol.Command.DEL, keys);
    }

    @Override
    public void type(String key) {
        this.conn.sendCommand(Protocol.Command.TYPE, new byte[][]{SafeEncoder.encode(key)});
    }

    public void flushDB() {
        this.conn.sendCommand(Protocol.Command.FLUSHDB);
    }

    @Override
    public void keys(String pattern) {
        this.conn.sendCommand(Protocol.Command.KEYS, pattern);
    }

    public void randomKey() {
        this.conn.sendCommand(Protocol.Command.RANDOMKEY);
    }

    @Override
    public void rename(String oldkey, String newkey) {
        this.conn.sendCommand(Protocol.Command.RENAME, oldkey, newkey);
    }

    @Override
    public void renamenx(String oldkey, String newkey) {
        this.conn.sendCommand(Protocol.Command.RENAMENX, oldkey, newkey);
    }

    public void dbSize() {
        this.conn.sendCommand(Protocol.Command.DBSIZE);
    }

    @Override
    public void expire(String key, int seconds) {
        this.conn.sendCommand(Protocol.Command.EXPIRE, SafeEncoder.encode(key), Protocol.toByteArray(seconds));
    }

    @Override
    public void expireAt(String key, long unixTime) {
        this.conn.sendCommand(Protocol.Command.EXPIREAT, SafeEncoder.encode(key), Protocol.toByteArray(unixTime));
    }

    @Override
    public void ttl(String key) {
        this.conn.sendCommand(Protocol.Command.TTL, new byte[][]{SafeEncoder.encode(key)});
    }

    @Override
    public void select(int index) {
        this.conn.sendCommand(Protocol.Command.SELECT, new byte[][]{Protocol.toByteArray(index)});
    }

    @Override
    public void move(String key, int dbIndex) {
        this.conn.sendCommand(Protocol.Command.MOVE, SafeEncoder.encode(key), Protocol.toByteArray(dbIndex));
    }

    public void flushAll() {
        this.conn.sendCommand(Protocol.Command.FLUSHALL);
    }

    @Override
    public void getSet(String key, String value) {
        this.conn.sendCommand(Protocol.Command.GETSET, key, value);
    }

    @Override
    public void mget(String ... keys) {
        this.conn.sendCommand(Protocol.Command.MGET, keys);
    }

    @Override
    public void setnx(String key, String value) {
        this.conn.sendCommand(Protocol.Command.SETNX, key, value);
    }

    @Override
    public void setex(String key, int seconds, String value) {
        this.conn.sendCommand(Protocol.Command.SETEX, key, String.valueOf(seconds), value);
    }

    @Override
    public void mset(String ... keysvalues) {
        this.conn.sendCommand(Protocol.Command.MSET, keysvalues);
    }

    @Override
    public void msetnx(String ... keysvalues) {
        this.conn.sendCommand(Protocol.Command.MSETNX, keysvalues);
    }

    @Override
    public void decrBy(String key, int integer) {
        this.conn.sendCommand(Protocol.Command.DECRBY, key, String.valueOf(integer));
    }

    @Override
    public void decr(String key) {
        this.conn.sendCommand(Protocol.Command.DECR, key);
    }

    @Override
    public void incrBy(String key, int integer) {
        this.conn.sendCommand(Protocol.Command.INCRBY, key, String.valueOf(integer));
    }

    @Override
    public void incr(String key) {
        this.conn.sendCommand(Protocol.Command.INCR, key);
    }

    @Override
    public void append(String key, String value) {
        this.conn.sendCommand(Protocol.Command.APPEND, key, value);
    }

    @Override
    public void getRange(String key, int start, int end) {
        this.conn.sendCommand(Protocol.Command.GETRANGE, key, String.valueOf(start), String.valueOf(end));
    }

    @Override
    public void setRange(String key, int offset, String value) {
        this.conn.sendCommand(Protocol.Command.SETRANGE, key, String.valueOf(offset), value);
    }

    @Override
    public void hset(String key, String field, String value) {
        this.conn.sendCommand(Protocol.Command.HSET, key, field, value);
    }

    @Override
    public void hget(String key, String field) {
        this.conn.sendCommand(Protocol.Command.HGET, key, field);
    }

    @Override
    public void hsetnx(String key, String field, String value) {
        this.conn.sendCommand(Protocol.Command.HSETNX, key, field, value);
    }

    @Override
    public void hmset(String key, Map<String, String> hash) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(key);
        for (String field : hash.keySet()) {
            params.add(field);
            params.add(hash.get(field));
        }
        String[] args = params.toArray(new String[params.size()]);
        this.conn.sendCommand(Protocol.Command.HMSET, args);
    }

    @Override
    public void hmget(String key, String ... fields) {
        String[] params = new String[fields.length + 1];
        params[0] = key;
        System.arraycopy(fields, 0, params, 1, fields.length);
        this.conn.sendCommand(Protocol.Command.HMGET, params);
    }

    @Override
    public void hincrBy(String key, String field, int value) {
        this.conn.sendCommand(Protocol.Command.HINCRBY, key, field, String.valueOf(value));
    }

    @Override
    public void hexists(String key, String field) {
        this.conn.sendCommand(Protocol.Command.HEXISTS, key, field);
    }

    @Override
    public void hdel(String key, String field) {
        this.conn.sendCommand(Protocol.Command.HDEL, key, field);
    }

    @Override
    public void hlen(String key) {
        this.conn.sendCommand(Protocol.Command.HLEN, key);
    }

    @Override
    public void hkeys(String key) {
        this.conn.sendCommand(Protocol.Command.HKEYS, key);
    }

    @Override
    public void hvals(String key) {
        this.conn.sendCommand(Protocol.Command.HVALS, key);
    }

    @Override
    public void hgetAll(String key) {
        this.conn.sendCommand(Protocol.Command.HGETALL, key);
    }

    @Override
    public void rpush(String key, String string) {
        this.conn.sendCommand(Protocol.Command.RPUSH, key, string);
    }

    @Override
    public void lpush(String key, String string) {
        this.conn.sendCommand(Protocol.Command.LPUSH, key, string);
    }

    @Override
    public void llen(String key) {
        this.conn.sendCommand(Protocol.Command.LLEN, key);
    }

    @Override
    public void lrange(String key, int start, int end) {
        this.conn.sendCommand(Protocol.Command.LRANGE, key, String.valueOf(start), String.valueOf(end));
    }

    @Override
    public void ltrim(String key, int start, int end) {
        this.conn.sendCommand(Protocol.Command.LTRIM, key, String.valueOf(start), String.valueOf(end));
    }

    @Override
    public void lindex(String key, int index) {
        this.conn.sendCommand(Protocol.Command.LINDEX, key, String.valueOf(index));
    }

    @Override
    public void lset(String key, int index, String value) {
        this.conn.sendCommand(Protocol.Command.LSET, key, String.valueOf(index), value);
    }

    @Override
    public void lrem(String key, int count, String value) {
        this.conn.sendCommand(Protocol.Command.LREM, key, String.valueOf(count), value);
    }

    @Override
    public void lpop(String key) {
        this.conn.sendCommand(Protocol.Command.LPOP, key);
    }

    @Override
    public void rpop(String key) {
        this.conn.sendCommand(Protocol.Command.RPOP, key);
    }

    @Override
    public void rpoplpush(String srckey, String dstkey) {
        this.conn.sendCommand(Protocol.Command.RPOPLPUSH, srckey, dstkey);
    }

    @Override
    public void sadd(String key, String member) {
        this.conn.sendCommand(Protocol.Command.SADD, key, member);
    }

    @Override
    public void smembers(String key) {
        this.conn.sendCommand(Protocol.Command.SMEMBERS, key);
    }

    @Override
    public void srem(String key, String member) {
        this.conn.sendCommand(Protocol.Command.SREM, key, member);
    }

    @Override
    public void spop(String key) {
        this.conn.sendCommand(Protocol.Command.SPOP, key);
    }

    @Override
    public void smove(String srckey, String dstkey, String member) {
        this.conn.sendCommand(Protocol.Command.SMOVE, srckey, dstkey, member);
    }

    @Override
    public void scard(String key) {
        this.conn.sendCommand(Protocol.Command.SCARD, key);
    }

    @Override
    public void sismember(String key, String member) {
        this.conn.sendCommand(Protocol.Command.SISMEMBER, key, member);
    }

    @Override
    public void sinter(String ... keys) {
        this.conn.sendCommand(Protocol.Command.SINTER, keys);
    }

    @Override
    public void sinterstore(String dstkey, String ... keys) {
        this.conn.sendCommand(Protocol.Command.SINTERSTORE, Client.joinParams(dstkey, keys));
    }

    private static String[] joinParams(String dstkey, String[] keys) {
        String[] params = new String[keys.length + 1];
        params[0] = dstkey;
        System.arraycopy(keys, 0, params, 1, keys.length);
        return params;
    }

    @Override
    public void sunion(String ... keys) {
        this.conn.sendCommand(Protocol.Command.SUNION, keys);
    }

    @Override
    public void sunionstore(String dstkey, String ... keys) {
        this.conn.sendCommand(Protocol.Command.SUNIONSTORE, Client.joinParams(dstkey, keys));
    }

    @Override
    public void sdiff(String ... keys) {
        this.conn.sendCommand(Protocol.Command.SDIFF, keys);
    }

    @Override
    public void sdiffstore(String dstkey, String ... keys) {
        this.conn.sendCommand(Protocol.Command.SDIFFSTORE, Client.joinParams(dstkey, keys));
    }

    @Override
    public void srandmember(String key) {
        this.conn.sendCommand(Protocol.Command.SRANDMEMBER, key);
    }

    @Override
    public void zadd(String key, Number score, String member) {
        this.conn.sendCommand(Protocol.Command.ZADD, key, String.valueOf(score), member);
    }

    @Override
    public void zrange(String key, int start, int end) {
        this.conn.sendCommand(Protocol.Command.ZRANGE, key, String.valueOf(start), String.valueOf(end));
    }

    @Override
    public void zrem(String key, String member) {
        this.conn.sendCommand(Protocol.Command.ZREM, key, member);
    }

    @Override
    public void zincrby(String key, Number score, String member) {
        this.conn.sendCommand(Protocol.Command.ZINCRBY, key, String.valueOf(score), member);
    }

    @Override
    public void zrank(String key, String member) {
        this.conn.sendCommand(Protocol.Command.ZRANK, key, member);
    }

    @Override
    public void zrevrank(String key, String member) {
        this.conn.sendCommand(Protocol.Command.ZREVRANK, key, member);
    }

    @Override
    public void zrevrange(String key, int start, int end) {
        this.conn.sendCommand(Protocol.Command.ZREVRANGE, key, String.valueOf(start), String.valueOf(end));
    }

    @Override
    public void zrangeWithScores(String key, int start, int end) {
        this.conn.sendCommand(Protocol.Command.ZRANGE, key, String.valueOf(start), String.valueOf(end), Protocol.Keyword.WITHSCORES.str);
    }

    @Override
    public void zrevrangeWithScores(String key, int start, int end) {
        this.conn.sendCommand(Protocol.Command.ZREVRANGE, key, String.valueOf(start), String.valueOf(end), Protocol.Keyword.WITHSCORES.str);
    }

    @Override
    public void zrevrangeByScore(String key, String max, String min) {
        this.conn.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, max, min);
    }

    @Override
    public void zrevrangeByScore(String key, String max, String min, int offset, int count) {
        this.conn.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, max, min, Protocol.Keyword.LIMIT.str, String.valueOf(offset), String.valueOf(count));
    }

    @Override
    public void zrevrangeByScoreWithScores(String key, String max, String min) {
        this.conn.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, max, min, Protocol.Keyword.WITHSCORES.str);
    }

    @Override
    public void zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        this.conn.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, max, min, Protocol.Keyword.LIMIT.str, String.valueOf(offset), String.valueOf(count), Protocol.Keyword.WITHSCORES.str);
    }

    @Override
    public void zcard(String key) {
        this.conn.sendCommand(Protocol.Command.ZCARD, key);
    }

    @Override
    public void zscore(String key, String member) {
        this.conn.sendCommand(Protocol.Command.ZSCORE, key, member);
    }

    @Override
    public void multi() {
        this.conn.sendCommand(Protocol.Command.MULTI);
        this.isInMulti = true;
    }

    @Override
    public void discard() {
        this.conn.sendCommand(Protocol.Command.DISCARD);
        this.isInMulti = false;
    }

    @Override
    public void exec() {
        this.conn.sendCommand(Protocol.Command.EXEC);
        this.isInMulti = false;
    }

    @Override
    public void watch(String ... keys) {
        this.conn.sendCommand(Protocol.Command.WATCH, keys);
    }

    @Override
    public void unwatch() {
        this.conn.sendCommand(Protocol.Command.UNWATCH);
    }

    @Override
    public void sort(String key) {
        this.conn.sendCommand(Protocol.Command.SORT, key);
    }

    @Override
    public void sort(String key, SortingParams sortingParameters) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(key);
        args.addAll(sortingParameters.getParams());
        String[] args1 = args.toArray(new String[args.size()]);
        this.conn.sendCommand(Protocol.Command.SORT, args1);
    }

    @Override
    public void blpop(String ... args) {
        this.conn.sendCommand(Protocol.Command.BLPOP, args);
    }

    @Override
    public void sort(String key, SortingParams sortingParameters, String dstkey) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(key);
        args.addAll(sortingParameters.getParams());
        args.add(Protocol.Keyword.STORE.str);
        args.add(dstkey);
        String[] args1 = args.toArray(new String[args.size()]);
        this.conn.sendCommand(Protocol.Command.SORT, args1);
    }

    @Override
    public void sort(String key, String dstkey) {
        this.conn.sendCommand(Protocol.Command.SORT, key, Protocol.Keyword.STORE.str, dstkey);
    }

    @Override
    public void brpop(String ... keys) {
        this.conn.sendCommand(Protocol.Command.BRPOP, keys);
    }

    public void auth(String password) {
        this.conn.sendCommand(Protocol.Command.AUTH, password);
    }

    public void subscribe(String ... channels) {
        this.conn.sendCommand(Protocol.Command.SUBSCRIBE, channels);
    }

    public void publish(String channel, String message) {
        this.conn.sendCommand(Protocol.Command.PUBLISH, channel, message);
    }

    public void unsubscribe() {
        this.conn.sendCommand(Protocol.Command.UNSUBSCRIBE);
    }

    public void unsubscribe(String ... channels) {
        this.conn.sendCommand(Protocol.Command.UNSUBSCRIBE, channels);
    }

    public void psubscribe(String ... pattern) {
        this.conn.sendCommand(Protocol.Command.PSUBSCRIBE, pattern);
    }

    public void punsubscribe() {
        this.conn.sendCommand(Protocol.Command.PUNSUBSCRIBE);
    }

    public void punsubscribe(String ... patterns) {
        this.conn.sendCommand(Protocol.Command.PUNSUBSCRIBE, patterns);
    }

    @Override
    public void zcount(String key, Number min, Number max) {
        this.conn.sendCommand(Protocol.Command.ZCOUNT, key, String.valueOf(min), String.valueOf(max));
    }

    @Override
    public void zrangeByScore(String key, String min, String max) {
        this.conn.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, min, max);
    }

    @Override
    public void zrangeByScore(String key, String min, String max, int offset, int count) {
        this.conn.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, min, max, Protocol.Keyword.LIMIT.str, String.valueOf(offset), String.valueOf(count));
    }

    @Override
    public void zrangeByScoreWithScores(String key, String min, String max) {
        this.conn.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, min, max, Protocol.Keyword.WITHSCORES.str);
    }

    @Override
    public void zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        this.conn.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, min, max, Protocol.Keyword.LIMIT.str, String.valueOf(offset), String.valueOf(count), Protocol.Keyword.WITHSCORES.str);
    }

    @Override
    public void zremrangeByRank(String key, int start, int end) {
        this.conn.sendCommand(Protocol.Command.ZREMRANGEBYRANK, key, String.valueOf(start), String.valueOf(end));
    }

    @Override
    public void zremrangeByScore(String key, String start, String end) {
        this.conn.sendCommand(Protocol.Command.ZREMRANGEBYSCORE, key, start, end);
    }

    @Override
    public void zunionstore(String dstkey, String ... sets) {
        String[] params = new String[sets.length + 2];
        params[0] = dstkey;
        params[1] = String.valueOf(sets.length);
        System.arraycopy(sets, 0, params, 2, sets.length);
        this.conn.sendCommand(Protocol.Command.ZUNIONSTORE, params);
    }

    @Override
    public void zunionstore(String dstkey, ZParams params, String ... sets) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(dstkey);
        args.add(String.valueOf(sets.length));
        args.addAll(Arrays.asList(sets));
        args.addAll(params.getParams());
        String[] args1 = args.toArray(new String[args.size()]);
        this.conn.sendCommand(Protocol.Command.ZUNIONSTORE, args1);
    }

    @Override
    public void zinterstore(String dstkey, String ... sets) {
        String[] params = new String[sets.length + 2];
        params[0] = dstkey;
        params[1] = String.valueOf(sets.length);
        System.arraycopy(sets, 0, params, 2, sets.length);
        this.conn.sendCommand(Protocol.Command.ZINTERSTORE, params);
    }

    @Override
    public void zinterstore(String dstkey, ZParams params, String ... sets) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(dstkey);
        args.add(String.valueOf(sets.length));
        args.addAll(Arrays.asList(sets));
        args.addAll(params.getParams());
        String[] args1 = args.toArray(new String[args.size()]);
        this.conn.sendCommand(Protocol.Command.ZINTERSTORE, args1);
    }

    public void save() {
        this.conn.sendCommand(Protocol.Command.SAVE);
    }

    public void bgsave() {
        this.conn.sendCommand(Protocol.Command.BGSAVE);
    }

    public void bgrewriteaof() {
        this.conn.sendCommand(Protocol.Command.BGREWRITEAOF);
    }

    public void lastsave() {
        this.conn.sendCommand(Protocol.Command.LASTSAVE);
    }

    public void shutdown() {
        this.conn.sendCommand(Protocol.Command.SHUTDOWN);
    }

    public void info() {
        this.conn.sendCommand(Protocol.Command.INFO);
    }

    public void monitor() {
        this.conn.sendCommand(Protocol.Command.MONITOR);
    }

    public void slaveof(String host, int port) {
        this.conn.sendCommand(Protocol.Command.SLAVEOF, host, String.valueOf(port));
    }

    public void slaveofNoOne() {
        this.conn.sendCommand(Protocol.Command.SLAVEOF, Protocol.Keyword.NO.str, Protocol.Keyword.ONE.str);
    }

    public void configGet(String pattern) {
        this.conn.sendCommand(Protocol.Command.CONFIG, Protocol.Keyword.GET.name(), pattern);
    }

    public void configSet(String parameter, String value) {
        this.conn.sendCommand(Protocol.Command.CONFIG, Protocol.Keyword.SET.name(), parameter, value);
    }

    @Override
    public void strlen(String key) {
        this.conn.sendCommand(Protocol.Command.STRLEN, key);
    }

    public void sync() {
        this.conn.sendCommand(Protocol.Command.SYNC);
    }

    @Override
    public void lpushx(String key, String string) {
        this.conn.sendCommand(Protocol.Command.LPUSHX, key, string);
    }

    @Override
    public void persist(String key) {
        this.conn.sendCommand(Protocol.Command.PERSIST, key);
    }

    @Override
    public void rpushx(String key, String string) {
        this.conn.sendCommand(Protocol.Command.RPUSHX, key, string);
    }

    public void echo(String string) {
        this.conn.sendCommand(Protocol.Command.ECHO, string);
    }

    public void linsert(String key, LIST_POSITION where, String pivot, String value) {
        this.conn.sendCommand(Protocol.Command.LINSERT, key, where.name(), pivot, value);
    }

    @Override
    public void debug(DebugParams params) {
        this.conn.sendCommand(Protocol.Command.DEBUG, params.getCommand());
    }

    @Override
    public void configResetStat() {
        this.conn.sendCommand(Protocol.Command.CONFIG, Protocol.Keyword.RESETSTAT.name());
    }

    @Override
    public void brpoplpush(String source, String destination, int timeout) {
        this.conn.sendCommand(Protocol.Command.BRPOPLPUSH, source, destination, String.valueOf(timeout));
    }

    @Override
    public void setbit(String key, int offset, String value) {
        this.conn.sendCommand(Protocol.Command.SETBIT, key, String.valueOf(offset), value);
    }

    @Override
    public void getbit(String key, int offset) {
        this.conn.sendCommand(Protocol.Command.GETBIT, key, String.valueOf(offset));
    }

    public String getStatusCodeReply() {
        return this.conn.getStatusCodeReply();
    }

    public String getBulkReply() {
        if (this.isInMulti()) {
            this.conn.getStatusCodeReply();
            return null;
        }
        return this.conn.getBulkReply();
    }

    public Long getIntegerReply() {
        if (this.isInMulti()) {
            this.conn.getStatusCodeReply();
            return null;
        }
        return this.conn.getIntegerReply();
    }

    public List<String> getMultiBulkReply() {
        if (this.isInMulti()) {
            this.conn.getStatusCodeReply();
            return Collections.emptyList();
        }
        return this.conn.getMultiBulkReply();
    }

    public List<Object> getObjectMultiBulkReply() {
        if (this.isInMulti()) {
            this.conn.getStatusCodeReply();
            return Collections.emptyList();
        }
        return this.conn.getObjectMultiBulkReply();
    }

    public List<Object> getAll() {
        return this.conn.getAll();
    }

    public Object getOne() {
        return this.conn.getOne();
    }

    public boolean isConnected() {
        return this.conn.isConnected();
    }

    public void setTimeoutInfinite() {
        this.conn.setTimeoutInfinite();
    }

    public void rollbackTimeout() {
        this.conn.rollbackTimeout();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LIST_POSITION {
        BEFORE,
        AFTER;

    }
}

