/*
 * Decompiled with CFR 0.152.
 */
package org.idevlab.rjc.sharding;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.idevlab.rjc.Client;
import org.idevlab.rjc.ElementScore;
import org.idevlab.rjc.RedisOperations;
import org.idevlab.rjc.SortingParams;
import org.idevlab.rjc.sharding.NodeLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShardedRedis
implements RedisOperations {
    private NodeLocator<? extends RedisOperations> locator;

    public ShardedRedis() {
    }

    public ShardedRedis(NodeLocator<? extends RedisOperations> locator) {
        this.locator = locator;
    }

    public void setLocator(NodeLocator<? extends RedisOperations> locator) {
        this.locator = locator;
    }

    @Override
    public String set(String key, String value) {
        return this.locator.getNode(key).set(key, value);
    }

    @Override
    public String get(String key) {
        return this.locator.getNode(key).get(key);
    }

    @Override
    public Boolean exists(String key) {
        return this.locator.getNode(key).exists(key);
    }

    @Override
    public Long del(String ... keys) {
        long result = 0L;
        for (RedisOperations redisOperations : this.locator.getNodes()) {
            result += redisOperations.del(keys).longValue();
        }
        return result;
    }

    @Override
    public String type(String key) {
        return this.locator.getNode(key).type(key);
    }

    @Override
    public Boolean expire(String key, int seconds) {
        return this.locator.getNode(key).expire(key, seconds);
    }

    @Override
    public Boolean expireAt(String key, long unixTime) {
        return this.locator.getNode(key).expireAt(key, unixTime);
    }

    @Override
    public Long ttl(String key) {
        return this.locator.getNode(key).ttl(key);
    }

    @Override
    public String getSet(String key, String value) {
        return this.locator.getNode(key).getSet(key, value);
    }

    @Override
    public Boolean setnx(String key, String value) {
        return this.locator.getNode(key).setnx(key, value);
    }

    @Override
    public String setex(String key, int seconds, String value) {
        return this.locator.getNode(key).setex(key, seconds, value);
    }

    @Override
    public Long decrBy(String key, int value) {
        return this.locator.getNode(key).decrBy(key, value);
    }

    @Override
    public Long decr(String key) {
        return this.locator.getNode(key).decr(key);
    }

    @Override
    public Long incrBy(String key, int value) {
        return this.locator.getNode(key).incrBy(key, value);
    }

    @Override
    public Long incr(String key) {
        return this.locator.getNode(key).incr(key);
    }

    @Override
    public Long append(String key, String value) {
        return this.locator.getNode(key).append(key, value);
    }

    @Override
    public String getRange(String key, int start, int end) {
        return this.locator.getNode(key).getRange(key, start, end);
    }

    @Override
    public Long setRange(String key, int offset, String value) {
        return this.locator.getNode(key).setRange(key, offset, value);
    }

    @Override
    public Long strlen(String key) {
        return this.locator.getNode(key).strlen(key);
    }

    @Override
    public Set<String> keys(String pattern) {
        HashSet<String> result = new HashSet<String>();
        for (RedisOperations redisOperations : this.locator.getNodes()) {
            result.addAll(redisOperations.keys(pattern));
        }
        return result;
    }

    @Override
    public Boolean persist(String key) {
        return this.locator.getNode(key).persist(key);
    }

    @Override
    public Boolean hset(String key, String field, String value) {
        return this.locator.getNode(key).hset(key, field, value);
    }

    @Override
    public String hget(String key, String field) {
        return this.locator.getNode(key).hget(key, field);
    }

    @Override
    public Boolean hsetnx(String key, String field, String value) {
        return this.locator.getNode(key).hsetnx(key, field, value);
    }

    @Override
    public String hmset(String key, Map<String, String> hash) {
        return this.locator.getNode(key).hmset(key, hash);
    }

    @Override
    public List<String> hmget(String key, String ... fields) {
        return this.locator.getNode(key).hmget(key, fields);
    }

    @Override
    public Long hincrBy(String key, String field, int value) {
        return this.locator.getNode(key).hincrBy(key, field, value);
    }

    @Override
    public Boolean hexists(String key, String field) {
        return this.locator.getNode(key).hexists(key, field);
    }

    @Override
    public Boolean hdel(String key, String field) {
        return this.locator.getNode(key).hdel(key, field);
    }

    @Override
    public Long hlen(String key) {
        return this.locator.getNode(key).hlen(key);
    }

    @Override
    public Set<String> hkeys(String key) {
        return this.locator.getNode(key).hkeys(key);
    }

    @Override
    public List<String> hvals(String key) {
        return this.locator.getNode(key).hvals(key);
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        return this.locator.getNode(key).hgetAll(key);
    }

    @Override
    public Long rpush(String key, String value) {
        return this.locator.getNode(key).rpush(key, value);
    }

    @Override
    public Long rpushx(String key, String value) {
        return this.locator.getNode(key).rpushx(key, value);
    }

    @Override
    public Long lpush(String key, String value) {
        return this.locator.getNode(key).lpush(key, value);
    }

    @Override
    public Long lpushx(String key, String value) {
        return this.locator.getNode(key).lpushx(key, value);
    }

    @Override
    public Long llen(String key) {
        return this.locator.getNode(key).llen(key);
    }

    @Override
    public List<String> lrange(String key, int start, int end) {
        return this.locator.getNode(key).lrange(key, start, end);
    }

    @Override
    public String ltrim(String key, int start, int end) {
        return this.locator.getNode(key).ltrim(key, start, end);
    }

    @Override
    public String lindex(String key, int index) {
        return this.locator.getNode(key).lindex(key, index);
    }

    @Override
    public String lset(String key, int index, String value) {
        return this.locator.getNode(key).lset(key, index, value);
    }

    @Override
    public Long lrem(String key, int count, String value) {
        return this.locator.getNode(key).lrem(key, count, value);
    }

    @Override
    public String lpop(String key) {
        return this.locator.getNode(key).lpop(key);
    }

    @Override
    public String rpop(String key) {
        return this.locator.getNode(key).rpop(key);
    }

    @Override
    public Boolean sadd(String key, String member) {
        return this.locator.getNode(key).sadd(key, member);
    }

    @Override
    public Set<String> smembers(String key) {
        return this.locator.getNode(key).smembers(key);
    }

    @Override
    public Boolean srem(String key, String member) {
        return this.locator.getNode(key).srem(key, member);
    }

    @Override
    public String spop(String key) {
        return this.locator.getNode(key).spop(key);
    }

    @Override
    public Long scard(String key) {
        return this.locator.getNode(key).scard(key);
    }

    @Override
    public Boolean sismember(String key, String member) {
        return this.locator.getNode(key).sismember(key, member);
    }

    @Override
    public String srandmember(String key) {
        return this.locator.getNode(key).srandmember(key);
    }

    @Override
    public Boolean zadd(String key, Number score, String member) {
        return this.locator.getNode(key).zadd(key, score, member);
    }

    @Override
    public List<String> zrange(String key, int start, int end) {
        return this.locator.getNode(key).zrange(key, start, end);
    }

    @Override
    public Boolean zrem(String key, String member) {
        return this.locator.getNode(key).zrem(key, member);
    }

    @Override
    public String zincrby(String key, Number score, String member) {
        return this.locator.getNode(key).zincrby(key, score, member);
    }

    @Override
    public Long zrank(String key, String member) {
        return this.locator.getNode(key).zrank(key, member);
    }

    @Override
    public Long zrevrank(String key, String member) {
        return this.locator.getNode(key).zrevrank(key, member);
    }

    @Override
    public List<String> zrevrange(String key, int start, int end) {
        return this.locator.getNode(key).zrevrange(key, start, end);
    }

    @Override
    public List<ElementScore> zrangeWithScores(String key, int start, int end) {
        return this.locator.getNode(key).zrangeWithScores(key, start, end);
    }

    @Override
    public List<ElementScore> zrevrangeWithScores(String key, int start, int end) {
        return this.locator.getNode(key).zrevrangeWithScores(key, start, end);
    }

    @Override
    public List<String> zrevrangeByScore(String key, String max, String min) {
        return this.locator.getNode(key).zrevrangeByScore(key, max, min);
    }

    @Override
    public List<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        return this.locator.getNode(key).zrevrangeByScore(key, max, min, offset, count);
    }

    @Override
    public List<ElementScore> zrevrangeByScoreWithScores(String key, String max, String min) {
        return this.locator.getNode(key).zrevrangeByScoreWithScores(key, max, min);
    }

    @Override
    public List<ElementScore> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        return this.locator.getNode(key).zrevrangeByScoreWithScores(key, max, min, offset, count);
    }

    @Override
    public Long zcard(String key) {
        return this.locator.getNode(key).zcard(key);
    }

    @Override
    public String zscore(String key, String member) {
        return this.locator.getNode(key).zscore(key, member);
    }

    @Override
    public List<String> sort(String key) {
        return this.locator.getNode(key).sort(key);
    }

    @Override
    public List<String> sort(String key, SortingParams sortingParameters) {
        return this.locator.getNode(key).sort(key, sortingParameters);
    }

    @Override
    public Long zcount(String key, Number min, Number max) {
        return this.locator.getNode(key).zcount(key, min, max);
    }

    @Override
    public List<String> zrangeByScore(String key, String min, String max) {
        return this.locator.getNode(key).zrangeByScore(key, min, max);
    }

    @Override
    public List<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        return this.locator.getNode(key).zrangeByScore(key, min, max, offset, count);
    }

    @Override
    public List<ElementScore> zrangeByScoreWithScores(String key, String min, String max) {
        return this.locator.getNode(key).zrangeByScoreWithScores(key, min, max);
    }

    @Override
    public List<ElementScore> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        return this.locator.getNode(key).zrangeByScoreWithScores(key, min, max, offset, count);
    }

    @Override
    public Long zremrangeByRank(String key, int start, int end) {
        return this.locator.getNode(key).zremrangeByRank(key, start, end);
    }

    @Override
    public Long zremrangeByScore(String key, String min, String max) {
        return this.locator.getNode(key).zremrangeByScore(key, min, max);
    }

    @Override
    public Long linsert(String key, Client.LIST_POSITION where, String pivot, String value) {
        return this.locator.getNode(key).linsert(key, where, pivot, value);
    }

    @Override
    public Long publish(String channel, String message) {
        return this.locator.getNode(channel).publish(channel, message);
    }

    @Override
    public Long getBit(String key, int offset) {
        return this.locator.getNode(key).getBit(key, offset);
    }

    @Override
    public Long setBit(String key, int offset, String value) {
        return this.locator.getNode(key).setBit(key, offset, value);
    }
}

