/*
 * Decompiled with CFR 0.152.
 */
package krati.core;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Set;
import krati.core.InvalidStoreConfigException;
import krati.core.StoreParams;
import krati.core.segment.MappedSegmentFactory;
import krati.core.segment.SegmentFactory;
import krati.util.FnvHashFunction;
import krati.util.HashFunction;
import org.apache.log4j.Logger;

public class StoreConfig
extends StoreParams {
    public static final String CONFIG_PROPERTIES_FILE = "config.properties";
    private static final Logger _logger = Logger.getLogger(StoreConfig.class);
    private final File _homeDir;
    private final int _initialCapacity;
    private SegmentFactory _segmentFactory = null;
    private HashFunction<byte[]> _hashFunction = null;

    public StoreConfig(File homeDir, int initialCapacity) throws IOException {
        if (!homeDir.exists()) {
            homeDir.mkdirs();
        }
        if (homeDir.isFile()) {
            throw new IOException("Invalid homeDir: " + homeDir.getAbsolutePath());
        }
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("Invalid initialCapacity: " + initialCapacity);
        }
        this._homeDir = homeDir;
        this._initialCapacity = initialCapacity;
        this._properties.setProperty("krati.store.initial.capacity", this._initialCapacity + "");
        this.setSegmentFactory(new MappedSegmentFactory());
        this.setHashFunction(new FnvHashFunction());
        File file = new File(homeDir, CONFIG_PROPERTIES_FILE);
        if (file.exists()) {
            this.load(file);
            this.validate();
        } else {
            this.save();
        }
    }

    StoreConfig(File homeDir, int partitionStart, int partitionCount) throws IOException {
        if (!homeDir.exists()) {
            homeDir.mkdirs();
        }
        if (homeDir.isFile()) {
            throw new IOException("Invalid homeDir: " + homeDir.getAbsolutePath());
        }
        if (partitionStart < 0) {
            throw new IllegalArgumentException("Invalid partitionStart: " + partitionStart);
        }
        if (partitionCount < 1) {
            throw new IllegalArgumentException("Invalid partitionCount: " + partitionCount);
        }
        long partitionEnd = (long)partitionStart + (long)partitionCount;
        if (partitionEnd > Integer.MAX_VALUE) {
            throw new InvalidStoreConfigException("Invalid partition: start=" + partitionStart + " count=" + partitionCount);
        }
        this._homeDir = homeDir;
        this._initialCapacity = partitionCount;
        this._properties.setProperty("krati.store.initial.capacity", this._initialCapacity + "");
        this._properties.setProperty("krati.store.partition.start", partitionStart + "");
        this._properties.setProperty("krati.store.partition.count", partitionCount + "");
        this.setSegmentFactory(new MappedSegmentFactory());
        this.setHashFunction(new FnvHashFunction());
        File file = new File(homeDir, CONFIG_PROPERTIES_FILE);
        if (file.exists()) {
            this.load(file);
            this.validate();
        } else {
            this.save();
        }
    }

    public final File getHomeDir() {
        return this._homeDir;
    }

    public final int getInitialCapacity() {
        return this._initialCapacity;
    }

    public void list(PrintStream out) {
        this._properties.list(out);
    }

    public void list(PrintWriter out) {
        this._properties.list(out);
    }

    public void load() throws IOException {
        this.load(new File(this.getHomeDir(), CONFIG_PROPERTIES_FILE));
    }

    public void load(File propertiesFile) throws IOException {
        FileReader reader = new FileReader(propertiesFile);
        this._properties.load(reader);
        ((Reader)reader).close();
        String paramName = "krati.store.indexes.cached";
        String paramValue = this._properties.getProperty(paramName);
        this.setIndexesCached(StoreConfig.parseBoolean(paramName, paramValue, true));
        paramName = "krati.store.batchSize";
        paramValue = this._properties.getProperty(paramName);
        this.setBatchSize(StoreConfig.parseInt(paramName, paramValue, 10000));
        paramName = "krati.store.numSyncBatches";
        paramValue = this._properties.getProperty(paramName);
        this.setNumSyncBatches(StoreConfig.parseInt(paramName, paramValue, 5));
        paramName = "krati.store.segment.file.size";
        paramValue = this._properties.getProperty(paramName);
        this.setSegmentFileSizeMB(StoreConfig.parseInt(paramName, paramValue, 256));
        paramName = "krati.store.segment.compact.factor";
        paramValue = this._properties.getProperty(paramName);
        this.setSegmentCompactFactor(StoreConfig.parseDouble(paramName, paramValue, 0.5));
        paramName = "krati.store.hash.load.factor";
        paramValue = this._properties.getProperty(paramName);
        this.setHashLoadFactor(StoreConfig.parseDouble(paramName, paramValue, 0.75));
        paramName = "krati.store.segment.factory.class";
        paramValue = this._properties.getProperty(paramName);
        SegmentFactory segmentFactory = null;
        if (paramValue != null) {
            try {
                segmentFactory = Class.forName(paramValue).asSubclass(SegmentFactory.class).newInstance();
            }
            catch (Exception e) {
                _logger.warn((Object)("Invalid SegmentFactory class: " + paramValue));
            }
        }
        if (segmentFactory == null) {
            segmentFactory = new MappedSegmentFactory();
        }
        this.setSegmentFactory(segmentFactory);
        paramName = "krati.store.hash.function.class";
        paramValue = this._properties.getProperty(paramName);
        HashFunction hashFunction = null;
        if (paramValue != null) {
            try {
                hashFunction = (HashFunction)Class.forName(paramValue).newInstance();
            }
            catch (Exception e) {
                _logger.warn((Object)("Invalid HashFunction<byte[]> class: " + paramValue));
            }
        }
        if (hashFunction == null) {
            hashFunction = new FnvHashFunction();
        }
        this.setHashFunction(hashFunction);
    }

    public void save() throws IOException {
        this.save(new File(this.getHomeDir(), CONFIG_PROPERTIES_FILE), null);
    }

    public void save(File propertiesFile, String comments) throws IOException {
        FileWriter writer = new FileWriter(propertiesFile);
        this._properties.store(writer, comments);
        writer.close();
    }

    public void validate() throws InvalidStoreConfigException {
        if (this.getSegmentFactory() == null) {
            throw new InvalidStoreConfigException("Segment factory not found");
        }
        if (this.getHashFunction() == null) {
            throw new InvalidStoreConfigException("Store hash function not found");
        }
        if (this.getBatchSize() < 1) {
            throw new InvalidStoreConfigException("krati.store.batchSize=" + this.getBatchSize());
        }
        if (this.getNumSyncBatches() < 1) {
            throw new InvalidStoreConfigException("krati.store.numSyncBatches=" + this.getNumSyncBatches());
        }
        if (this.getHashLoadFactor() < 0.5 || this.getHashLoadFactor() > 1.0) {
            throw new InvalidStoreConfigException("krati.store.hash.load.factor=" + this.getHashLoadFactor());
        }
        if (this.getSegmentFileSizeMB() < 8 || this.getSegmentFileSizeMB() > 2048) {
            throw new InvalidStoreConfigException("krati.store.segment.file.size=" + this.getSegmentFileSizeMB());
        }
        if (this.getSegmentCompactFactor() < 0.0 || this.getSegmentCompactFactor() > 0.75) {
            throw new InvalidStoreConfigException("krati.store.segment.compact.factor=" + this.getSegmentCompactFactor());
        }
    }

    public Set<String> propertyNames() {
        return this._properties.stringPropertyNames();
    }

    public String getProperty(String pName) {
        return this._properties.getProperty(pName);
    }

    public boolean setProperty(String pName, String pValue) {
        if (pName == null) {
            return false;
        }
        this._properties.setProperty(pName, pValue);
        return true;
    }

    static int parseInt(String pName, String pValue, int defaultValue) {
        try {
            if (pValue != null) {
                return Integer.parseInt(pValue);
            }
        }
        catch (Exception e) {
            _logger.error((Object)("failed to parse " + pName + "=" + pValue));
        }
        return defaultValue;
    }

    static double parseDouble(String pName, String pValue, double defaultValue) {
        try {
            if (pValue != null) {
                return Double.parseDouble(pValue);
            }
        }
        catch (Exception e) {
            _logger.error((Object)("failed to parse " + pName + "=" + pValue));
        }
        return defaultValue;
    }

    static boolean parseBoolean(String pName, String pValue, boolean defaultValue) {
        try {
            if (pValue != null) {
                return Boolean.parseBoolean(pValue);
            }
        }
        catch (Exception e) {
            _logger.error((Object)("failed to parse " + pName + "=" + pValue));
        }
        return defaultValue;
    }

    public void setSegmentFactory(SegmentFactory segmentFactory) {
        if (segmentFactory == null) {
            throw new IllegalArgumentException("Invalid segmentFactory: " + segmentFactory);
        }
        this._segmentFactory = segmentFactory;
        this._properties.setProperty("krati.store.segment.factory.class", segmentFactory.getClass().getName());
    }

    public SegmentFactory getSegmentFactory() {
        return this._segmentFactory;
    }

    public void setHashFunction(HashFunction<byte[]> hashFunction) {
        if (hashFunction == null) {
            throw new IllegalArgumentException("Invalid hashFunction: " + hashFunction);
        }
        this._hashFunction = hashFunction;
        this._properties.setProperty("krati.store.hash.function.class", hashFunction.getClass().getName());
    }

    public HashFunction<byte[]> getHashFunction() {
        return this._hashFunction;
    }
}

