/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array.basic;

import java.io.File;
import java.io.IOException;
import java.util.List;
import krati.Mode;
import krati.array.Array;
import krati.array.DynamicArray;
import krati.core.OperationAbortedException;
import krati.core.array.AddressArray;
import krati.core.array.basic.AbstractRecoverableArray;
import krati.core.array.entry.Entry;
import krati.core.array.entry.EntryLongFactory;
import krati.core.array.entry.EntryPersistListener;
import krati.core.array.entry.EntryValueLong;
import org.apache.log4j.Logger;

public class IOTypeLongArray
extends AbstractRecoverableArray<EntryValueLong>
implements AddressArray,
DynamicArray {
    private static final int _subArrayBits = 16;
    private static final int _subArraySize = 65536;
    private static final Logger _logger = Logger.getLogger(IOTypeLongArray.class);
    private final Array.Type _type;
    private volatile Mode _mode = Mode.INIT;

    public IOTypeLongArray(Array.Type type, int length, int batchSize, int numSyncBatches, File directory) throws Exception {
        super(length, 8, batchSize, numSyncBatches, directory, new EntryLongFactory());
        this._type = type != null ? type : Array.Type.DYNAMIC;
        this._mode = Mode.OPEN;
    }

    @Override
    protected Logger getLogger() {
        return _logger;
    }

    @Override
    protected void loadArrayFileData() {
        long maxScn = this._arrayFile.getLwmScn();
        this._entryManager.setWaterMarks(maxScn, maxScn);
    }

    @Override
    public void saveHWMark(long endOfPeriod) {
        if (this.getHWMark() < endOfPeriod) {
            try {
                this.set(0, this.get(0), endOfPeriod);
            }
            catch (Exception e) {
                _logger.error((Object)("Failed to saveHWMark " + endOfPeriod), (Throwable)e);
            }
        } else if (0L < endOfPeriod && endOfPeriod < this.getLWMark()) {
            try {
                this._entryManager.sync();
            }
            catch (Exception e) {
                _logger.error((Object)("Failed to saveHWMark" + endOfPeriod), (Throwable)e);
            }
            this._entryManager.setWaterMarks(endOfPeriod, endOfPeriod);
        }
    }

    @Override
    public void clear() {
        this._entryManager.clear();
        try {
            this._arrayFile.resetAll(0L, this._entryManager.getHWMark());
        }
        catch (IOException e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected long getPosition(int index) {
        return 1024L + ((long)index << 3);
    }

    @Override
    public long get(int index) {
        if (index < 0 || index >= this._length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        try {
            return this._arrayFile.getBasicIO().readLong(this.getPosition(index));
        }
        catch (IOException e) {
            throw new OperationAbortedException("Read aborted at index " + index, e);
        }
    }

    @Override
    public void set(int index, long value, long scn) throws Exception {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (this._type == Array.Type.DYNAMIC) {
            this.expandCapacity(index);
        } else if (this._type == Array.Type.STATIC && index >= this._length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this._arrayFile.getBasicIO().writeLong(this.getPosition(index), value);
        this._entryManager.addToPreFillEntryLong(index, value, scn);
    }

    @Override
    public void setCompactionAddress(int index, long address, long scn) throws Exception {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.expandCapacity(index);
        this._arrayFile.getBasicIO().writeLong(this.getPosition(index), address);
        this._entryManager.addToPreFillEntryLongCompaction(index, address, scn);
    }

    @Override
    public long[] getInternalArray() {
        try {
            return this._arrayFile.loadLongArray();
        }
        catch (IOException e) {
            throw new OperationAbortedException(e);
        }
    }

    @Override
    public EntryPersistListener getPersistListener() {
        return this.getEntryManager().getEntryPersistListener();
    }

    @Override
    public void setPersistListener(EntryPersistListener persistListener) {
        this.getEntryManager().setEntryPersistListener(persistListener);
    }

    @Override
    public void expandCapacity(int index) throws Exception {
        int newLength;
        if (index < this._length) {
            return;
        }
        if (this._type == Array.Type.STATIC) {
            throw new UnsupportedOperationException("Array is of type " + (Object)((Object)this._type));
        }
        long capacity = ((long)(index >> 16) + 1L) * 65536L;
        this._length = newLength = capacity < Integer.MAX_VALUE ? (int)capacity : Integer.MAX_VALUE;
        this._arrayFile.setArrayLength(newLength, null);
        _logger.info((Object)("Expanded: _length=" + this._length));
    }

    @Override
    public synchronized void close() throws IOException {
        if (this._mode == Mode.CLOSED) {
            return;
        }
        try {
            this.sync();
            this._entryManager.clear();
            this._arrayFile.close();
        }
        catch (Exception e) {
            throw e instanceof IOException ? (IOException)e : new IOException(e);
        }
        finally {
            this._arrayFile = null;
            this._length = 0;
            this._mode = Mode.CLOSED;
        }
    }

    @Override
    public synchronized void open() throws IOException {
        if (this._mode == Mode.OPEN) {
            return;
        }
        File file = new File(this._directory, "indexes.dat");
        this._arrayFile = this.openArrayFile(file, this._length, 8);
        this._length = this._arrayFile.getArrayLength();
        this.init();
        this._mode = Mode.OPEN;
        this.getLogger().info((Object)("length:" + this._length + " batchSize:" + this._entryManager.getMaxEntrySize() + " numSyncBatches:" + this._entryManager.getMaxEntries() + " directory:" + this._directory.getAbsolutePath() + " arrayFile:" + this._arrayFile.getName()));
    }

    @Override
    public boolean isOpen() {
        return this._mode == Mode.OPEN;
    }

    @Override
    public void updateArrayFile(List<Entry<EntryValueLong>> entryList) throws IOException {
        if (this._arrayFile != null) {
            if (this.isOpen()) {
                this._arrayFile.flush();
                long maxScn = 0L;
                if (entryList != null && entryList.size() > 0) {
                    for (Entry e : entryList) {
                        maxScn = Math.max(e.getMaxScn(), maxScn);
                    }
                } else {
                    maxScn = this.getHWMark();
                }
                if (maxScn > 0L) {
                    this._arrayFile.setWaterMarks(maxScn, maxScn);
                }
            } else {
                this._arrayFile.update(entryList);
            }
        }
    }

    @Override
    public final Array.Type getType() {
        return this._type;
    }
}

