/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array.basic;

import java.util.Arrays;
import krati.array.Array;
import krati.array.DynamicArray;
import krati.array.IntArray;
import krati.core.array.basic.ArrayExpandListener;

public class MemoryIntArray
implements IntArray,
DynamicArray {
    protected int[][] _subArrays;
    protected final int _subArrayBits;
    protected final int _subArraySize;
    protected final int _subArrayMask;
    protected final boolean _autoExpand;
    private ArrayExpandListener _expandListener;

    public MemoryIntArray() {
        this(16, true);
    }

    public MemoryIntArray(int subArrayBits) {
        this(subArrayBits, true);
    }

    public MemoryIntArray(int subArrayBits, boolean autoExpand) {
        this._subArrayBits = subArrayBits;
        this._subArraySize = 1 << subArrayBits;
        this._subArrayMask = this._subArraySize - 1;
        this._subArrays = new int[1][this._subArraySize];
        this._autoExpand = autoExpand;
    }

    @Override
    public void clear() {
        for (int[] subArray : this._subArrays) {
            Arrays.fill(subArray, 0);
        }
    }

    @Override
    public int length() {
        long len = (long)this._subArrays.length * (long)this._subArraySize;
        return len < Integer.MAX_VALUE ? (int)len : Integer.MAX_VALUE;
    }

    @Override
    public boolean hasIndex(int index) {
        return index < 0 ? false : index >> this._subArrayBits < this._subArrays.length;
    }

    @Override
    public int get(int index) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int subInd = index >> this._subArrayBits;
        int offset = index & this._subArrayMask;
        return this._subArrays[subInd][offset];
    }

    public void set(int index, int value) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int subInd = index >> this._subArrayBits;
        int offset = index & this._subArrayMask;
        if (subInd >= this._subArrays.length && this._autoExpand) {
            this.expandCapacity(index);
        }
        this._subArrays[subInd][offset] = value;
    }

    @Override
    public void set(int index, int value, long scn) throws Exception {
        this.set(index, value);
    }

    @Override
    public synchronized void expandCapacity(int index) {
        int i;
        if (index < 0) {
            return;
        }
        int numSubArrays = (index >> this._subArrayBits) + 1;
        if (numSubArrays <= this._subArrays.length) {
            return;
        }
        int[][] tmpArrays = new int[numSubArrays][];
        for (i = 0; i < this._subArrays.length; ++i) {
            tmpArrays[i] = this._subArrays[i];
        }
        while (i < numSubArrays) {
            tmpArrays[i] = new int[this._subArraySize];
            ++i;
        }
        this._subArrays = tmpArrays;
        if (this.getArrayExpandListener() != null) {
            this.getArrayExpandListener().arrayExpanded(this);
        }
    }

    @Override
    public synchronized int[] getInternalArray() {
        int size = this.length();
        int[] result = new int[size];
        for (int i = 0; i < this._subArrays.length; ++i) {
            int len = Math.min(this._subArraySize, size);
            System.arraycopy(this._subArrays[i], 0, result, i * this._subArraySize, len);
            size -= this._subArraySize;
        }
        return result;
    }

    protected void setArrayExpandListener(ArrayExpandListener listener) {
        this._expandListener = listener;
    }

    protected ArrayExpandListener getArrayExpandListener() {
        return this._expandListener;
    }

    @Override
    public final Array.Type getType() {
        return Array.Type.DYNAMIC;
    }
}

