/*
 * Decompiled with CFR 0.152.
 */
package krati.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import krati.io.DataReader;

public class MappedReader
implements DataReader {
    private final File _file;
    private RandomAccessFile _raf;
    private MappedByteBuffer _mmapBuffer;

    public MappedReader(File file) {
        this._file = file;
    }

    @Override
    public File getFile() {
        return this._file;
    }

    @Override
    public void open() throws IOException {
        if (!this._file.exists()) {
            throw new IOException("Cannot find file " + this._file.getAbsolutePath());
        }
        if (this._file.isDirectory()) {
            throw new IOException("Cannot open directory " + this._file.getAbsolutePath());
        }
        this._raf = new RandomAccessFile(this._file, "r");
        long size = Math.min(this._raf.length(), Integer.MAX_VALUE);
        this._mmapBuffer = this._raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this._raf.close();
        }
        finally {
            this._raf = null;
        }
    }

    @Override
    public int readInt() throws IOException {
        return this._mmapBuffer.getInt();
    }

    @Override
    public long readLong() throws IOException {
        return this._mmapBuffer.getLong();
    }

    @Override
    public short readShort() throws IOException {
        return this._mmapBuffer.getShort();
    }

    @Override
    public int readInt(long position) throws IOException {
        return this._mmapBuffer.getInt((int)position);
    }

    @Override
    public long readLong(long position) throws IOException {
        return this._mmapBuffer.getLong((int)position);
    }

    @Override
    public short readShort(long position) throws IOException {
        return this._mmapBuffer.getShort((int)position);
    }

    @Override
    public long position() throws IOException {
        return this._mmapBuffer.position();
    }

    @Override
    public void position(long newPosition) throws IOException {
        this._mmapBuffer.position((int)newPosition);
    }
}

