/*
 * Decompiled with CFR 0.152.
 */
package krati.sos;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import krati.io.Serializer;

public class ObjectStoreIterator<K, V>
implements Iterator<Map.Entry<K, V>> {
    private final Iterator<Map.Entry<byte[], byte[]>> _rawIterator;
    private final Serializer<K> _keySerializer;
    private final Serializer<V> _valSerializer;

    public ObjectStoreIterator(Iterator<Map.Entry<byte[], byte[]>> rawKeyIterator, Serializer<K> keySerializer, Serializer<V> valSerializer) {
        this._rawIterator = rawKeyIterator;
        this._keySerializer = keySerializer;
        this._valSerializer = valSerializer;
    }

    @Override
    public boolean hasNext() {
        return this._rawIterator.hasNext();
    }

    @Override
    public Map.Entry<K, V> next() {
        Map.Entry<byte[], byte[]> entry = this._rawIterator.next();
        return entry == null ? null : new AbstractMap.SimpleEntry<K, V>(this._keySerializer.deserialize(entry.getKey()), this._valSerializer.deserialize(entry.getValue()));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

