/*
 * Decompiled with CFR 0.152.
 */
package krati.sos;

import java.io.IOException;
import krati.array.Array;
import krati.array.DynamicArray;
import krati.io.Serializer;
import krati.sos.ObjectPartition;
import krati.store.ArrayStorePartition;

public class SerializableObjectPartition<T>
implements ObjectPartition<T> {
    protected final ArrayStorePartition _partition;
    protected final Serializer<T> _serializer;

    public SerializableObjectPartition(ArrayStorePartition partition, Serializer<T> serializer) {
        this._partition = partition;
        this._serializer = serializer;
    }

    protected ArrayStorePartition getContentPartition() {
        return this._partition;
    }

    public Serializer<T> getSerializer() {
        return this._serializer;
    }

    @Override
    public int getObjectIdCount() {
        return this._partition.getIdCount();
    }

    @Override
    public int getObjectIdStart() {
        return this._partition.getIdStart();
    }

    @Override
    public T get(int objectId) {
        return this.getSerializer().deserialize(this._partition.get(objectId));
    }

    @Override
    public boolean set(int objectId, T object, long scn) throws Exception {
        if (object == null) {
            return this.delete(objectId, scn);
        }
        this._partition.set(objectId, this.getSerializer().serialize(object), scn);
        return true;
    }

    @Override
    public boolean delete(int objectId, long scn) throws Exception {
        this._partition.delete(objectId, scn);
        return true;
    }

    @Override
    public void sync() throws IOException {
        this._partition.sync();
    }

    @Override
    public void persist() throws IOException {
        this._partition.persist();
    }

    @Override
    public void clear() {
        this._partition.clear();
    }

    @Override
    public long getHWMark() {
        return this._partition.getHWMark();
    }

    @Override
    public long getLWMark() {
        return this._partition.getLWMark();
    }

    @Override
    public void saveHWMark(long endOfPeriod) throws Exception {
        this._partition.saveHWMark(endOfPeriod);
    }

    @Override
    public byte[] getBytes(int objectId) {
        return this._partition.get(objectId);
    }

    @Override
    public void expandCapacity(int index) throws Exception {
        if (!(this instanceof DynamicArray)) {
            throw new UnsupportedOperationException();
        }
        this.expandCapacity(index);
    }

    @Override
    public boolean hasIndex(int index) {
        return this._partition.hasIndex(index);
    }

    @Override
    public int length() {
        return this._partition.length();
    }

    @Override
    public boolean isOpen() {
        return this._partition.isOpen();
    }

    @Override
    public void open() throws IOException {
        this._partition.open();
    }

    @Override
    public void close() throws IOException {
        this._partition.close();
    }

    @Override
    public final Array.Type getType() {
        return this._partition.getType();
    }
}

