/*
 * Decompiled with CFR 0.152.
 */
package krati.sos;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import krati.io.Serializer;
import krati.sos.ObjectStore;
import krati.sos.ObjectStoreIterator;
import krati.sos.ObjectStoreKeyIterator;
import krati.store.DataStore;
import krati.store.StoreClosedException;

public class SerializableObjectStore<K, V>
implements ObjectStore<K, V> {
    protected final DataStore<byte[], byte[]> _store;
    protected final Serializer<K> _keySerializer;
    protected final Serializer<V> _valSerializer;

    public SerializableObjectStore(DataStore<byte[], byte[]> store, Serializer<K> keySerializer, Serializer<V> valSerializer) {
        this._store = store;
        this._keySerializer = keySerializer;
        this._valSerializer = valSerializer;
    }

    protected DataStore<byte[], byte[]> getStore() {
        return this._store;
    }

    public Serializer<K> getKeySerializer() {
        return this._keySerializer;
    }

    @Override
    public final int capacity() {
        return this._store.capacity();
    }

    public Serializer<V> getValueSerializer() {
        return this._valSerializer;
    }

    @Override
    public V get(K key) {
        return this.getValueSerializer().deserialize(this._store.get(this.getKeySerializer().serialize(key)));
    }

    @Override
    public byte[] getBytes(K key) {
        return this._store.get(this.getKeySerializer().serialize(key));
    }

    @Override
    public byte[] getBytes(byte[] keyBytes) {
        return this._store.get(keyBytes);
    }

    @Override
    public boolean put(K key, V value) throws Exception {
        return this._store.put(this.getKeySerializer().serialize(key), this.getValueSerializer().serialize(value));
    }

    @Override
    public boolean delete(K key) throws Exception {
        return this._store.delete(this.getKeySerializer().serialize(key));
    }

    @Override
    public void sync() throws IOException {
        this._store.sync();
    }

    @Override
    public void persist() throws IOException {
        this._store.persist();
    }

    @Override
    public void clear() throws IOException {
        this._store.clear();
    }

    @Override
    public Iterator<K> keyIterator() {
        if (this._store.isOpen()) {
            return new ObjectStoreKeyIterator<K>(this._store.keyIterator(), this._keySerializer);
        }
        throw new StoreClosedException();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        if (this._store.isOpen()) {
            return new ObjectStoreIterator<K, V>(this._store.iterator(), this._keySerializer, this._valSerializer);
        }
        throw new StoreClosedException();
    }

    @Override
    public boolean isOpen() {
        return this._store.isOpen();
    }

    @Override
    public void open() throws IOException {
        this._store.open();
    }

    @Override
    public void close() throws IOException {
        this._store.close();
    }
}

