/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.io.File;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import krati.Persistable;
import krati.array.Array;
import krati.array.DataArray;
import krati.core.StoreConfig;
import krati.core.array.AddressArray;
import krati.core.array.SimpleDataArray;
import krati.core.segment.SegmentFactory;
import krati.core.segment.SegmentManager;

public abstract class AbstractDataArray
implements DataArray,
Persistable {
    protected final SimpleDataArray _dataArray;
    protected final AddressArray _addrArray;
    protected final StoreConfig _config;
    protected final String _homePath;
    protected final File _homeDir;

    protected AbstractDataArray(StoreConfig config) throws Exception {
        config.validate();
        config.save();
        this._config = config;
        this._homeDir = this._config.getHomeDir();
        this._homePath = this._homeDir.getCanonicalPath();
        this._addrArray = this.createAddressArray(this._config.getHomeDir(), this._config.getInitialCapacity(), this._config.getBatchSize(), this._config.getNumSyncBatches(), this._config.isIndexesCached());
        String segmentHome = this._homePath + File.separator + "segs";
        SegmentManager segmentManager = SegmentManager.getInstance(segmentHome, this._config.getSegmentFactory(), this._config.getSegmentFileSizeMB());
        this._dataArray = new SimpleDataArray(this._addrArray, segmentManager, this._config.getSegmentCompactFactor());
    }

    protected AbstractDataArray(int length, int batchSize, int numSyncBatches, File homeDirectory, SegmentFactory segmentFactory, int segmentFileSizeMB, double segmentCompactFactor) throws Exception {
        this._homeDir = homeDirectory;
        this._homePath = homeDirectory.getCanonicalPath();
        this._config = new StoreConfig(this._homeDir, length);
        this._config.setBatchSize(batchSize);
        this._config.setNumSyncBatches(numSyncBatches);
        this._config.setSegmentFactory(segmentFactory);
        this._config.setSegmentFileSizeMB(segmentFileSizeMB);
        this._config.setSegmentCompactFactor(segmentCompactFactor);
        this._config.validate();
        this._config.save();
        this._addrArray = this.createAddressArray(this._config.getHomeDir(), this._config.getInitialCapacity(), this._config.getBatchSize(), this._config.getNumSyncBatches(), this._config.isIndexesCached());
        String segmentHome = this._homePath + File.separator + "segs";
        SegmentManager segmentManager = SegmentManager.getInstance(segmentHome, this._config.getSegmentFactory(), this._config.getSegmentFileSizeMB());
        this._dataArray = new SimpleDataArray(this._addrArray, segmentManager, this._config.getSegmentCompactFactor());
    }

    protected abstract AddressArray createAddressArray(File var1, int var2, int var3, int var4, boolean var5) throws Exception;

    public File getHomeDir() {
        return this._homeDir;
    }

    public String getHomePath() {
        return this._homePath;
    }

    public String getStatus() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("path");
        buffer.append("=");
        buffer.append(this._homePath);
        buffer.append(" ");
        buffer.append("length");
        buffer.append("=");
        buffer.append(this.length());
        buffer.append(" ");
        buffer.append("lwMark");
        buffer.append("=");
        buffer.append(this.getLWMark());
        buffer.append(" ");
        buffer.append("hwMark");
        buffer.append("=");
        buffer.append(this.getHWMark());
        return buffer.toString();
    }

    @Override
    public int length() {
        return this._dataArray.length();
    }

    @Override
    public boolean hasIndex(int index) {
        return this._dataArray.hasIndex(index);
    }

    @Override
    public byte[] get(int index) {
        return this._dataArray.get(index);
    }

    @Override
    public int get(int index, byte[] dst) {
        return this._dataArray.get(index, dst);
    }

    @Override
    public int get(int index, byte[] dst, int offset) {
        return this._dataArray.get(index, dst, offset);
    }

    @Override
    public int getLength(int index) {
        return this._dataArray.getLength(index);
    }

    @Override
    public boolean hasData(int index) {
        return this._dataArray.hasData(index);
    }

    @Override
    public synchronized void set(int index, byte[] data, long scn) throws Exception {
        this._dataArray.set(index, data, scn);
    }

    @Override
    public synchronized void set(int index, byte[] data, int offset, int length, long scn) throws Exception {
        this._dataArray.set(index, data, offset, length, scn);
    }

    @Override
    public int transferTo(int index, WritableByteChannel channel) {
        return this._dataArray.transferTo(index, channel);
    }

    @Override
    public synchronized void clear() {
        this._dataArray.clear();
    }

    @Override
    public long getLWMark() {
        return this._dataArray.getLWMark();
    }

    @Override
    public long getHWMark() {
        return this._dataArray.getHWMark();
    }

    @Override
    public synchronized void saveHWMark(long endOfPeriod) throws Exception {
        this._dataArray.saveHWMark(endOfPeriod);
    }

    @Override
    public synchronized void persist() throws IOException {
        this._dataArray.persist();
    }

    @Override
    public synchronized void sync() throws IOException {
        this._dataArray.sync();
    }

    @Override
    public final Array.Type getType() {
        return this._addrArray.getType();
    }
}

